# Quick Admin Setup Guide

## Step 1: Configure Database

Make sure your `.env` file has Supabase credentials:

```env
DB_CONNECTION=pgsql
DB_HOST=your-project.supabase.co
DB_PORT=5432
DB_DATABASE=postgres
DB_USERNAME=postgres
DB_PASSWORD=your-password
DB_SSLMODE=require
```

## Step 2: Run Migrations

```bash
php artisan migrate
```

## Step 3: Create Admin User

Run the seeder:
```bash
php artisan db:seed --class=AdminUserSeeder
```

## Step 4: Login

Go to: `http://localhost:8000/login`

**Credentials:**
- Email: `admin@epoe.com`
- Password: `admin123`

## Alternative: Create Admin via Tinker

If seeder doesn't work, use Tinker:

```bash
php artisan tinker
```

Then paste:
```php
\App\Models\User::create([
    'name' => 'System Administrator',
    'email' => 'admin@epoe.com',
    'password' => \Illuminate\Support\Facades\Hash::make('admin123'),
    'role' => 'admin',
    'status' => 'active',
    'email_verified_at' => now(),
]);
```

Exit tinker with `exit` or `Ctrl+C`

