# EPOE System - Demo Video Script & Storyboard

## Video Overview
**Duration**: 3-5 minutes  
**Target Audience**: TVET Institution Administrators, HODs, Trainers, IT Directors  
**Style**: Professional, clear, feature-focused  
**Format**: Screen recording with voiceover and on-screen text

---

## Video Structure

### **Opening (0:00 - 0:30)**
**Visual**: 
- Animated logo/branding (3 seconds)
- Title card: "EPOE System - Electronic Portfolio of Evidence"
- Subtitle: "CBET/CDACC-Compliant Educational Management Platform"

**Voiceover**:
> "Welcome to the EPOE System - a comprehensive digital solution designed specifically for TVET institutions. Built for Competency-Based Education and Training, our platform transforms how institutions manage student portfolios, assessments, and validation workflows."

**On-screen Text**: 
- "100% CBET/CDACC Compliant"
- "6 Role-Based Portals"
- "Mobile-First Design"

---

### **Section 1: The Challenge (0:30 - 1:00)**
**Visual**: 
- Split screen showing:
  - Left: Paper-based workflow (messy desk, physical files)
  - Right: Digital chaos (multiple spreadsheets, email chains)
- Transition to problem statement cards

**Voiceover**:
> "TVET institutions face critical challenges: paper-based PoE management is time-consuming and error-prone. Complex validation workflows require manual coordination between multiple stakeholders. And maintaining CBET compliance requires strict adherence to assessment structures and audit trails."

**On-screen Text**:
- "Challenge 1: Paper-Based Management"
- "Challenge 2: Complex Workflows"
- "Challenge 3: CBET Compliance"

---

### **Section 2: Solution Overview (1:00 - 1:30)**
**Visual**: 
- System architecture diagram (animated)
- Six portal icons appearing one by one
- Dashboard overview (quick montage)

**Voiceover**:
> "The EPOE System provides a unified platform with six specialized portals: Admin for system management, HOD for department oversight, Trainer for assessment creation and marking, Validator for approval workflows, Student for submissions and progress tracking, and Exams Office for verification. All working together seamlessly."

**On-screen Text**:
- "Admin Portal"
- "HOD Portal"
- "Trainer Portal"
- "Validator Portal"
- "Student Portal"
- "Exams Office"

---

### **Section 3: HOD - Unit Configuration (1:30 - 2:00)**
**Visual**: 
- Screen recording: HOD portal
- Navigate to "Departmental Units"
- Click "Configure Unit"
- Show configuration form:
  - Select classification (Core Unit)
  - Set assessment structure (Theory: 3, Practical: 3, Oral: 0, Project: 0)
  - Save configuration

**Voiceover**:
> "Let's start with unit configuration. The Head of Department defines each unit's classification - Core, Basic, or Common - and sets the required assessment structure. For example, a Core Unit might require 3 Theory and 3 Practical assessments. This configuration ensures CBET compliance from the start."

**On-screen Text**:
- "Unit Classification: Core Unit"
- "Assessment Structure: 3 Theory, 3 Practical"
- "CBET Compliance Enforced"

---

### **Section 4: Trainer - Assessment Creation (2:00 - 2:30)**
**Visual**: 
- Screen recording: Trainer portal
- Navigate to "My Units"
- Select a unit
- Click "Create Assignment"
- Show form:
  - Select type (Practical)
  - Upload assessor tool
  - Set total marks
  - Publish assignment

**Voiceover**:
> "Trainers create assessments based on the unit's configured structure. For practical assessments, trainers upload assessor tools - no student submission required. The system automatically loads all enrolled students for marking. This streamlines the workflow significantly."

**On-screen Text**:
- "Assessment Type: Practical"
- "Auto-Loads All Students"
- "No Submission Required"

---

### **Section 5: Trainer - Practical Marking (2:30 - 3:00)**
**Visual**: 
- Screen recording: Practical marking interface
- Show assessor tool with procedures
- Mark a student:
  - Check procedures
  - Enter marks per procedure
  - Show live subtotal calculation
  - Save marks
- Show marking progress: "2/10 students marked"

**Voiceover**:
> "Practical marking is intuitive. Trainers mark students procedure-by-procedure using the assessor tool. The system calculates subtotals and totals in real-time. Progress is tracked automatically - you can see exactly how many students are marked, absent, or pending."

**On-screen Text**:
- "Procedure-by-Procedure Marking"
- "Real-Time Calculations"
- "Progress Tracking"

---

### **Section 6: Validation Readiness (3:00 - 3:30)**
**Visual**: 
- Screen recording: Marks Management page
- Select unit and class
- Show validation readiness panel:
  - Assessment status grid (Theory: 3/3 ✓, Practical: 2/3 ✗)
  - Issues found section
  - "Push to Validation" button (disabled)
- Complete missing assessments
- Button becomes enabled

**Voiceover**:
> "Before pushing to validation, the system automatically checks readiness. It verifies that all required assessments are completed and all students are marked. If anything is missing, it shows exactly what needs to be done. This prevents incomplete submissions from reaching validators."

**On-screen Text**:
- "Validation Readiness Check"
- "Theory: 3/3 ✓"
- "Practical: 2/3 ✗"
- "Issues Identified"

---

### **Section 7: Multi-Unit Validation (3:30 - 4:00)**
**Visual**: 
- Screen recording: Trainer pushes unit to validation
- Success message: "Unit has been added to existing class validation"
- Switch to Validator portal
- Show validation requests grouped by class
- Show class with multiple units pending
- Click to view details

**Voiceover**:
> "Multiple trainers can push different units for the same class. The system groups them together, so validators see all units for a class in one place. This flexible workflow eliminates bottlenecks and allows progressive validation."

**On-screen Text**:
- "Multi-Unit Validation"
- "Grouped by Class"
- "Progressive Workflow"

---

### **Section 8: Student Portal - Mobile (4:00 - 4:30)**
**Visual**: 
- Mobile device screen recording (or responsive view)
- Show student dashboard on mobile
- Navigate to assignments
- Show submission interface
- Show feedback and marks
- Show progress tracking

**Voiceover**:
> "Students access everything on their mobile devices. The portal is fully responsive, optimized for phones and tablets. Students can submit assignments, view feedback, track progress, and receive real-time notifications - all from their mobile devices."

**On-screen Text**:
- "Mobile-First Design"
- "100% Responsive"
- "Real-Time Notifications"

---

### **Section 9: Reporting & Analytics (4:30 - 5:00)**
**Visual**: 
- Screen recording: Reports page
- Show "Print & Export" interface
- Quick print options (Class List, Marks Sheet, Practical Sheet)
- Generate PDF preview
- Show export options (PDF, Word, Excel)
- Show bulk operations

**Voiceover**:
> "Comprehensive reporting is built-in. Generate class lists, marks sheets, and practical assessment sheets with one click. Export to PDF, Word, or Excel. Bulk operations allow you to generate multiple reports simultaneously. All reports include institution branding and compliance information."

**On-screen Text**:
- "One-Click Reports"
- "Multiple Formats"
- "Bulk Operations"

---

### **Closing (5:00 - 5:30)**
**Visual**: 
- Montage of key features (fast-paced)
- ROI metrics appearing on screen
- Call-to-action screen

**Voiceover**:
> "The EPOE System reduces administrative overhead by 70%, ensures 100% CBET compliance, and provides complete audit trails for accreditation. Transform your institution's assessment management today."

**On-screen Text**:
- "70% Time Reduction"
- "100% CBET Compliant"
- "Complete Audit Trail"
- "Request a Demo: [Website/Email]"
- "Contact: [Phone/Email]"

**Final Screen**:
- Logo
- Tagline: "Transforming TVET Education Management"
- Contact information
- QR code for demo access

---

## Production Notes

### **Technical Requirements**
- **Resolution**: 1920x1080 (Full HD)
- **Frame Rate**: 30fps
- **Audio**: Clear voiceover, background music (optional, subtle)
- **Format**: MP4 (H.264)
- **Duration**: 3-5 minutes (can create extended 10-minute version)

### **Recording Tools**
- **Screen Recording**: OBS Studio, Camtasia, or ScreenFlow
- **Audio Recording**: Audacity or professional recording studio
- **Editing**: Adobe Premiere Pro, Final Cut Pro, or DaVinci Resolve

### **Visual Elements**
- **Transitions**: Smooth fades between sections
- **Text Overlays**: Clear, readable fonts (Montserrat, Open Sans)
- **Color Scheme**: Match system branding (purple/blue theme)
- **Icons**: Use system icons or Font Awesome
- **Animations**: Subtle, professional (fade-ins, slide-ins)

### **Voiceover Guidelines**
- **Tone**: Professional, friendly, confident
- **Pace**: Clear and not rushed (150-160 words per minute)
- **Accent**: Neutral, clear pronunciation
- **Background Music**: Optional, keep volume low (20-30% of voiceover)

### **Sample Data**
- **Institution Name**: "Kenya Technical Training Institute"
- **Department**: "Computing and Informatics"
- **Unit**: "Computer Operations"
- **Class**: "ICT Technician Level 6"
- **Students**: Use realistic names (John Maina, Mary Wanjiku, etc.)

---

## Alternative: Short Version (60-90 seconds)

### **Quick Highlights**
1. **Opening** (10s): Logo + tagline
2. **Problem** (15s): Quick problem statement
3. **Solution** (30s): Key features montage
4. **Demo** (20s): One key feature (validation readiness)
5. **Closing** (15s): Call to action

---

## Video Variations

### **Version 1: Feature-Focused (5 min)**
- Detailed walkthrough of each major feature
- Best for: Trade fairs, detailed presentations

### **Version 2: Workflow-Focused (4 min)**
- Follow a student submission from start to validation
- Best for: End-to-end understanding

### **Version 3: ROI-Focused (3 min)**
- Emphasize time savings, cost reduction, efficiency
- Best for: Decision-makers, administrators

### **Version 4: Technical Overview (6 min)**
- Architecture, security, scalability
- Best for: IT Directors, technical evaluators

---

## Distribution Strategy

### **Platforms**
1. **YouTube**: Main channel, SEO-optimized
2. **Vimeo**: Professional hosting
3. **Website**: Embedded on landing page
4. **Social Media**: LinkedIn, Twitter, Facebook
5. **Trade Fair**: Loop on booth display

### **Optimization**
- **Thumbnail**: Eye-catching, includes logo and key benefit
- **Title**: "EPOE System - CBET/CDACC-Compliant PoE Management"
- **Description**: Include key features, benefits, contact info
- **Tags**: TVET, CBET, CDACC, Education Technology, PoE, Assessment Management

---

## Script Timing Breakdown

| Section | Duration | Cumulative |
|---------|----------|------------|
| Opening | 0:30 | 0:30 |
| Challenge | 0:30 | 1:00 |
| Solution Overview | 0:30 | 1:30 |
| HOD Configuration | 0:30 | 2:00 |
| Assessment Creation | 0:30 | 2:30 |
| Practical Marking | 0:30 | 3:00 |
| Validation Readiness | 0:30 | 3:30 |
| Multi-Unit Validation | 0:30 | 4:00 |
| Student Portal | 0:30 | 4:30 |
| Reporting | 0:30 | 5:00 |
| Closing | 0:30 | 5:30 |

**Total**: 5:30 minutes

---

## Call-to-Action Options

### **Option 1: Direct**
> "Visit [website] to request a demo or contact us at [email]"

### **Option 2: QR Code**
> "Scan the QR code on screen to access a live demo environment"

### **Option 3: Trial**
> "Start your free 30-day trial today at [website]"

---

## Post-Production Checklist

- [ ] Add background music (subtle, professional)
- [ ] Add text overlays for key points
- [ ] Add transitions between sections
- [ ] Color correction and grading
- [ ] Audio leveling and noise reduction
- [ ] Add captions/subtitles (for accessibility)
- [ ] Create thumbnail image
- [ ] Export multiple formats (1080p, 720p, mobile)
- [ ] Add end screen with links
- [ ] Create shorter versions (60s, 90s, 2min)

---

## Resources Needed

1. **Screen Recordings**: All portal interfaces with sample data
2. **Voiceover**: Professional narrator or team member
3. **Graphics**: Logo, icons, text overlays
4. **Music**: Royalty-free background music
5. **Editing Software**: Professional video editing tool
6. **Sample Data**: Realistic institution, students, assessments

---

**Last Updated**: January 2026  
**Version**: 1.0



