# EPOE System - Demo Video Storyboard

## Visual Storyboard (Shot-by-Shot)

---

### **SCENE 1: Opening (0:00 - 0:30)**

**Shot 1** (0:00 - 0:05)
- **Visual**: Animated logo appears (fade-in, scale-up)
- **Text**: "EPOE System"
- **Audio**: Upbeat intro music starts

**Shot 2** (0:05 - 0:15)
- **Visual**: Logo fades, title card appears
- **Text**: 
  - Main: "Electronic Portfolio of Evidence"
  - Subtitle: "CBET/CDACC-Compliant Educational Management Platform"
- **Audio**: Music continues, voiceover begins

**Shot 3** (0:15 - 0:30)
- **Visual**: Three feature cards slide in from sides
- **Text Cards**:
  - "100% CBET/CDACC Compliant"
  - "6 Role-Based Portals"
  - "Mobile-First Design"
- **Audio**: Voiceover: "Welcome to the EPOE System..."

---

### **SCENE 2: The Challenge (0:30 - 1:00)**

**Shot 4** (0:30 - 0:45)
- **Visual**: Split screen
  - Left: Messy desk with paper files, physical folders
  - Right: Computer screen with multiple spreadsheets, email chains
- **Text**: "The Challenge"
- **Audio**: Voiceover: "TVET institutions face critical challenges..."

**Shot 5** (0:45 - 1:00)
- **Visual**: Three problem cards appear sequentially
- **Text Cards**:
  - "Challenge 1: Paper-Based Management"
  - "Challenge 2: Complex Workflows"
  - "Challenge 3: CBET Compliance"
- **Audio**: Voiceover continues

---

### **SCENE 3: Solution Overview (1:00 - 1:30)**

**Shot 6** (1:00 - 1:15)
- **Visual**: System architecture diagram (animated)
  - Central hub with six portals connecting
- **Text**: "The Solution"
- **Audio**: Voiceover: "The EPOE System provides a unified platform..."

**Shot 7** (1:15 - 1:30)
- **Visual**: Six portal icons appear one by one in a grid
  - Admin, HOD, Trainer, Validator, Student, Exams Office
- **Text**: Each icon labeled
- **Audio**: Voiceover lists portals

---

### **SCENE 4: HOD Configuration (1:30 - 2:00)**

**Shot 8** (1:30 - 1:45)
- **Visual**: Screen recording - HOD portal
  - Navigate: Dashboard → Units → Departmental Units
  - Click on a unit card
- **Text Overlay**: "HOD Portal - Unit Configuration"
- **Audio**: Voiceover: "Let's start with unit configuration..."

**Shot 9** (1:45 - 2:00)
- **Visual**: Configuration form
  - Dropdown: Select "Core Unit"
  - Input fields: Theory: 3, Practical: 3, Oral: 0, Project: 0
  - Click "Save Configuration"
- **Text Overlay**: "Assessment Structure Defined"
- **Audio**: Voiceover explains configuration

---

### **SCENE 5: Assessment Creation (2:00 - 2:30)**

**Shot 10** (2:00 - 2:15)
- **Visual**: Screen recording - Trainer portal
  - Navigate: My Units → Select unit → Create Assignment
- **Text Overlay**: "Trainer Portal - Create Assessment"
- **Audio**: Voiceover: "Trainers create assessments..."

**Shot 11** (2:15 - 2:30)
- **Visual**: Assignment creation form
  - Type: "Practical"
  - Upload assessor tool file
  - Total marks: 100
  - Click "Publish"
- **Text Overlay**: "Practical Assessment Created"
- **Audio**: Voiceover explains practical assessments

---

### **SCENE 6: Practical Marking (2:30 - 3:00)**

**Shot 12** (2:30 - 2:45)
- **Visual**: Practical marking interface
  - Show assessor tool with procedures listed
  - Student list on left
- **Text Overlay**: "Procedure-by-Procedure Marking"
- **Audio**: Voiceover: "Practical marking is intuitive..."

**Shot 13** (2:45 - 3:00)
- **Visual**: Mark a student
  - Check procedures
  - Enter marks (10, 15, 20, etc.)
  - Show subtotal updating: "45/100"
  - Save marks
  - Progress updates: "2/10 students marked"
- **Text Overlay**: "Real-Time Calculations"
- **Audio**: Voiceover explains marking process

---

### **SCENE 7: Validation Readiness (3:00 - 3:30)**

**Shot 14** (3:00 - 3:15)
- **Visual**: Marks Management page
  - Select unit from dropdown
  - Select class from dropdown
  - Validation readiness panel appears
- **Text Overlay**: "Validation Readiness Check"
- **Audio**: Voiceover: "Before pushing to validation..."

**Shot 15** (3:15 - 3:30)
- **Visual**: Validation readiness panel
  - Assessment status grid:
    - Theory: 3/3 ✓ (green)
    - Practical: 2/3 ✗ (red)
    - Oral: 0/0 ✓ (green)
    - Project: 0/0 ✓ (green)
  - Issues section showing missing items
  - "Push to Validation" button (disabled/greyed out)
- **Text Overlay**: "Automated Readiness Verification"
- **Audio**: Voiceover explains readiness check

---

### **SCENE 8: Multi-Unit Validation (3:30 - 4:00)**

**Shot 16** (3:30 - 3:45)
- **Visual**: Complete missing assessments
  - Create one more practical assessment
  - Mark all students
  - Return to validation readiness
  - All checks pass, button enabled
  - Click "Push to Validation"
  - Success message: "Unit added to existing class validation"
- **Text Overlay**: "Multi-Unit Support"
- **Audio**: Voiceover: "Multiple trainers can push different units..."

**Shot 17** (3:45 - 4:00)
- **Visual**: Switch to Validator portal
  - Show validation requests page
  - Class card showing "2 Units Pending"
  - Click to expand, show both units
- **Text Overlay**: "Grouped by Class"
- **Audio**: Voiceover explains multi-unit validation

---

### **SCENE 9: Student Portal Mobile (4:00 - 4:30)**

**Shot 18** (4:00 - 4:15)
- **Visual**: Mobile device (phone) screen recording
  - Show student dashboard
  - Scroll through assignments
  - Tap on an assignment
- **Text Overlay**: "Mobile-First Design"
- **Audio**: Voiceover: "Students access everything on their mobile devices..."

**Shot 19** (4:15 - 4:30)
- **Visual**: Student portal features
  - View feedback and marks
  - Progress tracking chart
  - Notification badge
  - Responsive navigation menu
- **Text Overlay**: "100% Mobile Responsive"
- **Audio**: Voiceover highlights mobile features

---

### **SCENE 10: Reporting (4:30 - 5:00)**

**Shot 20** (4:30 - 4:45)
- **Visual**: Reports page
  - Show "Print & Export" interface
  - Quick print buttons (Class List, Marks Sheet, Practical Sheet)
  - Click "Generate Class List"
- **Text Overlay**: "Comprehensive Reporting"
- **Audio**: Voiceover: "Comprehensive reporting is built-in..."

**Shot 21** (4:45 - 5:00)
- **Visual**: Report generation
  - PDF preview appears
  - Show export options (PDF, Word, Excel)
  - Show bulk operations panel
- **Text Overlay**: "Multiple Formats Available"
- **Audio**: Voiceover explains reporting features

---

### **SCENE 11: Closing (5:00 - 5:30)**

**Shot 22** (5:00 - 5:15)
- **Visual**: Fast montage of key features
  - Quick cuts: Dashboard, Marking, Validation, Mobile, Reports
- **Text Overlay**: Key metrics appear:
  - "70% Time Reduction"
  - "100% CBET Compliant"
  - "Complete Audit Trail"
- **Audio**: Upbeat music, voiceover: "The EPOE System reduces..."

**Shot 23** (5:15 - 5:30)
- **Visual**: Final call-to-action screen
  - Logo centered
  - Tagline: "Transforming TVET Education Management"
  - Contact information
  - QR code (bottom right)
  - Website URL
- **Text**: 
  - "Request a Demo: [website]"
  - "Contact: [email/phone]"
- **Audio**: Music fades out

---

## Visual Style Guide

### **Color Palette**
- **Primary**: Purple (#7C3AED) - Main brand color
- **Secondary**: Blue (#3B82F6) - Accent color
- **Success**: Green (#10B981) - Completed/approved states
- **Warning**: Yellow (#F59E0B) - Pending/attention needed
- **Error**: Red (#EF4444) - Issues/rejected
- **Background**: White/Light Gray (#F9FAFB)

### **Typography**
- **Headings**: Montserrat Bold, 24-32px
- **Body Text**: Open Sans Regular, 16-18px
- **Overlays**: Open Sans Semi-Bold, 14-16px
- **Captions**: Open Sans Regular, 12px

### **Animation Style**
- **Transitions**: Smooth fade (0.3s) or slide (0.4s)
- **Entrances**: Fade-in with slight scale (0.9 to 1.0)
- **Text**: Typewriter effect for key points (optional)
- **Icons**: Rotate-in or bounce-in (subtle)

### **Screen Recording Guidelines**
- **Resolution**: 1920x1080 minimum
- **Frame Rate**: 30fps
- **Cursor**: Visible, but use highlight effect for clicks
- **Zoom**: Use zoom-in for important UI elements
- **Speed**: Normal speed, can speed up repetitive actions (2x)

---

## Audio Cues

### **Background Music**
- **Style**: Upbeat, professional, instrumental
- **Volume**: 20-30% of voiceover level
- **Fade**: In at start (2s), out at end (3s)
- **Suggestion**: Corporate/tech background music (royalty-free)

### **Sound Effects** (Optional)
- **Click sounds**: Subtle for button clicks
- **Notification**: Soft chime for success messages
- **Transition**: Whoosh for scene changes

### **Voiceover**
- **Gender**: Either (prefer clear, professional voice)
- **Accent**: Neutral, clear pronunciation
- **Pace**: 150-160 words per minute
- **Tone**: Confident, friendly, professional

---

## Production Timeline

### **Pre-Production** (Week 1)
- [ ] Finalize script
- [ ] Prepare sample data
- [ ] Set up demo environment
- [ ] Record voiceover
- [ ] Select background music

### **Production** (Week 2)
- [ ] Record all screen captures
- [ ] Capture mobile device footage
- [ ] Record any live-action shots (if needed)
- [ ] Gather stock footage/images (if needed)

### **Post-Production** (Week 3)
- [ ] Edit video (cut, sequence, transitions)
- [ ] Add text overlays and graphics
- [ ] Sync audio and video
- [ ] Color correction
- [ ] Add captions/subtitles
- [ ] Create thumbnail
- [ ] Export multiple formats

### **Distribution** (Week 4)
- [ ] Upload to YouTube/Vimeo
- [ ] Embed on website
- [ ] Share on social media
- [ ] Create shorter versions (60s, 90s)

---

## Shot List Summary

| Shot # | Scene | Duration | Key Visual |
|--------|-------|----------|------------|
| 1-3 | Opening | 0:30 | Logo, title, features |
| 4-5 | Challenge | 0:30 | Problem statement |
| 6-7 | Solution | 0:30 | Architecture, portals |
| 8-9 | HOD Config | 0:30 | Unit configuration |
| 10-11 | Assessment | 0:30 | Create assignment |
| 12-13 | Marking | 0:30 | Practical marking |
| 14-15 | Validation | 0:30 | Readiness check |
| 16-17 | Multi-Unit | 0:30 | Push to validation |
| 18-19 | Mobile | 0:30 | Student portal |
| 20-21 | Reporting | 0:30 | Generate reports |
| 22-23 | Closing | 0:30 | Metrics, CTA |

**Total**: 23 shots, 5:30 minutes

---

## Alternative: Animated Explainer Version

If budget allows, consider an animated version:

### **Style**: 2D Animation (After Effects)
- **Characters**: Simple, professional figures
- **Icons**: Custom-drawn system icons
- **Scenes**: Animated workflow diagrams
- **Transitions**: Smooth, professional animations

### **Advantages**:
- More engaging
- Can show concepts not easily screen-recorded
- Professional, polished look
- Reusable assets

### **Disadvantages**:
- Higher cost
- Longer production time
- Requires animation skills/software

---

## Budget Estimate

### **Option 1: In-House Production**
- **Time**: 40-60 hours
- **Cost**: $0 (if using existing tools)
- **Quality**: Good (with proper execution)

### **Option 2: Professional Production**
- **Script Writing**: $500-1,000
- **Voiceover**: $300-800
- **Screen Recording**: $500-1,500
- **Editing**: $1,000-3,000
- **Graphics/Music**: $200-500
- **Total**: $2,500-6,800

### **Option 3: Hybrid**
- **In-house recording**: Free
- **Professional editing**: $1,000-2,000
- **Professional voiceover**: $300-800
- **Total**: $1,300-2,800

---

## Success Metrics

### **Video Performance KPIs**
- **Views**: Target 1,000+ in first month
- **Watch Time**: 60%+ completion rate
- **Engagement**: 5%+ click-through to demo
- **Shares**: 50+ social media shares
- **Leads**: 20+ demo requests from video

---

**Last Updated**: January 2026  
**Version**: 1.0



