# Install PostgreSQL PDO Driver for PHP

## Error: "could not find driver"

This error means PHP doesn't have the PostgreSQL PDO extension enabled. Here's how to fix it:

## Windows (XAMPP/WAMP/Laragon)

### Option 1: Enable Extension in php.ini

1. Find your `php.ini` file:
   ```bash
   php --ini
   ```

2. Open `php.ini` in a text editor

3. Find these lines and **uncomment** them (remove the `;` at the beginning):
   ```ini
   ;extension=pdo_pgsql
   ;extension=pgsql
   ```
   
   Should become:
   ```ini
   extension=pdo_pgsql
   extension=pgsql
   ```

4. Save the file

5. Restart your web server (Apache/Nginx) or PHP development server

6. Verify it's loaded:
   ```bash
   php -m | findstr pgsql
   ```

### Option 2: If Extensions Don't Exist

If the extensions aren't in your PHP installation:

1. **For XAMPP:**
   - Download PHP PostgreSQL DLLs
   - Place them in `php/ext/` folder
   - Enable in php.ini

2. **For Laragon:**
   - Use Laragon's extension manager
   - Enable PostgreSQL extensions

3. **For WAMP:**
   - Use WAMP's PHP extensions menu
   - Enable `php_pdo_pgsql` and `php_pgsql`

## Verify Installation

Run this command to check if extensions are loaded:

```bash
php -m | findstr pgsql
```

You should see:
- `pdo_pgsql`
- `pgsql`

## Alternative: Use Docker/Container

If you're having trouble with local PHP extensions, consider using:
- Laravel Sail (Docker)
- Homestead (Vagrant)
- Docker Desktop with PHP container

## After Enabling Extension

1. Restart your web server
2. Clear Laravel cache:
   ```bash
   php artisan config:clear
   ```
3. Test connection:
   ```bash
   php artisan migrate:status
   ```

## Quick Check

Run this to see all loaded extensions:
```bash
php -m
```

Look for `pdo_pgsql` and `pgsql` in the list.

