# PoE Submission Management Module

## Overview
The Portfolio of Evidence (PoE) Submission Management module is the core module for managing student portfolio submissions. This module is designed to be inherited and extended by all user roles with role-specific views and actions.

## Current Implementation (Admin Portal)

### Features Implemented
1. **Submission Listing**
   - Filter by status (draft, submitted, under_review, trainer_reviewed, hod_approved, exams_verified, validator_approved, rejected)
   - Filter by term (defaults to active term)
   - Filter by department
   - Filter by level
   - Filter by class, unit, student
   - Search functionality (student name, email, unit name/code)
   - Statistics cards for each status
   - Pagination

2. **Submission Details View**
   - Complete submission information
   - Evidence files list with download/delete
   - Reviews history
   - Validation status
   - Status update form
   - Action buttons (delete for drafts)

3. **Status Management**
   - Update submission status
   - Add notes/comments
   - Automatic timestamp on submission

4. **Evidence Management**
   - Download evidence files
   - Delete evidence (only for draft submissions)
   - File type indicators (image, video, document)
   - File metadata display

### Files Created
- `app/Http/Controllers/Admin/SubmissionController.php` - Main controller
- `resources/views/admin/submissions/index.blade.php` - Listing page
- `resources/views/admin/submissions/show.blade.php` - Detail page
- Updated `resources/views/components/admin-sidebar.blade.php` - Added submissions link

### Routes
- `GET /admin/submissions` - List all submissions
- `GET /admin/submissions/{submission}` - View submission details
- `PUT /admin/submissions/{submission}/status` - Update status
- `DELETE /admin/submissions/{submission}` - Delete submission (draft only)
- `GET /admin/submissions/evidence/{evidence}/download` - Download evidence
- `DELETE /admin/submissions/evidence/{evidence}` - Delete evidence

## Inheritance Strategy for Other Roles

### Student Portal
**Controller:** `app/Http/Controllers/Student/SubmissionController.php`
**Inherits from:** Base submission logic, but with student-specific filters

**Features:**
- View only own submissions
- Create new submissions
- Upload evidence files
- Edit draft submissions
- Submit for review
- View feedback and reviews
- Resubmit after rejection

**Routes:**
- `GET /student/submissions` - My submissions
- `GET /student/submissions/create` - Create new submission
- `POST /student/submissions` - Store submission
- `GET /student/submissions/{submission}` - View my submission
- `POST /student/submissions/{submission}/submit` - Submit for review
- `POST /student/submissions/{submission}/evidence` - Upload evidence

### Trainer Portal
**Controller:** `app/Http/Controllers/Trainer/SubmissionController.php`
**Inherits from:** Base submission logic, but with trainer-specific filters

**Features:**
- View submissions for assigned classes/units
- Review submissions
- Provide marks and feedback
- Approve/reject submissions
- View evidence files
- Filter by class, unit, student

**Routes:**
- `GET /trainer/submissions` - Submissions to review
- `GET /trainer/submissions/{submission}` - Review submission
- `POST /trainer/submissions/{submission}/review` - Submit review
- `PUT /trainer/submissions/{submission}/status` - Update status (trainer_reviewed)

### HOD Portal
**Controller:** `app/Http/Controllers/HOD/SubmissionController.php`
**Inherits from:** Base submission logic, but with HOD-specific filters

**Features:**
- View submissions for department
- Approve trainer-reviewed submissions
- Provide comments
- View department statistics
- Filter by class, unit, trainer

**Routes:**
- `GET /hod/submissions` - Department submissions
- `GET /hod/submissions/{submission}` - View submission
- `POST /hod/submissions/{submission}/approve` - Approve submission
- `PUT /hod/submissions/{submission}/status` - Update status (hod_approved)

### Exams Office Portal
**Controller:** `app/Http/Controllers/Exams/SubmissionController.php`
**Inherits from:** Base submission logic, but with exams office-specific filters

**Features:**
- View all submissions across terms
- Verify submission completeness
- Check marks and feedback
- Forward for validation
- Generate reports
- Export submissions

**Routes:**
- `GET /exams/submissions` - All submissions
- `GET /exams/submissions/{submission}` - View submission
- `POST /exams/submissions/{submission}/verify` - Verify submission
- `PUT /exams/submissions/{submission}/status` - Update status (exams_verified)
- `GET /exams/submissions/export` - Export submissions

### Validator Portal
**Controller:** `app/Http/Controllers/Validator/SubmissionController.php`
**Inherits from:** Base submission logic, but with validator-specific filters

**Features:**
- View submissions pending validation
- Final validation and approval
- Provide validation comments
- View complete submission history
- Filter by term, department, class

**Routes:**
- `GET /validator/submissions` - Pending validations
- `GET /validator/submissions/{submission}` - View submission
- `POST /validator/submissions/{submission}/validate` - Final validation
- `PUT /validator/submissions/{submission}/status` - Update status (validator_approved/rejected)

## Shared Components

### Models
- `App\Models\PoeSubmission` - Main submission model
- `App\Models\PoeEvidence` - Evidence files model
- `App\Models\Review` - Review model
- `App\Models\Validation` - Validation model

### Services
- `App\Services\ActiveTermService` - Active term management
- File storage service (to be created)
- Notification service (to be created)

### View Components (To Be Created)
- `resources/views/components/submission-status-badge.blade.php` - Reusable status badge
- `resources/views/components/evidence-list.blade.php` - Reusable evidence list
- `resources/views/components/submission-filters.blade.php` - Reusable filters

## Status Workflow

```
draft → submitted → under_review → trainer_reviewed → hod_approved → exams_verified → validator_approved
                                                                                          ↓
                                                                                    rejected
```

## Next Steps

1. **Create Base Submission Controller** (Abstract/Shared)
   - Common methods for all roles
   - Shared validation rules
   - Shared query scopes

2. **Implement Student Submission**
   - Create submission form
   - File upload functionality
   - Evidence management

3. **Implement Trainer Review**
   - Review interface
   - Marks entry
   - Feedback form

4. **Implement HOD Approval**
   - Approval workflow
   - Department filtering

5. **Implement Exams Office Verification**
   - Verification checklist
   - Export functionality

6. **Implement Validator Final Approval**
   - Final validation interface
   - Approval/rejection workflow

## Database Schema

### poe_submissions
- `id` - Primary key
- `student_id` - Foreign key to users
- `unit_id` - Foreign key to units
- `class_id` - Foreign key to classes
- `status` - Enum: draft, submitted, under_review, trainer_reviewed, hod_approved, exams_verified, validator_approved, rejected
- `version` - Integer (for resubmissions)
- `submitted_at` - Timestamp
- `notes` - Text
- `created_at`, `updated_at` - Timestamps

### poe_evidence
- `id` - Primary key
- `poe_submission_id` - Foreign key to poe_submissions
- `file_path` - Storage path
- `file_type` - Enum: document, image, video, audio
- `file_name` - Display name
- `original_name` - Original filename
- `file_size` - Integer (bytes)
- `mime_type` - String
- `tags` - JSON array
- `description` - Text
- `version` - Integer
- `created_at`, `updated_at` - Timestamps

## Notes

- All submissions are scoped to the active term by default
- Only draft submissions can be deleted
- Evidence can only be deleted from draft submissions
- Status changes are logged in audit_logs (to be implemented)
- Notifications are sent on status changes (to be implemented)
- File uploads are stored in `storage/app/poe_evidence/` (to be configured)

