# Supabase Database Setup Guide

## Database Configuration

This Laravel application is configured to use **Supabase (PostgreSQL)** as the database.

## Environment Variables

Add the following to your `.env` file:

```env
DB_CONNECTION=pgsql
DB_HOST=your-project.supabase.co
DB_PORT=5432
DB_DATABASE=postgres
DB_USERNAME=postgres
DB_PASSWORD=your-supabase-password
DB_SSLMODE=require
```

## Getting Supabase Credentials

1. Go to your Supabase project dashboard
2. Navigate to **Settings** → **Database**
3. Find the connection string or individual credentials:
   - **Host**: Found in Connection string (format: `db.xxxxx.supabase.co`)
   - **Port**: `5432`
   - **Database**: Usually `postgres`
   - **Username**: Usually `postgres`
   - **Password**: Your database password (set during project creation)
   - **SSL Mode**: Use `require` for production, `prefer` for development

## Connection String Format

Alternatively, you can use the connection string format:

```env
DATABASE_URL=postgresql://postgres:[YOUR-PASSWORD]@db.xxxxx.supabase.co:5432/postgres?sslmode=require
```

## Running Migrations

After configuring your `.env` file, run:

```bash
php artisan migrate
```

## Important Notes

- **SSL Required**: Supabase requires SSL connections. Make sure `DB_SSLMODE=require` is set.
- **PostgreSQL Extensions**: Supabase supports PostgreSQL extensions. If needed, enable them via Supabase dashboard.
- **Connection Pooling**: Supabase provides connection pooling. Use port `6543` for pooled connections if needed.
- **Row Level Security**: Consider implementing RLS policies in Supabase for additional security.

## Database Schema Overview

The following tables have been created:

### Core Tables
- `users` - User accounts with roles
- `departments` - Department information
- `levels` - Education levels
- `terms` - Academic terms/semesters
- `classes` - Classes linked to terms, departments, and levels
- `units` - Units/Modules

### Relationship Tables
- `term_department_units` - Links units to term+department combinations
- `enrollments` - Student enrollments in classes

### PoE Tables
- `poe_submissions` - Portfolio of Evidence submissions
- `poe_evidence` - Evidence files (documents, images, videos)
- `reviews` - Trainer/HOD/Exams Office reviews
- `validations` - Validator final approvals

### Communication Tables
- `notifications` - System notifications (uses Laravel's notification system)
- `messages` - In-system messaging

### System Tables
- `audit_logs` - Audit trail for all actions
- `settings` - System configuration settings

## Troubleshooting

### Connection Issues
- Verify your Supabase project is active
- Check firewall settings
- Ensure SSL mode is set correctly
- Verify credentials are correct

### Migration Issues
- Ensure PostgreSQL driver is installed: `composer require pgsql`
- Check PHP PDO PostgreSQL extension is enabled
- Verify database user has CREATE TABLE permissions

