# EPOE System – Technical Report

## 1. Introduction

The EPOE System is a web-based assessment and portfolio-of-evidence platform designed for Technical and Vocational Education and Training (TVET) institutions.  
It supports the full assessment lifecycle for units and practical tasks, from trainer allocation and assignment setup to evidence upload, marking, moderation, and reporting.

The core motivations for the system are:

- **Authentic assessment:** Capture practical performance using multiple media types (documents, images, video, audio) as supporting evidence.
- **Structured marking:** Align assessment with unit outcomes and assessor tools, ensuring transparent, traceable grading.
- **Compliance and auditability:** Generate tamper-evident reports (unit summaries, practical marks, validation records) that match institutional and regulatory requirements.
- **Stakeholder visibility:** Provide role-based portals for students, trainers, heads of department (HODs), validators, and administrators.

Key functional areas include:

- **Unit and trainer management:** Admin and HOD views to allocate trainers to units and classes per term.
- **Assignments and tasks:** Theory, practical, oral, and project assessments configured per unit.
- **Portfolio of Evidence (PoE):** Task-based evidence upload by students, and task-level review workflows by trainers.
- **Digital assessor tools:** Structured marking for practical assessments, with automatic generation of completed assessor tool PDFs.
- **Marks and reporting:** Unit marks summary, practical assessment reports, validation workflows, and exportable PDFs.
- **Notifications and messaging:** In-app notifications for critical events (e.g., graded practicals) and direct messaging between staff and students.

The system is implemented on Laravel/PHP with Blade templates, uses PostgreSQL as the primary data store, and follows a modular controller–service–view architecture to keep business logic and presentation cleanly separated.

## 2. Literature Review

### 2.1. TVET Assessment and Competency-Based Education

TVET systems increasingly adopt **Competency-Based Education and Training (CBET)** frameworks, where assessment is organised around observable tasks and performance criteria rather than solely written examinations.  
In this model, learners demonstrate competence through practical activities; evidence can include:

- Completed physical artefacts (e.g., electrical wiring boards, plumbing fixtures)
- Process evidence (photos, videos, logs)
- Assessor observations and checklists

Research and policy guidelines from TVET authorities and qualification frameworks (e.g., NVQ, NITA, TVETA-like bodies) emphasise:

- **Task-centric assessment:** Each task is linked to specific unit outcomes and criteria.
- **Multiple evidence sources:** A combination of written, oral, and practical evidence is encouraged to capture different dimensions of competence.
- **Portfolio of evidence (PoE):** Learners maintain structured evidence collections that document their learning journey and support external verification.

The EPOE System operationalises these principles by treating each practical task as a distinct submission entity with multiple supporting files, while ensuring that marking and status decisions occur at the **task level** rather than the individual file level.

### 2.2. Digital Portfolios and e-Assessment Systems

Digital portfolios have been widely explored in the literature as tools for:

- **Showcasing competence:** Allowing learners to present curated artefacts that demonstrate skills and growth.
- **Formative feedback:** Enabling ongoing dialogue between learner and assessor, rather than one-off high-stakes exams.
- **Audit and quality assurance:** Providing a transparent record that can be sampled by internal and external verifiers.

Common design patterns in e-portfolio systems include:

- **Role-based access control:** Different views and permissions for learners, assessors, moderators, and administrators.
- **Task and outcome mapping:** Each artefact or set of artefacts is linked to a defined task and learning outcome.
- **Versioning and history:** Ability to see submissions, feedback cycles, and changes over time.
- **Integration with assessment rubrics:** Embedding grading criteria, rubrics, or assessor tools directly into the marking workflow.

EPOE incorporates these patterns through:

- Separate **Student, Trainer, HOD, Validator, and Admin** portals.
- Task-based PoE records (`practical_evidences` and `practical_evidence_tasks`) that link evidence files to specific units, classes, terms, and tasks.
- Use of **digital assessor tools** that mirror paper-based marking schemes and generate tamper-evident PDF outputs.
- Centralised statistics dashboards and validation modules to support programme-level monitoring.

### 2.3. Assessment Quality, Moderation, and Validation

Quality assurance frameworks in TVET typically require:

- **Standardised marking:** Use of common assessor tools and clear marking guides.
- **Internal moderation:** HOD or senior assessors review samples of marked work for consistency.
- **External verification/validation:** External verifiers confirm that assessment decisions and evidence meet national standards.
- **Transparent reporting:** Unit marks, assessment structures, and validation outcomes must be clearly documented and retrievable.

In response, EPOE provides:

- **Digital assessor tools** that standardise how marks are captured and calculated.
- **Unit and class-level summary reports** (Unit Marks Summary, Practical Assessment Marks Report) that follow a consistent institutional letterhead and signature structure.
- **Validation requests** that gate the submission of units to validators until all required tasks are submitted, marked, and each task has a final status.
- System-generated PDFs tagged as **“System Generated – No Alterations Allowed”** to support auditing and discourage manual tampering.

### 2.4. User Experience and Operational Considerations

Effective adoption of assessment systems in TVET institutions depends not just on functionality, but also on:

- **Low friction for trainers:** Marking tools must be fast, responsive, and aligned with existing paper processes to avoid resistance.
- **Clear student feedback:** Students need simple, task-level status and comments rather than fragmented file-level messages.
- **Performance and reliability:** Bulk marking operations, report generation, and notifications must be optimised to avoid delays and duplicate events.

The EPOE System addresses these concerns through:

- **Task-level workflows:** Trainers review all files for a task in one view and make a single decision; students see clear, task-based statuses.
- **Optimised notifications:** Practical marking triggers a single notification event, with debounced “Save Marks” actions to avoid duplicates.
- **Unified reporting style:** All major reports share a common institutional header, metadata section, signatures, and footer warnings, reinforcing trust and familiarity for stakeholders.

In summary, the EPOE System is grounded in current best practice for competency-based TVET assessment, e-portfolios, and digital quality assurance. The rest of this report can build on this foundation to describe system architecture, implementation details, and evaluation results.

