<?php

namespace App\Http\Controllers\HOD;

use App\Http\Controllers\Controller;
use App\Models\Message;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class MessageController extends Controller
{
    public function index()
    {
        $hod = Auth::user();
        
        $messages = Message::where('receiver_id', $hod->id)
            ->orWhere('sender_id', $hod->id)
            ->with(['sender', 'receiver'])
            ->latest()
            ->paginate(20);

        $unreadCount = Message::where('receiver_id', $hod->id)
            ->where('is_read', false)
            ->count();

        return view('hod.messages.index', compact('messages', 'unreadCount'));
    }

    public function show(Message $message)
    {
        $hod = Auth::user();
        
        // Verify HOD is sender or receiver
        if ($message->sender_id !== $hod->id && $message->receiver_id !== $hod->id) {
            abort(403, 'You do not have permission to view this message.');
        }

        // Mark as read if HOD is receiver
        if ($message->receiver_id === $hod->id && !$message->is_read) {
            $message->update(['is_read' => true]);
        }

        $message->load(['sender', 'receiver']);

        return view('hod.messages.show', compact('message'));
    }
}
