<?php

namespace App\Http\Controllers\Validator;

use App\Http\Controllers\Controller;
use App\Models\ValidationRequest;
use App\Services\ActiveTermService;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    /**
     * Display the validator dashboard.
     */
    public function index()
    {
        $validator = Auth::user();
        $activeTerm = ActiveTermService::getActiveTerm();

        if (!$activeTerm) {
            return view('validator.dashboard', [
                'pendingCount' => 0,
                'validatedCount' => 0,
                'rejectedCount' => 0,
                'activeTerm' => null,
            ])->with('warning', 'No active term found.');
        }

        // Count validation requests by status for active term
        $stats = [
            'pending' => ValidationRequest::where('term_id', $activeTerm->id)
                ->where('status', 'pending')
                ->count(),
            'approved' => ValidationRequest::where('term_id', $activeTerm->id)
                ->where('status', 'approved')
                ->count(),
            'rejected' => ValidationRequest::where('term_id', $activeTerm->id)
                ->where('status', 'rejected')
                ->count(),
            'returned' => ValidationRequest::where('term_id', $activeTerm->id)
                ->where('status', 'returned_to_trainer')
                ->count(),
        ];

        // Get recent validation requests
        $recentRequests = ValidationRequest::where('term_id', $activeTerm->id)
            ->with([
                'schoolClass:id,name,code',
                'unit:id,name,code',
                'submitter:id,name'
            ])
            ->orderBy('submitted_at', 'desc')
            ->limit(10)
            ->get();

        return view('validator.dashboard', compact(
            'stats',
            'recentRequests',
            'activeTerm'
        ));
    }
}
