<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssignmentSubmission extends Model
{
    use HasFactory;

    protected $fillable = [
        'assignment_id',
        'student_id',
        'feedback',
        'attachments',
        'status',
        'marks',
        'trainer_feedback',
        'submitted_at',
        'graded_at',
        'marking_status',
        'completed_assessor_tool_path',
    ];

    protected $casts = [
        'attachments' => 'array',
        'submitted_at' => 'datetime',
        'graded_at' => 'datetime',
        'marks' => 'decimal:2', // Supports up to 999999.99
    ];

    // Relationships
    public function assignment()
    {
        return $this->belongsTo(Assignment::class);
    }

    public function student()
    {
        return $this->belongsTo(User::class, 'student_id');
    }

    public function assessorToolMarks()
    {
        return $this->hasMany(AssessorToolMark::class, 'assignment_submission_id');
    }

    // Helper methods
    public function isDraft()
    {
        return $this->status === 'draft';
    }

    public function isSubmitted()
    {
        return $this->status === 'submitted';
    }

    public function isGraded()
    {
        return $this->status === 'graded';
    }

    public function getStatusBadgeClasses()
    {
        return match($this->status) {
            'draft' => 'bg-gray-100 text-gray-800',
            'submitted' => 'bg-yellow-100 text-yellow-800',
            'graded' => 'bg-green-100 text-green-800',
            default => 'bg-gray-100 text-gray-800',
        };
    }
}
