<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ValidationRequest extends Model
{
    use HasFactory;

    protected $fillable = [
        'class_id',
        'unit_id',
        'term_id',
        'submitted_by',
        'submitted_role',
        'status',
        'submitted_at',
        'validated_by',
        'validated_at',
        'validation_comment',
    ];

    protected $casts = [
        'submitted_at' => 'datetime',
        'validated_at' => 'datetime',
    ];

    public function schoolClass()
    {
        return $this->belongsTo(SchoolClass::class, 'class_id');
    }

    public function unit()
    {
        return $this->belongsTo(Unit::class);
    }

    public function term()
    {
        return $this->belongsTo(Term::class);
    }

    public function submitter()
    {
        return $this->belongsTo(User::class, 'submitted_by');
    }

    public function validator()
    {
        return $this->belongsTo(User::class, 'validated_by');
    }

    public function unitValidations()
    {
        return $this->hasMany(UnitValidation::class);
    }

    public static function isLocked(int $classId, int $unitId, int $termId): bool
    {
        return static::where('class_id', $classId)
            ->where('unit_id', $unitId)
            ->where('term_id', $termId)
            ->whereIn('status', ['pending', 'approved'])
            ->exists();
    }

    public function isPending()
    {
        return $this->status === 'pending';
    }

    public function isApproved()
    {
        return $this->status === 'approved';
    }

    public function isRejected()
    {
        return $this->status === 'rejected';
    }

    public function isReturnedToTrainer()
    {
        return $this->status === 'returned_to_trainer';
    }
}
