<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        // Check if columns exist before adding
        if (!Schema::hasColumn('assignments', 'candidate_tool')) {
            Schema::table('assignments', function (Blueprint $table) {
                $table->json('candidate_tool')->nullable()->after('attachments');
            });
        }
        
        if (!Schema::hasColumn('assignments', 'assessor_tool')) {
            Schema::table('assignments', function (Blueprint $table) {
                $table->json('assessor_tool')->nullable()->after('candidate_tool');
            });
        }

        // Update existing 'quiz' to 'practical' if any exist (in case enum was already created with quiz)
        try {
            DB::table('assignments')
                ->where('type', 'quiz')
                ->update(['type' => 'practical']);
        } catch (\Exception $e) {
            // Ignore if column doesn't exist or enum doesn't have quiz
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        // Revert 'practical' back to 'quiz'
        DB::table('assignments')
            ->where('type', 'practical')
            ->update(['type' => 'quiz']);
        
        if (Schema::hasColumn('assignments', 'candidate_tool')) {
            Schema::table('assignments', function (Blueprint $table) {
                $table->dropColumn('candidate_tool');
            });
        }
        
        if (Schema::hasColumn('assignments', 'assessor_tool')) {
            Schema::table('assignments', function (Blueprint $table) {
                $table->dropColumn('assessor_tool');
            });
        }
    }
};
