<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Drop the old incomplete table and recreate with full structure
        Schema::dropIfExists('assessor_tool_marks');
        
        Schema::create('assessor_tool_marks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('assignment_id')->constrained('assignments')->onDelete('cascade');
            $table->foreignId('assignment_submission_id')->constrained('assignment_submissions')->onDelete('cascade');
            $table->foreignId('structure_id')->constrained('assessor_tool_structures')->onDelete('cascade');
            $table->string('row_identifier'); // Unique identifier for the row/task (e.g., "task1_item1")
            $table->string('section')->nullable(); // Section/group name (e.g., "TASK 1")
            $table->text('item_description'); // Description of the item being evaluated
            $table->decimal('marks_available', 8, 2); // Maximum marks for this item
            $table->decimal('marks_obtained', 8, 2)->default(0); // Marks awarded
            $table->text('comments')->nullable(); // Comments/observations
            $table->integer('display_order')->default(0); // Order in which to display
            $table->boolean('is_subtotal')->default(false); // Whether this row is a subtotal
            $table->boolean('is_total')->default(false); // Whether this row is a total
            $table->timestamps();
            
            // Ensure one mark entry per row per submission
            $table->unique(['assignment_submission_id', 'row_identifier'], 'unique_submission_row');
            
            // Index for faster queries
            $table->index(['assignment_submission_id', 'section']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('assessor_tool_marks');
    }
};
