<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('assignments', function (Blueprint $table) {
            $table->boolean('results_released')->default(false)->after('is_published');
            $table->boolean('results_locked')->default(false)->after('results_released');
            $table->timestamp('results_released_at')->nullable()->after('results_locked');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('assignments', function (Blueprint $table) {
            $table->dropColumn(['results_released', 'results_locked', 'results_released_at']);
        });
    }
};
