<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            // Basic personal details
            $table->string('national_id_number')->nullable()->after('admission_number');
            $table->date('date_of_birth')->nullable()->after('national_id_number');
            $table->string('guardian_name')->nullable()->after('date_of_birth');
            $table->string('guardian_phone')->nullable()->after('guardian_name');
            $table->string('address')->nullable()->after('guardian_phone');

            // Document paths
            $table->string('id_document_path')->nullable()->after('avatar');
            $table->string('kcpe_certificate_path')->nullable()->after('id_document_path');
            $table->string('kcse_certificate_path')->nullable()->after('kcpe_certificate_path');
            $table->string('birth_certificate_path')->nullable()->after('kcse_certificate_path');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'national_id_number',
                'date_of_birth',
                'guardian_name',
                'guardian_phone',
                'address',
                'id_document_path',
                'kcpe_certificate_path',
                'kcse_certificate_path',
                'birth_certificate_path',
            ]);
        });
    }
};
