<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // For PostgreSQL, check if using enum or varchar
        if (DB::getDriverName() === 'pgsql') {
            // Check if column exists and get its type
            $columnInfo = DB::selectOne("
                SELECT data_type, udt_name 
                FROM information_schema.columns 
                WHERE table_name = 'practical_evidence_comments' 
                AND column_name = 'role'
            ");
            
            if ($columnInfo && $columnInfo->data_type === 'USER-DEFINED') {
                // It's an enum type
                $typeName = $columnInfo->udt_name;
                DB::statement("ALTER TYPE {$typeName} ADD VALUE IF NOT EXISTS 'hod'");
            } else {
                // It's varchar, we need to change it to enum or add constraint
                // Since Laravel uses varchar for enums in PostgreSQL, we'll just add a check constraint
                DB::statement("
                    ALTER TABLE practical_evidence_comments 
                    DROP CONSTRAINT IF EXISTS practical_evidence_comments_role_check
                ");
                DB::statement("
                    ALTER TABLE practical_evidence_comments 
                    ADD CONSTRAINT practical_evidence_comments_role_check 
                    CHECK (role IN ('trainer', 'verifier', 'hod'))
                ");
            }
        } else {
            // For MySQL, modify the column
            Schema::table('practical_evidence_comments', function (Blueprint $table) {
                $table->enum('role', ['trainer', 'verifier', 'hod'])->default('trainer')->change();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Note: PostgreSQL doesn't support removing enum values easily
        // This migration is not easily reversible for PostgreSQL
        if (DB::getDriverName() !== 'pgsql') {
            Schema::table('practical_evidence_comments', function (Blueprint $table) {
                $table->enum('role', ['trainer', 'verifier'])->default('trainer')->change();
            });
        }
    }
};
