<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('unit_validations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('validation_request_id')->constrained('validation_requests')->onDelete('cascade');
            $table->foreignId('student_id')->constrained('users')->onDelete('cascade');
            $table->enum('decision', ['pending', 'approved', 'modified', 'rejected'])->default('pending');
            $table->decimal('original_marks', 10, 2)->nullable(); // Original trainer marks
            $table->decimal('adjusted_marks', 10, 2)->nullable(); // Validator adjusted marks (if modified)
            $table->text('validator_comment')->nullable();
            $table->foreignId('validated_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamp('validated_at')->nullable();
            $table->timestamps();

            $table->unique(['validation_request_id', 'student_id']);
            $table->index(['validation_request_id', 'decision']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::dropIfExists('unit_validations');
    }
};
