<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Add term_id back to classes table if it doesn't exist
        // This fixes the issue after rollbacks removed term_id
        if (!Schema::hasColumn('classes', 'term_id')) {
            Schema::table('classes', function (Blueprint $table) {
                $table->foreignId('term_id')->nullable()->after('id')->constrained('terms')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('classes', 'term_id')) {
            Schema::table('classes', function (Blueprint $table) {
                $table->dropForeign(['term_id']);
                $table->dropColumn('term_id');
            });
        }
    }
};
