# Deploying on cPanel

If you see an error like:

```
file_put_contents(.../storage/framework/sessions/...): Failed to open stream: No such file or directory
```

do the following.

## 1. Set permissions (required)

After uploading the app, set writable permissions for Laravel’s storage and cache:

- **Via cPanel File Manager**
  - Go to **File Manager** → open your app folder (e.g. `public_html` or the folder where the Laravel app lives).
  - Right‑click **`storage`** → **Change Permissions** → set to **755** or **775**. If 755 doesn’t work, try **775**.
  - Check **“Recurse into subdirectories”** so all subfolders get the same.
  - Do the same for **`bootstrap/cache`** (set to **755** or **775**).

- **Via SSH** (if you have access):
  ```bash
  cd /home/YOUR_CPANEL_USER/public_html   # or your Laravel app path
  chmod -R 775 storage bootstrap/cache
  # If your host uses a specific user for the web server, you may need:
  # chown -R USER:GROUP storage bootstrap/cache
  ```

Replace `YOUR_CPANEL_USER` and the path with your actual cPanel username and path to the Laravel app.

## 2. Let the app create missing dirs (optional)

The app tries to create missing directories under `storage/framework` and `bootstrap/cache` on first run. That only works if the **parent** `storage` and `bootstrap` folders already exist and are writable. So step 1 is still required.

## 3. Document root and `public`

- Point the **domain’s document root** to the Laravel **`public`** folder (e.g. `public_html/public` or `public_html/your-app/public`), **not** to the project root.
- Or keep document root as `public_html` and move Laravel’s **`public`** contents into `public_html` and **`index.php`** and **`.htaccess`** adjusted so the app runs from the parent directory (standard “move public” setup for shared hosting).

## 4. Environment

- Copy **`.env.example`** to **`.env`** on the server.
- Set **`APP_KEY`** (run `php artisan key:generate` locally or on server and paste into `.env`).
- Set **`APP_ENV=production`** and **`APP_DEBUG=false`** for production.
- Configure **database** and other env vars for the server.

## 5. After deploy (if you have SSH or “Run PHP script”)

```bash
php artisan config:cache
php artisan route:cache
php artisan view:cache
php artisan storage:link
```

If you can’t run Artisan, at least ensure **storage** and **bootstrap/cache** permissions are **775** (or **755** and writable by the web server user).

---

**Summary:** The session error is almost always **missing or non‑writable `storage/framework/sessions`**. Fix it by setting **`storage`** and **`bootstrap/cache`** to **775** (and recurse) and pointing the document root at **`public`**.
