@extends('layouts.admin')

@section('title', 'Term History Details')
@section('page-title', 'Term History Details')

@section('content')
    <div class="max-w-7xl mx-auto">
        <!-- Term Header -->
        <div class="bg-white shadow rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-gray-200">
                <div class="flex items-center justify-between">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900">{{ $term->name }}</h2>
                        <p class="mt-1 text-sm text-gray-600">
                            {{ $term->start_date->format('F d, Y') }} - {{ $term->end_date->format('F d, Y') }}
                            ({{ $term->getDurationInDays() }} days)
                        </p>
                    </div>
                    <div class="flex items-center space-x-3">
                        <span class="px-3 py-1 text-sm font-semibold rounded-full 
                            @if($term->status == 'completed') bg-green-100 text-green-800
                            @else bg-gray-100 text-gray-800
                            @endif">
                            {{ ucfirst($term->status) }}
                        </span>
                        <a href="{{ route('admin.history.index') }}" 
                           class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50">
                            Back to History
                        </a>
                    </div>
                </div>
            </div>

            <!-- Statistics -->
            <div class="px-6 py-4">
                <div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-6 gap-4">
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-sm font-medium text-gray-600">Total Classes</p>
                        <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_classes'] }}</p>
                    </div>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-sm font-medium text-gray-600">Total Units</p>
                        <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_units'] }}</p>
                    </div>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-sm font-medium text-gray-600">Total Students</p>
                        <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_students'] }}</p>
                    </div>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-sm font-medium text-gray-600">Total Trainers</p>
                        <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_trainers'] }}</p>
                    </div>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-sm font-medium text-gray-600">PoE Submissions</p>
                        <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_submissions'] }}</p>
                    </div>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <p class="text-sm font-medium text-gray-600">Practical Evidence</p>
                        <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_practical_evidence'] }}</p>
                    </div>
                </div>
                <div class="mt-4 bg-indigo-50 rounded-lg p-4 border border-indigo-200">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 text-indigo-600 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        <p class="text-sm font-semibold text-indigo-900">Total Portfolio Evidence: {{ $stats['total_portfolio_evidence'] }}</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Navigation Links -->
        <div class="bg-white shadow rounded-lg mb-6 p-4">
            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-3">
                <a href="{{ route('admin.history.classes', $term) }}" 
                   class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 text-sm font-medium text-center">
                    View Classes
                </a>
                <a href="{{ route('admin.history.units', $term) }}" 
                   class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 text-sm font-medium text-center">
                    View Units
                </a>
                <a href="{{ route('admin.history.trainers', $term) }}" 
                   class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 text-sm font-medium text-center">
                    View Trainers
                </a>
                <a href="{{ route('admin.history.submissions', $term) }}" 
                   class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 text-sm font-medium text-center">
                    PoE Submissions
                </a>
                <a href="{{ route('admin.history.practical-evidence', $term) }}" 
                   class="px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700 text-sm font-medium text-center">
                    Practical Evidence
                </a>
                <a href="{{ route('admin.history.units', $term) }}" 
                   class="px-4 py-2 bg-gray-600 text-white rounded-md hover:bg-gray-700 text-sm font-medium text-center">
                    Print Reports
                </a>
            </div>
        </div>
    </div>
@endsection

