@extends('layouts.admin')

@section('title', 'User Details')
@section('page-title', 'User Details')

@section('content')
    <div class="max-w-6xl mx-auto">
        <!-- User Info Card -->
        <div class="bg-white shadow rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-gray-200">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <div class="h-16 w-16 rounded-full bg-indigo-600 flex items-center justify-center">
                            <span class="text-white font-semibold text-2xl">{{ substr($user->name, 0, 1) }}</span>
                        </div>
                        <div class="ml-4">
                            <h2 class="text-2xl font-bold text-gray-900">{{ $user->name }}</h2>
                            <p class="text-sm text-gray-600">{{ $user->email }}</p>
                        </div>
                    </div>
                    <div class="flex items-center space-x-3">
                        <a href="{{ route('admin.users.edit', $user) }}" 
                           class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50">
                            Edit User
                        </a>
                        <a href="{{ route('admin.users.index', ['role' => $user->role]) }}" 
                           class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50">
                            Back to List
                        </a>
                    </div>
                </div>
            </div>

            <div class="px-6 py-4">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div>
                        <p class="text-sm font-medium text-gray-500">Role</p>
                        <p class="mt-1 text-lg font-semibold">
                            <span class="px-3 py-1 text-sm rounded-full 
                                @if($user->role == 'admin') bg-indigo-100 text-indigo-800
                                @elseif($user->role == 'hod') bg-green-100 text-green-800
                                @elseif($user->role == 'trainer') bg-purple-100 text-purple-800
                                @elseif($user->role == 'exams_office') bg-blue-100 text-blue-800
                                @elseif($user->role == 'validator') bg-yellow-100 text-yellow-800
                                @else bg-pink-100 text-pink-800
                                @endif">
                                {{ ucfirst(str_replace('_', ' ', $user->role)) }}
                            </span>
                        </p>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-500">Status</p>
                        <p class="mt-1 text-lg font-semibold">
                            <span class="px-3 py-1 text-sm rounded-full 
                                @if($user->status == 'active') bg-green-100 text-green-800
                                @elseif($user->status == 'inactive') bg-gray-100 text-gray-800
                                @else bg-red-100 text-red-800
                                @endif">
                                {{ ucfirst($user->status) }}
                            </span>
                        </p>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-500">Department</p>
                        <p class="mt-1 text-lg font-semibold text-gray-900">
                            {{ $user->department ? $user->department->name : 'Not assigned' }}
                        </p>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-500">Phone</p>
                        <p class="mt-1 text-lg font-semibold text-gray-900">
                            {{ $user->phone ?: 'Not provided' }}
                        </p>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-500">Email Verified</p>
                        <p class="mt-1 text-lg font-semibold">
                            @if($user->email_verified_at)
                                <span class="text-green-600">Verified</span>
                            @else
                                <span class="text-red-600">Not Verified</span>
                            @endif
                        </p>
                    </div>
                    <div>
                        <p class="text-sm font-medium text-gray-500">Member Since</p>
                        <p class="mt-1 text-lg font-semibold text-gray-900">
                            {{ $user->created_at->format('M d, Y') }}
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Enrollments -->
        @if($user->isStudent() && $user->enrollments->count() > 0)
            <div class="bg-white shadow rounded-lg mb-6">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">Class Enrollments</h3>
                </div>
                <div class="px-6 py-4">
                    <div class="space-y-3">
                        @foreach($user->enrollments as $enrollment)
                            <div class="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                                <div>
                                    <p class="font-medium text-gray-900">{{ $enrollment->schoolClass->name }}</p>
                                    <p class="text-sm text-gray-600">
                                        {{ $enrollment->schoolClass->department->name }} • 
                                        {{ $enrollment->schoolClass->level->name }} • 
                                        {{ $enrollment->schoolClass->term->name }}
                                    </p>
                                    <p class="text-xs text-gray-500 mt-1">
                                        Enrolled: {{ $enrollment->enrolled_at->format('M d, Y') }}
                                    </p>
                                </div>
                                <span class="px-3 py-1 text-xs rounded-full 
                                    @if($enrollment->status == 'active') bg-green-100 text-green-800
                                    @elseif($enrollment->status == 'completed') bg-gray-100 text-gray-800
                                    @else bg-red-100 text-red-800
                                    @endif">
                                    {{ ucfirst($enrollment->status) }}
                                </span>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif

        <!-- PoE Submissions -->
        @if($user->poeSubmissions->count() > 0)
            <div class="bg-white shadow rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">PoE Submissions</h3>
                </div>
                <div class="px-6 py-4">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Unit</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Class</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Version</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Submitted</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @foreach($user->poeSubmissions as $submission)
                                    <tr>
                                        <td class="px-4 py-3 text-sm text-gray-900">{{ $submission->unit->name }}</td>
                                        <td class="px-4 py-3 text-sm text-gray-600">{{ $submission->schoolClass->name }}</td>
                                        <td class="px-4 py-3">
                                            <span class="px-2 py-1 text-xs rounded-full 
                                                @if($submission->status === 'validator_approved') bg-green-100 text-green-800
                                                @elseif($submission->status === 'rejected') bg-red-100 text-red-800
                                                @else bg-yellow-100 text-yellow-800
                                                @endif">
                                                {{ str_replace('_', ' ', $submission->status) }}
                                            </span>
                                        </td>
                                        <td class="px-4 py-3 text-sm text-gray-600">{{ $submission->version }}</td>
                                        <td class="px-4 py-3 text-sm text-gray-600">
                                            {{ $submission->submitted_at ? $submission->submitted_at->format('M d, Y') : '-' }}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @endif
    </div>
@endsection

