@props(['active' => ''])

<div class="hidden md:flex md:flex-shrink-0 md:fixed md:inset-y-0 md:left-0 z-30">
    <div class="flex flex-col w-64">
        <div class="flex flex-col flex-grow pt-5 bg-purple-800 border-r border-purple-900 overflow-y-auto">
            <!-- Logo/Brand -->
            <div class="flex items-center flex-shrink-0 px-4 mb-8">
                <a href="{{ route('hod.dashboard') }}" class="text-2xl font-bold text-white hover:text-purple-200">EPOE System</a>
            </div>
            
            <!-- Navigation -->
            <div class="mt-5 flex-1 flex flex-col">
                <nav class="flex-1 px-2 space-y-6">
                    <!-- Dashboard (Always at top) -->
                    <div>
                        <a href="{{ route('hod.dashboard') }}" 
                           class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('hod.dashboard') ? 'bg-purple-900 text-white' : 'text-purple-100 hover:bg-purple-700 hover:text-white' }}">
                            <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                            </svg>
                            Dashboard
                        </a>
                    </div>

                    <!-- Management Section -->
                    <div>
                        <div class="px-3 mb-2">
                            <p class="text-xs font-semibold text-purple-300 uppercase tracking-wider">Management</p>
                        </div>
                        <div class="space-y-1">
                            <!-- Pending Approvals -->
                            <a href="{{ route('hod.approvals.index') }}" 
                               class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('hod.approvals.*') ? 'bg-purple-900 text-white' : 'text-purple-100 hover:bg-purple-700 hover:text-white' }}">
                                <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                Pending Approvals
                                @php
                                    $pendingCount = cache()->remember('hod.pending_approvals.' . auth()->id(), 60, function() {
                                        $activeTermId = \App\Services\ActiveTermService::getActiveTermId();
                                        if (!$activeTermId) {
                                            return 0;
                                        }
                                        $hod = auth()->user();
                                        $departmentId = $hod->department_id;
                                        if (!$departmentId) {
                                            return 0;
                                        }
                                        return \App\Models\PoeSubmission::withoutGlobalScope('activeTerm')
                                            ->whereHas('schoolClass', function($q) use ($activeTermId, $departmentId) {
                                                $q->where('term_id', $activeTermId)
                                                  ->where('department_id', $departmentId);
                                            })
                                            ->whereIn('status', ['trainer_reviewed'])
                                            ->count();
                                    });
                                @endphp
                                @if($pendingCount > 0)
                                    <span class="ml-auto bg-red-600 text-white text-xs font-semibold px-2 py-1 rounded-full">{{ $pendingCount }}</span>
                                @endif
                            </a>

                            <!-- Unit Allocations -->
                            <a href="{{ route('hod.unit-allocations.index') }}" 
                               class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('hod.unit-allocations.*') ? 'bg-purple-900 text-white' : 'text-purple-100 hover:bg-purple-700 hover:text-white' }}">
                                <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"></path>
                                </svg>
                                Unit Allocations
                            </a>

                            <!-- Departmental Units -->
                            <a href="{{ route('hod.units.departmental') }}" 
                               class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('hod.units.departmental') || request()->routeIs('hod.units.create') ? 'bg-purple-900 text-white' : 'text-purple-100 hover:bg-purple-700 hover:text-white' }}">
                                <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                                Departmental Units
                            </a>

                            <!-- Marks Management -->
                            <a href="{{ route('hod.marks.index') }}" 
                               class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('hod.marks.*') ? 'bg-purple-900 text-white' : 'text-purple-100 hover:bg-purple-700 hover:text-white' }}">
                                <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                                </svg>
                                Marks Management
                            </a>

                            <!-- User Management -->
                            <a href="{{ route('hod.users.index') }}" 
                               class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('hod.users.*') ? 'bg-purple-900 text-white' : 'text-purple-100 hover:bg-purple-700 hover:text-white' }}">
                                <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                                </svg>
                                User Management
                            </a>

                            <!-- Classes Management -->
                            <a href="{{ route('hod.classes.index') }}" 
                               class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('hod.classes.*') ? 'bg-purple-900 text-white' : 'text-purple-100 hover:bg-purple-700 hover:text-white' }}">
                                <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>
                                </svg>
                                Classes
                            </a>

                            <!-- Notifications -->
                            <a href="{{ route('hod.notifications.index') }}" 
                               class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('hod.notifications.*') ? 'bg-purple-900 text-white' : 'text-purple-100 hover:bg-purple-700 hover:text-white' }}">
                                <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                                </svg>
                                Send Notifications
                            </a>
                        </div>
                    </div>

                    <!-- Monitoring Section -->
                    <div>
                        <div class="px-3 mb-2">
                            <p class="text-xs font-semibold text-purple-300 uppercase tracking-wider">Monitoring</p>
                        </div>
                        <div class="space-y-1">
                            <!-- My Units -->
                            <a href="{{ route('hod.units.index') }}" 
                               class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('hod.units.*') ? 'bg-purple-900 text-white' : 'text-purple-100 hover:bg-purple-700 hover:text-white' }}">
                                <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                                My Units
                            </a>

                            <!-- Portfolio Evidence -->
                            <a href="{{ route('hod.practical-evidence.index') }}" 
                               class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('hod.practical-evidence.*') ? 'bg-purple-900 text-white' : 'text-purple-100 hover:bg-purple-700 hover:text-white' }}">
                                <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                                Portfolio Evidence
                            </a>

                            <!-- Reports -->
                            <a href="{{ route('hod.reports.index') }}" 
                               class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('hod.reports.*') ? 'bg-purple-900 text-white' : 'text-purple-100 hover:bg-purple-700 hover:text-white' }}">
                                <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 17v-2m3 2v-4m3 4v-6m2 10H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                                Reports
                            </a>
                        </div>
                    </div>

                    <!-- History Section -->
                    <div>
                        <div class="px-3 mb-2">
                            <p class="text-xs font-semibold text-purple-300 uppercase tracking-wider">History</p>
                        </div>
                        <div class="space-y-1">
                            <!-- Past Terms -->
                            <a href="{{ route('hod.history.index') }}" 
                               class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('hod.history.*') ? 'bg-purple-900 text-white' : 'text-purple-100 hover:bg-purple-700 hover:text-white' }}">
                                <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                Past Terms
                            </a>
                        </div>
                    </div>

                    <!-- Personal Section -->
                    <div>
                        <div class="px-3 mb-2">
                            <p class="text-xs font-semibold text-purple-300 uppercase tracking-wider">Personal</p>
                        </div>
                        <div class="space-y-1">
                            <!-- Messages -->
                            <a href="{{ route('hod.messages.index') }}" 
                               class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('hod.messages.*') ? 'bg-purple-900 text-white' : 'text-purple-100 hover:bg-purple-700 hover:text-white' }}">
                                <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                                </svg>
                                Messages
                                @php
                                    $unreadCount = auth()->user()->unreadNotifications()->count() + 
                                                 \App\Models\Message::where('receiver_id', auth()->id())
                                                     ->where('is_read', false)
                                                     ->count();
                                @endphp
                                @if($unreadCount > 0)
                                    <span class="ml-auto bg-red-600 text-white text-xs font-semibold px-2 py-1 rounded-full">{{ $unreadCount }}</span>
                                @endif
                            </a>

                            <!-- Profile -->
                            <a href="{{ route('hod.profile.show') }}" 
                               class="group flex items-center px-3 py-2 text-sm font-medium rounded-md {{ request()->routeIs('hod.profile.*') ? 'bg-purple-900 text-white' : 'text-purple-100 hover:bg-purple-700 hover:text-white' }}">
                                <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                </svg>
                                Profile
                            </a>
                        </div>
                    </div>
                </nav>

                <!-- Bottom Section - User Profile -->
                <div class="flex-shrink-0 flex border-t border-purple-700 p-4">
                    <div class="flex-shrink-0 w-full group block">
                        <div class="flex items-center">
                            <div class="h-10 w-10 rounded-full bg-purple-700 flex items-center justify-center">
                                <span class="text-white font-semibold text-sm">{{ substr(auth()->user()->name, 0, 1) }}</span>
                            </div>
                            <div class="ml-3 flex-1 min-w-0">
                                <p class="text-sm font-medium text-white truncate">{{ auth()->user()->name }}</p>
                                <p class="text-xs text-purple-200 truncate">Head of Department</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
