@extends('layouts.hod')

@section('title', 'Practical Evidence - ' . $practicalEvidence->student->name)

@section('content')
    <div class="mb-6">
        <a href="{{ route('hod.practical-evidence.index') }}" class="text-purple-600 hover:text-purple-900 flex items-center mb-4">
            <svg class="h-5 w-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
            Back to Portfolio Evidence
        </a>
        <h1 class="text-2xl font-bold text-gray-900">Practical Evidence</h1>
        <p class="mt-1 text-sm text-gray-600">{{ $practicalEvidence->student->name }} - {{ $practicalEvidence->unit->name }}</p>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Evidence Info -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Evidence Information</h3>
                </div>
                <div class="px-6 py-4">
                    <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Student</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                <div class="font-medium">{{ $practicalEvidence->student->name }}</div>
                                <div class="text-xs text-gray-500">{{ $practicalEvidence->student->admission_number }}</div>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Unit</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                <div class="font-medium">{{ $practicalEvidence->unit->name }}</div>
                                @if($practicalEvidence->unit->code)
                                    <div class="text-xs text-gray-500">{{ $practicalEvidence->unit->code }}</div>
                                @endif
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Class</dt>
                            <dd class="mt-1 text-sm text-gray-900">
                                <div class="font-medium">{{ $practicalEvidence->schoolClass->name }}</div>
                                @if($practicalEvidence->schoolClass->code)
                                    <div class="text-xs text-gray-500">{{ $practicalEvidence->schoolClass->code }}</div>
                                @endif
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Task Name</dt>
                            <dd class="mt-1 text-sm text-gray-900 font-medium">{{ $practicalEvidence->task_name }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Evidence Type</dt>
                            <dd class="mt-1">
                                <span class="px-2 py-1 text-xs font-semibold rounded-full 
                                    @if($practicalEvidence->isVideo()) bg-red-100 text-red-800
                                    @elseif($practicalEvidence->isImage()) bg-green-100 text-green-800
                                    @elseif($practicalEvidence->isAudio()) bg-purple-100 text-purple-800
                                    @else bg-blue-100 text-blue-800
                                    @endif">
                                    {{ ucfirst($practicalEvidence->evidence_type) }}
                                </span>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Status</dt>
                            <dd class="mt-1">
                                <span class="px-3 py-1 text-sm font-semibold rounded-full {{ $practicalEvidence->getStatusBadgeClasses() }}">
                                    {{ $practicalEvidence->getStatusLabel() }}
                                </span>
                            </dd>
                        </div>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Uploaded At</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $practicalEvidence->uploaded_at->format('M d, Y h:i A') }}</dd>
                        </div>
                    </dl>
                    @if($practicalEvidence->notes)
                        <div class="mt-4 pt-4 border-t border-gray-200">
                            <dt class="text-sm font-medium text-gray-500 mb-1">Student Notes</dt>
                            <dd class="text-sm text-gray-900 bg-gray-50 p-3 rounded">{{ $practicalEvidence->notes }}</dd>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Media Preview -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Media Evidence</h3>
                </div>
                <div class="px-6 py-4">
                    @if($practicalEvidence->isVideo())
                        <video controls class="w-full rounded-lg" style="max-height: 500px;">
                            <source src="{{ Storage::url($practicalEvidence->file_path) }}" type="{{ $practicalEvidence->mime_type }}">
                            Your browser does not support the video tag.
                        </video>
                    @elseif($practicalEvidence->isImage())
                        <img src="{{ Storage::url($practicalEvidence->file_path) }}" alt="{{ $practicalEvidence->task_name }}" class="w-full rounded-lg" style="max-height: 500px; object-fit: contain;">
                    @elseif($practicalEvidence->isAudio())
                        <audio controls class="w-full">
                            <source src="{{ Storage::url($practicalEvidence->file_path) }}" type="{{ $practicalEvidence->mime_type }}">
                            Your browser does not support the audio tag.
                        </audio>
                    @else
                        <div class="text-center py-8 bg-gray-50 rounded-lg">
                            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                            </svg>
                            <p class="mt-2 text-sm text-gray-500">Document file</p>
                        </div>
                    @endif
                    <div class="mt-4 flex items-center justify-between pt-4 border-t border-gray-200">
                        <div>
                            <p class="text-sm font-medium text-gray-900">{{ $practicalEvidence->original_name }}</p>
                            <p class="text-xs text-gray-500">{{ $practicalEvidence->file_size_human }}</p>
                        </div>
                        <a href="{{ route('hod.practical-evidence.download', $practicalEvidence) }}" class="px-4 py-2 bg-purple-600 text-white rounded-md hover:bg-purple-700 text-sm font-medium">
                            Download
                        </a>
                    </div>
                </div>
            </div>

            <!-- Comments -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Comments ({{ $practicalEvidence->comments->count() }})</h3>
                </div>
                <div class="px-6 py-4 space-y-4">
                    @forelse($practicalEvidence->comments as $comment)
                        <div class="border-l-4 border-purple-500 pl-4 py-2">
                            <div class="flex justify-between items-start mb-2">
                                <div>
                                    <p class="font-medium text-gray-900">{{ $comment->user->name ?? 'Unknown' }}</p>
                                    <p class="text-xs text-gray-500">{{ $comment->created_at->format('M d, Y h:i A') }}</p>
                                </div>
                                <span class="px-2 py-1 text-xs font-semibold rounded-full 
                                    @if($comment->role === 'hod') bg-purple-100 text-purple-800
                                    @elseif($comment->role === 'trainer') bg-blue-100 text-blue-800
                                    @else bg-indigo-100 text-indigo-800
                                    @endif">
                                    {{ ucfirst($comment->role) }}
                                </span>
                            </div>
                            <p class="text-sm text-gray-700">{{ $comment->comment }}</p>
                        </div>
                    @empty
                        <p class="text-sm text-gray-500 text-center py-4">No comments yet</p>
                    @endforelse
                </div>
            </div>

            <!-- Add Comment Form -->
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Add Comment</h3>
                </div>
                <div class="px-6 py-4">
                    <form action="{{ route('hod.practical-evidence.comment', $practicalEvidence) }}" method="POST">
                        @csrf
                        <div class="mb-4">
                            <textarea name="comment" rows="4" required class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500" placeholder="Add your comment here..."></textarea>
                            @error('comment')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                        <button type="submit" class="px-4 py-2 bg-purple-600 text-white rounded-md hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:ring-offset-2 text-sm font-medium">
                            Add Comment
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">File Information</h3>
                </div>
                <div class="px-6 py-4 space-y-3">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">File Name</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $practicalEvidence->original_name }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">File Size</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $practicalEvidence->file_size_human }}</dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">MIME Type</dt>
                        <dd class="mt-1 text-sm text-gray-900">{{ $practicalEvidence->mime_type }}</dd>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

