@extends('layouts.hod')

@section('title', 'Create User')
@section('page-title', 'Create New User')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900 mb-2">Create New User</h1>
                <p class="text-gray-600">Add a new user to your department</p>
            </div>
            <a href="{{ route('hod.users.index') }}" class="text-purple-600 hover:text-purple-800 font-medium">
                ← Back to Users
            </a>
        </div>
    </div>

    <!-- Form -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <form action="{{ route('hod.users.store') }}" method="POST" x-data="{
            selectedRole: '{{ old('role', '') }}',
            selectedUnits: @js(old('unit_ids', [])),
            units: @js($units->map(function($unit) {
                return ['id' => $unit->id, 'name' => $unit->name, 'code' => $unit->code];
            })->toArray()),
            toggleUnit(unitId) {
                const index = this.selectedUnits.indexOf(unitId);
                if (index > -1) {
                    this.selectedUnits.splice(index, 1);
                } else {
                    this.selectedUnits.push(unitId);
                }
            },
            isUnitSelected(unitId) {
                return this.selectedUnits.includes(unitId);
            }
        }">
            @csrf

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Name -->
                <div>
                    <label for="name" class="block text-sm font-medium text-gray-700 mb-1">Full Name <span class="text-red-500">*</span></label>
                    <input type="text" name="name" id="name" value="{{ old('name') }}" required
                           class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500 @error('name') border-red-300 @enderror">
                    @error('name')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Email -->
                <div>
                    <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Email Address <span class="text-red-500">*</span></label>
                    <input type="email" name="email" id="email" value="{{ old('email') }}" required
                           class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500 @error('email') border-red-300 @enderror">
                    @error('email')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Role -->
                <div>
                    <label for="role" class="block text-sm font-medium text-gray-700 mb-1">Role <span class="text-red-500">*</span></label>
                    <select name="role" id="role" required x-model="selectedRole"
                            class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500 @error('role') border-red-300 @enderror">
                        <option value="">Select Role</option>
                        <option value="trainer" {{ old('role') == 'trainer' ? 'selected' : '' }}>Trainer</option>
                        <option value="student" {{ old('role') == 'student' ? 'selected' : '' }}>Student</option>
                        <option value="validator" {{ old('role') == 'validator' ? 'selected' : '' }}>Validator</option>
                    </select>
                    @error('role')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Admission Number (for students) -->
                <div x-show="selectedRole === 'student'">
                    <label for="admission_number" class="block text-sm font-medium text-gray-700 mb-1">Admission Number</label>
                    <input type="text" name="admission_number" id="admission_number" value="{{ old('admission_number') }}"
                           class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500 @error('admission_number') border-red-300 @enderror">
                    @error('admission_number')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Phone -->
                <div>
                    <label for="phone" class="block text-sm font-medium text-gray-700 mb-1">Phone Number</label>
                    <input type="text" name="phone" id="phone" value="{{ old('phone') }}"
                           class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500 @error('phone') border-red-300 @enderror">
                    @error('phone')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Status -->
                <div>
                    <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Status <span class="text-red-500">*</span></label>
                    <select name="status" id="status" required
                            class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500 @error('status') border-red-300 @enderror">
                        <option value="active" {{ old('status', 'active') == 'active' ? 'selected' : '' }}>Active</option>
                        <option value="inactive" {{ old('status') == 'inactive' ? 'selected' : '' }}>Inactive</option>
                        <option value="suspended" {{ old('status') == 'suspended' ? 'selected' : '' }}>Suspended</option>
                    </select>
                    @error('status')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Password -->
                <div>
                    <label for="password" class="block text-sm font-medium text-gray-700 mb-1">Password <span class="text-red-500">*</span></label>
                    <input type="password" name="password" id="password" required
                           class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500 @error('password') border-red-300 @enderror">
                    @error('password')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Confirm Password -->
                <div>
                    <label for="password_confirmation" class="block text-sm font-medium text-gray-700 mb-1">Confirm Password <span class="text-red-500">*</span></label>
                    <input type="password" name="password_confirmation" id="password_confirmation" required
                           class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                </div>
            </div>

            <!-- Unit Selection (for Trainers) -->
            <div x-show="selectedRole === 'trainer'" 
                 x-cloak
                 class="mt-6 p-6 bg-gray-50 rounded-lg border border-gray-200">
                <div class="mb-4">
                    <h3 class="text-sm font-semibold text-gray-900 mb-2">Assign Units to Trainer (Optional)</h3>
                    <p class="text-xs text-gray-600 mb-4">
                        Select specific units to assign to this trainer. Units are optional - a trainer can exist without any assigned units.
                    </p>
                </div>
                
                @if($units->count() > 0)
                    <div class="max-h-60 overflow-y-auto border border-gray-200 rounded-md bg-white p-4">
                        <div class="space-y-2">
                            @foreach($units as $unit)
                                <label class="flex items-center space-x-3 p-2 hover:bg-gray-50 rounded cursor-pointer">
                                    <input type="checkbox" 
                                           value="{{ $unit->id }}"
                                           x-model="selectedUnits"
                                           @change="toggleUnit({{ $unit->id }})"
                                           name="unit_ids[]"
                                           class="rounded border-gray-300 text-purple-600 focus:ring-purple-500">
                                    <span class="text-sm text-gray-700">
                                        {{ $unit->name }}
                                        @if($unit->code)
                                            <span class="text-gray-500">({{ $unit->code }})</span>
                                        @endif
                                    </span>
                                </label>
                            @endforeach
                        </div>
                    </div>
                    <div class="mt-4 flex items-center justify-between">
                        <button type="button" 
                                @click="selectedUnits = units.map(u => u.id)"
                                class="text-xs text-purple-600 hover:text-purple-800">
                            Select All
                        </button>
                        <button type="button" 
                                @click="selectedUnits = []"
                                class="text-xs text-gray-600 hover:text-gray-800">
                            Clear Selection
                        </button>
                    </div>
                @else
                    <p class="text-sm text-gray-500">No units available in your department.</p>
                @endif
            </div>

            <!-- Form Actions -->
            <div class="mt-6 flex items-center justify-end space-x-3">
                <a href="{{ route('hod.users.index') }}" 
                   class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50">
                    Cancel
                </a>
                <button type="submit"
                        class="px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-purple-600 hover:bg-purple-700">
                    Create User
                </button>
            </div>
        </form>
    </div>
</div>
@endsection

