@extends('layouts.student')

@section('title', 'Practical Marks')
@section('page-title', 'Practical Marks')

@section('content')
<div class="max-w-4xl mx-auto space-y-4 sm:space-y-6 px-0 sm:px-4">
    <!-- Header -->
    <div class="bg-white rounded-xl shadow-md p-4 sm:p-6">
        <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
            <div class="min-w-0 flex-1">
                <h1 class="text-xl sm:text-2xl font-bold text-gray-900 mb-2 break-words">Practical Assessment Marks</h1>
                <p class="text-sm sm:text-base text-gray-600 break-words">Assignment: {{ $assignment->title }}</p>
                <p class="text-xs sm:text-sm text-gray-500">Unit: {{ $assignment->unit->name }} ({{ $assignment->unit->code }})</p>
            </div>
            <a href="{{ route('student.assignments.show', $assignment) }}" 
               class="inline-flex items-center min-h-[44px] text-blue-600 hover:text-blue-800 font-medium touch-manipulation flex-shrink-0">
                ← Back to Assignment
            </a>
        </div>
    </div>

    @if($markingStatus === 'not_marked')
        <div class="bg-yellow-50 border-l-4 border-yellow-500 p-4 rounded">
            <p class="text-sm text-yellow-700">
                <strong>Not Yet Marked:</strong> Your practical assessment has not been marked yet. Please check back later.
            </p>
        </div>
    @elseif($markingStatus === 'absent')
        <div class="bg-red-50 border-l-4 border-red-500 p-4 rounded">
            <p class="text-sm text-red-700">
                <strong>Absent:</strong> You were marked as absent for this practical assessment.
            </p>
        </div>
    @else
        <!-- Marks Summary -->
        <div class="bg-white rounded-xl shadow-md p-4 sm:p-6">
            <h2 class="text-base sm:text-lg font-semibold text-gray-900 mb-4">Your Marks</h2>
            <div class="grid grid-cols-2 gap-3 sm:gap-4">
                <div class="bg-blue-50 rounded-lg p-4">
                    <p class="text-sm text-gray-600">Marks Obtained</p>
                    <p class="text-3xl font-bold text-blue-900">{{ number_format($marks, 2) }}</p>
                </div>
                <div class="bg-gray-50 rounded-lg p-4">
                    <p class="text-sm text-gray-600">Total Marks</p>
                    <p class="text-3xl font-bold text-gray-900">{{ number_format($assignment->total_marks, 2) }}</p>
                </div>
            </div>
            <div class="mt-4">
                <p class="text-sm text-gray-600">Percentage</p>
                <p class="text-2xl font-bold text-gray-900">
                    {{ $assignment->total_marks > 0 ? number_format(($marks / $assignment->total_marks) * 100, 1) : 0 }}%
                </p>
            </div>
        </div>

        <!-- Detailed Marks (if available) -->
        @if($assessorToolMarks->count() > 0)
            <div class="bg-white rounded-xl shadow-md p-4 sm:p-6">
                <h2 class="text-base sm:text-lg font-semibold text-gray-900 mb-4">Detailed Marks Breakdown</h2>
                <div class="overflow-x-auto -mx-4 sm:mx-0" style="-webkit-overflow-scrolling: touch;">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-3 py-2 sm:px-4 sm:py-3 text-left text-xs font-medium text-gray-500 uppercase">Item</th>
                                <th class="px-3 py-2 sm:px-4 sm:py-3 text-center text-xs font-medium text-gray-500 uppercase">Marks Available</th>
                                <th class="px-3 py-2 sm:px-4 sm:py-3 text-center text-xs font-medium text-gray-500 uppercase">Marks Obtained</th>
                                <th class="px-3 py-2 sm:px-4 sm:py-3 text-left text-xs font-medium text-gray-500 uppercase">Comments</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($assessorToolMarks as $mark)
                                <tr>
                                    <td class="px-3 py-2 sm:px-4 sm:py-3 text-sm text-gray-900">{{ $mark->item_description }}</td>
                                    <td class="px-3 py-2 sm:px-4 sm:py-3 text-center text-sm text-gray-600">{{ number_format($mark->marks_available, 2) }}</td>
                                    <td class="px-3 py-2 sm:px-4 sm:py-3 text-center text-sm font-medium text-gray-900">{{ number_format($mark->marks_obtained, 2) }}</td>
                                    <td class="px-3 py-2 sm:px-4 sm:py-3 text-sm text-gray-600">{{ $mark->comments ?? '-' }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        @endif

        <!-- Download Completed Assessor Tool -->
        @if($submission && $submission->completed_assessor_tool_path)
            <div class="bg-white rounded-xl shadow-md p-6">
                <h2 class="text-lg font-semibold text-gray-900 mb-4">Completed Assessor Tool</h2>
                <p class="text-sm text-gray-600 mb-4">You can download the completed assessor tool document with your marks.</p>
                <div class="space-y-2">
                    <a href="{{ route('student.assignments.tool.download', ['assignment' => $assignment->id, 'toolType' => 'assessor', 'index' => 0]) }}" 
                       class="flex items-center p-3 min-h-[44px] border border-purple-200 rounded-lg hover:bg-purple-50 touch-manipulation">
                        <svg class="w-5 h-5 text-purple-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                        </svg>
                        <span class="text-sm text-gray-900">{{ basename($submission->completed_assessor_tool_path) }}</span>
                    </a>
                </div>
            </div>
        @endif
    @endif
</div>
@endsection

