@extends('layouts.trainer')

@section('title', 'Marks Management')

@section('content')
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl font-bold text-gray-900">Marks Management</h1>
        <p class="mt-1 text-sm text-gray-600">Select a unit to view validation readiness and print marks</p>
    </div>

    @if($activeTerm)
        <div class="mb-4 sm:mb-6">
            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-800">
                Active Term: {{ $activeTerm->name }}
            </span>
        </div>
    @endif

    <!-- Search -->
    <div class="bg-white rounded-lg shadow mb-4 sm:mb-6 p-4">
        <form method="GET" class="flex flex-col sm:flex-row gap-3">
            <div class="flex-1 w-full min-w-0">
                <label class="block text-sm font-medium text-gray-700 mb-1">Search Units</label>
                <input type="text" name="search" value="{{ request('search') }}" placeholder="Unit name or code"
                       class="w-full rounded-md border-gray-300 shadow-sm text-base">
            </div>
            <div class="flex flex-wrap gap-2 sm:items-end">
                <button type="submit" class="w-full sm:w-auto bg-blue-600 text-white px-4 py-2.5 rounded-md hover:bg-blue-700 touch-manipulation min-h-[44px]">Search</button>
                @if(request('search'))
                    <a href="{{ route('trainer.marks.index') }}" class="w-full sm:w-auto inline-block text-center bg-gray-200 text-gray-700 px-4 py-2.5 rounded-md hover:bg-gray-300 min-h-[44px] leading-[2.25rem]">Clear</a>
                @endif
            </div>
        </form>
    </div>

    <!-- Units List -->
    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="px-4 sm:px-6 py-4 border-b border-gray-200">
            <h2 class="text-base sm:text-lg font-semibold text-gray-900">My Units</h2>
            <p class="text-sm text-gray-600">{{ $units->count() }} allocation(s) assigned (unit × class)</p>
        </div>

        @if($units->count() > 0)
            <div class="p-4 sm:p-6">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3 sm:gap-4">
                    @foreach($units as $unit)
                        <a href="{{ route('trainer.marks.show-unit', ['unit' => $unit->id, 'class' => optional($unit->assigned_class)->id]) }}" 
                           class="block bg-white border-2 border-gray-200 rounded-lg p-4 sm:p-5 hover:border-purple-500 hover:shadow-lg transition-all touch-manipulation active:bg-gray-50">
                            <div class="flex items-start justify-between mb-3">
                                <div class="flex-1">
                                    <h3 class="text-lg font-semibold text-gray-900 mb-1">{{ $unit->name }}</h3>
                                    <p class="text-sm text-gray-600">{{ $unit->code }}</p>
                                </div>
                                @if($unit->classification)
                                    <span class="px-2 py-1 text-xs font-medium rounded-full 
                                        @if($unit->classification === 'core_unit') bg-purple-100 text-purple-800
                                        @elseif($unit->classification === 'basic_unit') bg-blue-100 text-blue-800
                                        @else bg-gray-100 text-gray-800
                                        @endif">
                                        {{ ucfirst(str_replace('_', ' ', $unit->classification)) }}
                                    </span>
                                @endif
                            </div>

                            @if($unit->department)
                                <p class="text-xs text-gray-500 mb-3">{{ $unit->department->name }}</p>
                            @endif

                            <div class="flex items-center gap-4 text-sm text-gray-600 mb-3">
                                <div class="flex items-center">
                                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                    </svg>
                                    <span>{{ $unit->assignments_count ?? 0 }} Assessments</span>
                                </div>
                                <div class="flex items-center">
                                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                    </svg>
                                    <span>Class: {{ optional($unit->assigned_class)->code ?? optional($unit->assigned_class)->name ?? 'N/A' }}</span>
                                </div>
                            </div>

                            @if($unit->isConfigured())
                                <div class="mt-3 pt-3 border-t border-gray-200">
                                    <p class="text-xs font-medium text-gray-700 mb-1">Assessment Structure:</p>
                                    @php
                                        $structure = $unit->getAssessmentStructure();
                                    @endphp
                                    <div class="flex flex-wrap gap-2">
                                        @if($structure['theory'] > 0)
                                            <span class="text-xs px-2 py-1 bg-blue-100 text-blue-800 rounded">Theory: {{ $structure['theory'] }}</span>
                                        @endif
                                        @if($structure['practical'] > 0)
                                            <span class="text-xs px-2 py-1 bg-purple-100 text-purple-800 rounded">Practical: {{ $structure['practical'] }}</span>
                                        @endif
                                        @if($structure['oral'] > 0)
                                            <span class="text-xs px-2 py-1 bg-green-100 text-green-800 rounded">Oral: {{ $structure['oral'] }}</span>
                                        @endif
                                        @if($structure['project'] > 0)
                                            <span class="text-xs px-2 py-1 bg-yellow-100 text-yellow-800 rounded">Project: {{ $structure['project'] }}</span>
                                        @endif
                                    </div>
                                </div>
                            @else
                                <div class="mt-3 pt-3 border-t border-gray-200">
                                    <p class="text-xs text-yellow-600">⚠ Not configured</p>
                                </div>
                            @endif

                            <div class="mt-4 flex items-center text-purple-600 text-sm font-medium">
                                <span>View Details</span>
                                <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                </svg>
                            </div>
                        </a>
                    @endforeach
                </div>
            </div>
        @else
            <div class="p-8 text-center">
                <p class="text-sm text-gray-500">No units assigned to you.</p>
            </div>
        @endif
    </div>
@endsection
