@extends('layouts.trainer')

@section('title', 'Message Details')

@section('content')
    <div class="mb-6">
        <a href="{{ route('trainer.messages.index') }}" class="text-blue-600 hover:text-blue-900">
            ← Back to Messages
        </a>
    </div>

    <div class="bg-white shadow rounded-lg p-6">
        <div class="mb-4">
            <h2 class="text-xl font-semibold text-gray-900">{{ $message->subject }}</h2>
            <p class="text-sm text-gray-600 mt-1">From: {{ $message->sender->name }} ({{ $message->sender->email }})</p>
        </div>
        <div class="prose max-w-none">
            <p class="text-gray-900 whitespace-pre-wrap">{{ $message->message }}</p>
        </div>
        <div class="mt-4 pt-4 border-t">
            <p class="text-sm text-gray-500">Received: {{ $message->created_at->format('M d, Y H:i') }}</p>
        </div>
    </div>
@endsection

