@extends('layouts.trainer')

@section('title', 'All Submissions')

@section('content')
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-900">All Submissions</h1>
        <p class="mt-1 text-sm text-gray-600">View all student submissions (PoE portfolios and assignments)</p>
    </div>

    @if($activeTerm)
        <div class="mb-6 p-4 bg-blue-50 border border-blue-200 rounded-lg">
            <p class="text-sm text-blue-800"><strong>Active Term:</strong> {{ $activeTerm->name }}</p>
        </div>
    @endif

    <!-- Filters -->
    <div class="bg-white rounded-lg shadow mb-6 p-4">
        <form method="GET" class="grid grid-cols-1 md:grid-cols-5 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                <input type="text" name="search" value="{{ request('search') }}" placeholder="Student name or email"
                       class="w-full rounded-md border-gray-300 shadow-sm">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                <select name="status" class="w-full rounded-md border-gray-300 shadow-sm">
                    <option value="">All Statuses</option>
                    <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>Draft</option>
                    <option value="submitted" {{ request('status') == 'submitted' ? 'selected' : '' }}>Submitted</option>
                    <option value="trainer_approved" {{ request('status') == 'trainer_approved' ? 'selected' : '' }}>Approved</option>
                    <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>Rejected</option>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Unit</label>
                <select name="unit" class="w-full rounded-md border-gray-300 shadow-sm">
                    <option value="">All Units</option>
                    @foreach($units as $unit)
                        <option value="{{ $unit->id }}" {{ request('unit') == $unit->id ? 'selected' : '' }}>{{ $unit->name }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Class</label>
                <select name="class" class="w-full rounded-md border-gray-300 shadow-sm">
                    <option value="">All Classes</option>
                    @foreach($classes as $class)
                        <option value="{{ $class->id }}" {{ request('class') == $class->id ? 'selected' : '' }}>{{ $class->name }}</option>
                    @endforeach
                </select>
            </div>
            <div class="flex items-end">
                <button type="submit" class="w-full bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700">Filter</button>
            </div>
        </form>
    </div>

    <!-- Submissions Table -->
    <div class="bg-white shadow rounded-lg overflow-hidden">
        @if($submissions->count() > 0)
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Student</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Unit</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Class</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Marks</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Submitted</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($submissions as $submission)
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900">{{ $submission->student->name }}</div>
                                    <div class="text-sm text-gray-500">{{ $submission->student->email }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-900">{{ $submission->unit->name }}</div>
                                    @if($submission->unit->code)
                                        <div class="text-sm text-gray-500">{{ $submission->unit->code }}</div>
                                    @endif
                                    @if(isset($submission->submission_type) && $submission->submission_type === 'assignment')
                                        <div class="text-xs text-blue-600 mt-1">Assignment</div>
                                    @else
                                        <div class="text-xs text-purple-600 mt-1">PoE</div>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    {{ $submission->schoolClass ? $submission->schoolClass->name : '-' }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @php
                                        $status = $submission->status ?? 'draft';
                                        if (isset($submission->submission_type) && $submission->submission_type === 'assignment') {
                                            // Map assignment status to display
                                            $statusMap = [
                                                'draft' => 'draft',
                                                'submitted' => 'submitted',
                                                'graded' => 'graded',
                                            ];
                                            $status = $statusMap[$status] ?? $status;
                                        }
                                    @endphp
                                    <span class="px-2 py-1 text-xs rounded-full 
                                        @if($status === 'trainer_approved' || $status === 'graded') bg-green-100 text-green-800
                                        @elseif($status === 'rejected') bg-red-100 text-red-800
                                        @elseif($status === 'needs_revision') bg-yellow-100 text-yellow-800
                                        @elseif($status === 'submitted') bg-blue-100 text-blue-800
                                        @else bg-gray-100 text-gray-800
                                        @endif">
                                        {{ ucfirst(str_replace('_', ' ', $status)) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    @if(isset($submission->submission_type) && $submission->submission_type === 'assignment')
                                        @if($submission->marks)
                                            {{ number_format($submission->marks, 2) }}{{ $submission->assignment->total_marks ? '/' . $submission->assignment->total_marks : '' }}
                                        @else
                                            -
                                        @endif
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    {{ $submission->display_submitted_at ? $submission->display_submitted_at->format('M d, Y') : ($submission->submitted_at ? $submission->submitted_at->format('M d, Y') : '-') }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                    @if(isset($submission->submission_type) && $submission->submission_type === 'assignment' && isset($submission->assignment))
                                        <a href="{{ route('trainer.assignments.show', $submission->assignment->id) }}" class="text-blue-600 hover:text-blue-900">View Assignment</a>
                                    @elseif(!isset($submission->submission_type) || $submission->submission_type === 'poe')
                                        <a href="{{ route('trainer.submissions.show', $submission) }}" class="text-blue-600 hover:text-blue-900">View</a>
                                    @else
                                        <span class="text-gray-400">-</span>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="px-6 py-4 border-t">
                {{ $submissions->links() }}
            </div>
        @else
            <div class="p-8 text-center">
                <p class="text-sm text-gray-500">No submissions found.</p>
            </div>
        @endif
    </div>
@endsection

