@extends('layouts.validator')

@section('title', 'View Portfolio')

@section('content')
    <div class="mb-6 flex items-center justify-between">
        <div>
            <a href="{{ route('validator.validation-requests.show', ['class' => $validationRequest->class_id, 'unit' => $validationRequest->unit_id]) }}"
               class="text-indigo-600 hover:text-indigo-900 flex items-center text-sm">
                <svg class="h-5 w-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                </svg>
                Back to Unit Validation
            </a>
            <h2 class="mt-3 text-xl font-semibold text-gray-900">
                Portfolio Evidence &middot;
                <span class="text-gray-700">{{ $validationRequest->unit->name }} ({{ $validationRequest->unit->code }})</span>
            </h2>
            <p class="mt-1 text-sm text-gray-500">
                Class: {{ $validationRequest->schoolClass->name }} ({{ $validationRequest->schoolClass->code }})
            </p>
        </div>
    </div>

    <div x-data="{ showModal: false, selected: null }" x-cloak>
        <div class="bg-white shadow-sm rounded-lg">
            <div class="px-6 py-4 border-b border-gray-200 bg-gray-50 flex items-center justify-between">
                <div>
                    <h3 class="text-lg font-semibold text-gray-900">Portfolio of Evidence – Students in Unit</h3>
                    <p class="mt-1 text-sm text-gray-500">
                        All students in this class for the unit. Use View Options to open the portfolio gallery, compiled Exams PDF, or compiled Practicals PDF (assessor checklists with marks) for verification.
                    </p>
                </div>
            </div>

            <div class="px-6 py-4">
                @if(empty($studentSummaries))
                    <p class="text-sm text-gray-500">
                        No students are enrolled in this class for the active term.
                    </p>
                @else
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                            <tr>
                                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Student
                                </th>
                                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Tasks
                                </th>
                                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Files
                                </th>
                                <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Last Submission
                                </th>
                                <th scope="col" class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                                    Action
                                </th>
                            </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($studentSummaries as $summary)
                                @php
                                    $student = $summary['student'];
                                @endphp
                                <tr class="hover:bg-gray-50">
                                    <td class="px-4 py-3 whitespace-nowrap">
                                        <button
                                            type="button"
                                            class="text-sm font-medium text-indigo-700 hover:text-indigo-900"
                                            @click="showModal = true; selected = {
                                                id: {{ $student->id }},
                                                name: @js($student->name),
                                                adm: @js($student->admission_number),
                                                portfolioUrl: '{{ route('validator.validation-requests.portfolio.student', ['validationRequest' => $validationRequest->id, 'student' => $student->id]) }}',
                                                examsUrl: '{{ route('validator.validation-requests.portfolio.student.exams', ['validationRequest' => $validationRequest->id, 'student' => $student->id]) }}?preview=1',
                                                practicalsUrl: '{{ route('validator.validation-requests.portfolio.student.practicals', ['validationRequest' => $validationRequest->id, 'student' => $student->id]) }}?preview=1'
                                            }"
                                        >
                                            {{ $student->name }}
                                        </button>
                                        @if($student->admission_number)
                                            <div class="text-xs text-gray-500">
                                                {{ $student->admission_number }}
                                            </div>
                                        @endif
                                    </td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">
                                        {{ $summary['tasks_count'] }}
                                    </td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-700">
                                        {{ $summary['files_count'] }}
                                    </td>
                                    <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-500">
                                        {{ $summary['last_submitted_at'] ?? '—' }}
                                    </td>
                                    <td class="px-4 py-3 whitespace-nowrap text-right text-sm">
                                        <button
                                            type="button"
                                            class="inline-flex items-center px-3 py-1.5 border border-indigo-600 text-xs font-medium rounded-full text-indigo-700 bg-white hover:bg-indigo-50"
                                            @click="showModal = true; selected = {
                                                id: {{ $student->id }},
                                                name: @js($student->name),
                                                adm: @js($student->admission_number),
                                                portfolioUrl: '{{ route('validator.validation-requests.portfolio.student', ['validationRequest' => $validationRequest->id, 'student' => $student->id]) }}',
                                                examsUrl: '{{ route('validator.validation-requests.portfolio.student.exams', ['validationRequest' => $validationRequest->id, 'student' => $student->id]) }}?preview=1',
                                                practicalsUrl: '{{ route('validator.validation-requests.portfolio.student.practicals', ['validationRequest' => $validationRequest->id, 'student' => $student->id]) }}?preview=1'
                                            }"
                                        >
                                            View Options
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                @endif
            </div>
        </div>

        <!-- Student category modal -->
        <div
            class="fixed inset-0 z-40 flex items-center justify-center bg-black bg-opacity-50"
            x-show="showModal"
            x-transition.opacity
        >
            <div class="bg-white rounded-lg shadow-xl max-w-md w-full mx-4"
                 @click.away="showModal = false">
                <div class="px-5 py-4 border-b border-gray-200 flex items-center justify-between">
                    <div>
                        <h3 class="text-sm font-semibold text-gray-900">Student Validation Options</h3>
                        <p class="text-xs text-gray-500 mt-1" x-text="selected ? (selected.name + (selected.adm ? ' (' + selected.adm + ')' : '')) : ''"></p>
                    </div>
                    <button class="text-gray-400 hover:text-gray-600" @click="showModal = false">
                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>
                <div class="px-5 py-4 space-y-3">
                    <button
                        type="button"
                        class="w-full inline-flex items-center justify-between px-4 py-2.5 rounded-md border border-gray-200 hover:bg-gray-50 text-sm text-gray-800"
                        @click="if (selected && selected.portfolioUrl) { window.open(selected.portfolioUrl, '_blank'); }"
                    >
                        <span class="flex items-center gap-2">
                            <span class="text-base">📁</span>
                            <span>View Portfolio (preview)</span>
                        </span>
                        <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                        </svg>
                    </button>
                    <button
                        type="button"
                        class="w-full inline-flex items-center justify-between px-4 py-2.5 rounded-md border border-gray-200 hover:bg-gray-50 text-sm text-gray-800"
                        @click="if (selected && selected.examsUrl) { window.open(selected.examsUrl, '_blank'); }"
                    >
                        <span class="flex items-center gap-2">
                            <span class="text-base">📘</span>
                            <span>Exams PDF (preview)</span>
                        </span>
                        <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                        </svg>
                    </button>
                    <button
                        type="button"
                        class="w-full inline-flex items-center justify-between px-4 py-2.5 rounded-md border border-gray-200 hover:bg-gray-50 text-sm text-gray-800"
                        @click="if (selected && selected.practicalsUrl) { window.open(selected.practicalsUrl, '_blank'); }"
                    >
                        <span class="flex items-center gap-2">
                            <span class="text-base">🛠</span>
                            <span>Practicals PDF (preview)</span>
                        </span>
                        <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                        </svg>
                    </button>
                </div>
                <div class="px-5 py-3 border-t border-gray-200 text-right">
                    <button
                        type="button"
                        class="px-4 py-1.5 text-xs font-medium text-gray-600 hover:text-gray-800"
                        @click="showModal = false"
                    >
                        Close
                    </button>
                </div>
            </div>
        </div>
    </div>
@endsection

