@extends('layouts.validator')

@section('title', 'Units Pending Validation')

@section('content')
<div class="mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Validation Requests</h1>
    <p class="mt-1 text-sm text-gray-600">Review and validate units pushed by trainers</p>
</div>

@if($activeTerm)
    <div class="mb-6 p-4 bg-indigo-50 border border-indigo-200 rounded-lg">
        <p class="text-sm text-indigo-800"><strong>Active Term:</strong> {{ $activeTerm->name }}</p>
    </div>
@endif

<!-- Filters -->
<div class="bg-white rounded-lg shadow mb-6 p-6">
    <form method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4">
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
            <select name="status" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                <option value="">All Statuses</option>
                <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>Approved</option>
                <option value="rejected" {{ request('status') == 'rejected' ? 'selected' : '' }}>Rejected</option>
                <option value="returned_to_trainer" {{ request('status') == 'returned_to_trainer' ? 'selected' : '' }}>Returned to Trainer</option>
            </select>
        </div>
        @if($classes->count() > 0)
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Class</label>
            <select name="class" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                <option value="">All Classes</option>
                @foreach($classes as $class)
                    <option value="{{ $class->id }}" {{ request('class') == $class->id ? 'selected' : '' }}>{{ $class->name }}</option>
                @endforeach
            </select>
        </div>
        @endif
        @if($units->count() > 0)
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Unit</label>
            <select name="unit" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                <option value="">All Units</option>
                @foreach($units as $unit)
                    <option value="{{ $unit->id }}" {{ request('unit') == $unit->id ? 'selected' : '' }}>{{ $unit->name }}</option>
                @endforeach
            </select>
        </div>
        @endif
        <div class="flex items-end gap-2">
            <button type="submit" class="flex-1 bg-indigo-600 text-white px-4 py-2 rounded-md hover:bg-indigo-700">Filter</button>
            @if(request()->anyFilled(['status', 'class', 'unit']))
            <a href="{{ route('validator.validation-requests.index') }}" class="px-4 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50">Clear</a>
            @endif
        </div>
    </form>
</div>

<!-- Units Table -->
@if($validationRequests->count() > 0)
<div class="bg-white shadow rounded-lg overflow-hidden">
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Unit Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Department / Class</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Trainer</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Date Pushed</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Action</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @foreach($validationRequests as $request)
                <tr class="hover:bg-gray-50">
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm font-medium text-gray-900">{{ $request->unit->name }}</div>
                        <div class="text-sm text-gray-500">Code: {{ $request->unit->code }}</div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="text-sm text-gray-900">{{ $request->schoolClass->name }}</div>
                        @if($request->schoolClass->department)
                            <div class="text-sm text-gray-500">{{ $request->schoolClass->department->name }}</div>
                        @endif
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600">
                        {{ $request->submitter->name }}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600">
                        {{ $request->submitted_at->format('M d, Y H:i') }}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="px-2 py-1 text-xs font-medium rounded-full
                            @if($request->status === 'pending') bg-yellow-100 text-yellow-800
                            @elseif($request->status === 'approved') bg-green-100 text-green-800
                            @elseif($request->status === 'rejected') bg-red-100 text-red-800
                            @else bg-blue-100 text-blue-800
                            @endif">
                            {{ ucfirst(str_replace('_', ' ', $request->status)) }}
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <div class="flex flex-col sm:flex-row sm:items-center gap-2">
                            <a href="{{ route('validator.validation-requests.show', ['class' => $request->schoolClass->id, 'unit' => $request->unit->id]) }}" 
                               class="inline-flex items-center px-3 py-1.5 rounded-full text-xs font-medium border border-indigo-600 text-indigo-700 bg-white hover:bg-indigo-50">
                                📊 View Marks
                            </a>
                            <a href="{{ route('validator.validation-requests.portfolio', $request->id) }}"
                               class="inline-flex items-center px-3 py-1.5 rounded-full text-xs font-medium border border-gray-300 text-gray-700 bg-white hover:bg-gray-50">
                                📁 View Portfolio
                            </a>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    
    <!-- Pagination -->
    @if($validationRequests->hasPages())
    <div class="px-6 py-4 border-t border-gray-200">
        {{ $validationRequests->links() }}
    </div>
    @endif
</div>
@else
<div class="bg-white shadow rounded-lg p-12 text-center">
    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
    </svg>
    <h3 class="mt-2 text-sm font-medium text-gray-900">No validation requests found</h3>
    <p class="mt-1 text-sm text-gray-500">
        @if($activeTerm)
            There are no validation requests for the active term ({{ $activeTerm->name }}) matching your filters.
        @else
            No validation requests found.
        @endif
    </p>
</div>
@endif
@endsection
