<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Unit Marks Summary Report - <?php echo e($unit->name); ?></title>
    <style>
        @media print {
            .no-print { display: none; }
            button { display: none; }
            body { margin: 10mm; padding: 0; }
            .page-break { page-break-after: always; }
            @page {
                size: A4;
                margin: 15mm;
            }
        }
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Times New Roman', serif;
            font-size: 11pt;
            line-height: 1.4;
            color: #000;
            background: #fff;
            padding: 20px;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        .letterhead {
            border-bottom: 3px solid #000;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        .letterhead-content {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        .logo-section {
            flex-shrink: 0;
        }
        .logo-section img {
            max-height: 80px;
            max-width: 120px;
            object-fit: contain;
        }
        .institution-info {
            width: 100%;
            text-align: center;
        }
        .institution-name {
            font-size: 22pt;
            font-weight: bold;
            text-transform: uppercase;
            margin-bottom: 4px;
            letter-spacing: 1.5px;
            text-align: center;
        }
        .department-name {
            font-size: 16pt;
            font-weight: bold;
            margin-top: 4px;
            margin-bottom: 8px;
            text-transform: uppercase;
            text-align: center;
        }
        .institution-details {
            font-size: 9pt;
            color: #333;
            line-height: 1.6;
            text-align: center;
        }
        .report-title {
            text-align: center;
            font-size: 20pt;
            font-weight: bold;
            text-transform: uppercase;
            margin: 25px 0 16px;
            padding-bottom: 6px;
            border-bottom: 2px solid #000;
            letter-spacing: 2px;
        }
        .metadata-section {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 25px;
        }
        .metadata-column {
            padding: 4px 0;
        }
        .metadata-item {
            display: flex;
            margin-bottom: 6px;
        }
        .metadata-label {
            font-weight: bold;
            min-width: 120px;
            text-transform: uppercase;
            font-size: 9pt;
        }
        .metadata-value {
            flex: 1;
            font-size: 10pt;
        }
        .section-title {
            font-size: 11pt;
            font-weight: bold;
            text-transform: uppercase;
            border-bottom: 2px solid #000;
            padding-bottom: 6px;
            margin-bottom: 12px;
        }
        table {
            width: 70%;
            border-collapse: collapse;
            margin: 20px auto;
            font-size: 9pt;
            page-break-inside: auto;
            border: 2px solid #000;
        }
        th, td {
            padding: 8px 6px;
            text-align: center;
            vertical-align: middle;
            border: 1px solid #000;
        }
        td.number {
            text-align: center;
        }
        th {
            background-color: #f5f5f5;
            font-weight: bold;
            font-size: 8pt;
            text-transform: uppercase;
            border: 1px solid #000;
        }
        tbody td {
            border: 1px solid #000;
        }
        .group-header {
            background-color: #c0c0c0 !important;
            font-weight: bold;
            font-size: 9pt;
        }
        .student-name-col {
            text-align: left;
            padding-left: 8px;
            min-width: 150px;
        }
        .admission-col {
            text-align: center;
            min-width: 100px;
        }
        .marks-col {
            text-align: center;
            min-width: 60px;
        }
        .category-average {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        .total-col {
            background-color: #f0f0f0;
            font-weight: bold;
        }
        tbody tr {
            page-break-inside: avoid;
        }
        tbody tr:nth-child(even) {
            background-color: #f7f7f7;
        }
        tbody tr {
            min-height: 35px;
        }
        .signature-row {
            display: flex;
            justify-content: space-between;
            gap: 40px;
            margin-top: auto;
            padding-top: 40px;
        }
        .content-wrapper {
            flex: 1;
            display: flex;
            flex-direction: column;
        }
        .signature-row div {
            width: 45%;
            font-size: 10pt;
        }
        .signature-row b {
            text-transform: uppercase;
        }
        .signature-row .signature-meta {
            margin-top: 8px;
        }
        .signature-row .signature-line-text {
            margin-top: 16px;
            font-size: 9pt;
        }
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #000;
            text-align: center;
            font-size: 9px;
            color: #666;
        }
        .footer-warning {
            font-weight: bold;
            color: #000;
            margin-bottom: 5px;
            font-size: 9px;
        }
    </style>
</head>
<body>
    <div class="no-print" style="margin-bottom: 20px; text-align: right;">
        <button onclick="window.print()" style="padding: 10px 20px; background: #3b82f6; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 14px;">
            Print
        </button>
        <button onclick="window.close()" style="padding: 10px 20px; background: #6b7280; color: white; border: none; border-radius: 5px; cursor: pointer; margin-left: 10px; font-size: 14px;">
            Close
        </button>
    </div>

    <div class="content-wrapper">
        <!-- Letterhead -->
        <div class="letterhead">
            <div class="letterhead-content">
                <?php if(isset($institutionSettings['institution.logo']) && $institutionSettings['institution.logo']): ?>
                    <div class="logo-section">
                        <img src="<?php echo e(asset('storage/' . $institutionSettings['institution.logo'])); ?>" alt="Institution Logo">
                    </div>
                <?php endif; ?>
                <div class="institution-info">
                    <div class="institution-name">
                        <?php echo e($institutionSettings['institution.name'] ?? config('app.name', 'Technical and Vocational Education Training Institution')); ?>

                    </div>
                    <div class="department-name">
                        Department of <?php echo e($unit->department->name ?? 'Computing'); ?>

                    </div>
                    <?php if(isset($institutionSettings['institution.address']) && $institutionSettings['institution.address']): ?>
                        <div class="institution-details">
                            <?php echo e($institutionSettings['institution.address']); ?>

                            <?php if(isset($institutionSettings['institution.phone']) && $institutionSettings['institution.phone']): ?>
                                | Tel: <?php echo e($institutionSettings['institution.phone']); ?>

                            <?php endif; ?>
                            <?php if(isset($institutionSettings['institution.email']) && $institutionSettings['institution.email']): ?>
                                | Email: <?php echo e($institutionSettings['institution.email']); ?>

                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">
            UNIT MARKS SUMMARY REPORT
        </div>

        <!-- Metadata Section -->
        <div class="metadata-section">
            <div class="metadata-column">
                <h4 class="section-title">Unit Information</h4>
                <div class="metadata-item">
                    <span class="metadata-label">Department:</span>
                    <span class="metadata-value"><?php echo e($unit->department->name ?? 'N/A'); ?></span>
                </div>
                <div class="metadata-item">
                    <span class="metadata-label">Unit Name:</span>
                    <span class="metadata-value"><?php echo e($unit->name); ?></span>
                </div>
                <div class="metadata-item">
                    <span class="metadata-label">Unit Code:</span>
                    <span class="metadata-value"><?php echo e($unit->code ?? 'N/A'); ?></span>
                </div>
            </div>
            <div class="metadata-column">
                <h4 class="section-title">Report Information</h4>
                <div class="metadata-item">
                    <span class="metadata-label">Academic Term:</span>
                    <span class="metadata-value"><?php echo e($activeTerm->name ?? 'N/A'); ?></span>
                </div>
                <div class="metadata-item">
                    <span class="metadata-label">Total Students:</span>
                    <span class="metadata-value"><?php echo e($students->count()); ?></span>
                </div>
                <div class="metadata-item">
                    <span class="metadata-label">Total Assessments:</span>
                    <span class="metadata-value"><?php echo e(count($assignments)); ?></span>
                </div>
                <div class="metadata-item">
                    <span class="metadata-label">Report Date:</span>
                    <span class="metadata-value"><?php echo e(now()->format('d M Y, h:i A')); ?></span>
                </div>
            </div>
        </div>

        <?php if(count($assignments) > 0 && $students->count() > 0): ?>
        <?php
            $hasTheory = isset($groupedAssignments['theory']) && count($groupedAssignments['theory']) > 0;
            $hasPractical = isset($groupedAssignments['practical']) && count($groupedAssignments['practical']) > 0;
            $hasOral = isset($groupedAssignments['oral']) && count($groupedAssignments['oral']) > 0;
            $hasProject = isset($groupedAssignments['project']) && count($groupedAssignments['project']) > 0;
        ?>

        <table class="marks-table">
            <thead>
                <!-- First Header Row -->
                <tr>
                    <th rowspan="2" style="width: 30px;">#</th>
                    <th rowspan="2" class="student-name-col">Student Name</th>
                    <th rowspan="2" class="admission-col">Admission No</th>
                    
                    <?php if($hasTheory): ?>
                        <th colspan="<?php echo e(count($groupedAssignments['theory']) + 1); ?>" class="group-header">THEORY EXAMS</th>
                    <?php endif; ?>
                    
                    <?php if($hasPractical): ?>
                        <th colspan="<?php echo e(count($groupedAssignments['practical']) + 1); ?>" class="group-header">PRACTICALS</th>
                    <?php endif; ?>
                    
                    <?php if($hasOral): ?>
                        <th colspan="<?php echo e(count($groupedAssignments['oral']) + 1); ?>" class="group-header">ORAL ASSESSMENTS</th>
                    <?php endif; ?>
                    
                    <?php if($hasProject): ?>
                        <th colspan="<?php echo e(count($groupedAssignments['project']) + 1); ?>" class="group-header">PROJECTS</th>
                    <?php endif; ?>
                    
                    <th rowspan="2" class="total-col">Total</th>
                </tr>
                
                <!-- Second Header Row -->
                <tr>
                    <?php if($hasTheory): ?>
                        <?php $__currentLoopData = $groupedAssignments['theory']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <th class="marks-col">EXAM <?php echo e($index + 1); ?></th>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <th class="category-average">T (Avg)</th>
                    <?php endif; ?>
                    
                    <?php if($hasPractical): ?>
                        <?php $__currentLoopData = $groupedAssignments['practical']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <th class="marks-col">PRACTICAL <?php echo e($index + 1); ?></th>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <th class="category-average">P (Avg)</th>
                    <?php endif; ?>
                    
                    <?php if($hasOral): ?>
                        <?php $__currentLoopData = $groupedAssignments['oral']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <th class="marks-col">ORAL <?php echo e($index + 1); ?></th>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <th class="category-average">O (Avg)</th>
                    <?php endif; ?>
                    
                    <?php if($hasProject): ?>
                        <?php $__currentLoopData = $groupedAssignments['project']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <th class="marks-col">PROJECT <?php echo e($index + 1); ?></th>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <th class="category-average">PRJ (Avg)</th>
                    <?php endif; ?>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $studentTotal = 0;
                        $studentMaxTotal = 0;
                    ?>
                    <tr>
                        <td><?php echo e($index + 1); ?></td>
                        <td class="student-name-col"><?php echo e($student->name); ?></td>
                        <td class="admission-col"><?php echo e($student->admission_number ?? 'N/A'); ?></td>
                        
                        <?php if($hasTheory): ?>
                            <?php $__currentLoopData = $groupedAssignments['theory']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $marks = $marksData[$student->id][$assignment->id]['marks'] ?? null;
                                    $totalMarks = $marksData[$student->id][$assignment->id]['total_marks'] ?? 0;
                                    if ($marks !== null) {
                                        $studentTotal += $marks;
                                        $studentMaxTotal += $totalMarks;
                                    }
                                ?>
                                <td class="marks-col number">
                                    <?php if($marks !== null): ?>
                                        <?php echo e(number_format($marks, 2)); ?>

                                    <?php else: ?>
                                        —
                                    <?php endif; ?>
                                </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $theoryAvg = $categoryAverages[$student->id]['theory'] ?? null;
                            ?>
                            <td class="category-average">
                                <?php if($theoryAvg && $theoryAvg['total_marks'] > 0 && $theoryAvg['count'] > 0): ?>
                                    <?php echo e(number_format($theoryAvg['total_marks'] / $theoryAvg['count'], 2)); ?>

                                <?php else: ?>
                                    —
                                <?php endif; ?>
                            </td>
                        <?php endif; ?>
                        
                        <?php if($hasPractical): ?>
                            <?php $__currentLoopData = $groupedAssignments['practical']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $marks = $marksData[$student->id][$assignment->id]['marks'] ?? null;
                                    $totalMarks = $marksData[$student->id][$assignment->id]['total_marks'] ?? 0;
                                    if ($marks !== null) {
                                        $studentTotal += $marks;
                                        $studentMaxTotal += $totalMarks;
                                    }
                                ?>
                                <td class="marks-col number">
                                    <?php if($marks !== null): ?>
                                        <?php echo e(number_format($marks, 2)); ?>

                                    <?php else: ?>
                                        —
                                    <?php endif; ?>
                                </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $practicalAvg = $categoryAverages[$student->id]['practical'] ?? null;
                            ?>
                            <td class="category-average">
                                <?php if($practicalAvg && $practicalAvg['total_marks'] > 0 && $practicalAvg['count'] > 0): ?>
                                    <?php echo e(number_format($practicalAvg['total_marks'] / $practicalAvg['count'], 2)); ?>

                                <?php else: ?>
                                    —
                                <?php endif; ?>
                            </td>
                        <?php endif; ?>
                        
                        <?php if($hasOral): ?>
                            <?php $__currentLoopData = $groupedAssignments['oral']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $marks = $marksData[$student->id][$assignment->id]['marks'] ?? null;
                                    $totalMarks = $marksData[$student->id][$assignment->id]['total_marks'] ?? 0;
                                    if ($marks !== null) {
                                        $studentTotal += $marks;
                                        $studentMaxTotal += $totalMarks;
                                    }
                                ?>
                                <td class="marks-col number">
                                    <?php if($marks !== null): ?>
                                        <?php echo e(number_format($marks, 2)); ?>

                                    <?php else: ?>
                                        —
                                    <?php endif; ?>
                                </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $oralAvg = $categoryAverages[$student->id]['oral'] ?? null;
                            ?>
                            <td class="category-average">
                                <?php if($oralAvg && $oralAvg['total_marks'] > 0 && $oralAvg['count'] > 0): ?>
                                    <?php echo e(number_format($oralAvg['total_marks'] / $oralAvg['count'], 2)); ?>

                                <?php else: ?>
                                    —
                                <?php endif; ?>
                            </td>
                        <?php endif; ?>
                        
                        <?php if($hasProject): ?>
                            <?php $__currentLoopData = $groupedAssignments['project']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $marks = $marksData[$student->id][$assignment->id]['marks'] ?? null;
                                    $totalMarks = $marksData[$student->id][$assignment->id]['total_marks'] ?? 0;
                                    if ($marks !== null) {
                                        $studentTotal += $marks;
                                        $studentMaxTotal += $totalMarks;
                                    }
                                ?>
                                <td class="marks-col number">
                                    <?php if($marks !== null): ?>
                                        <?php echo e(number_format($marks, 2)); ?>

                                    <?php else: ?>
                                        —
                                    <?php endif; ?>
                                </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $projectAvg = $categoryAverages[$student->id]['project'] ?? null;
                            ?>
                            <td class="category-average">
                                <?php if($projectAvg && $projectAvg['total_marks'] > 0 && $projectAvg['count'] > 0): ?>
                                    <?php echo e(number_format($projectAvg['total_marks'] / $projectAvg['count'], 2)); ?>

                                <?php else: ?>
                                    —
                                <?php endif; ?>
                            </td>
                        <?php endif; ?>
                        
                        <td class="total-col">
                            <?php if($studentMaxTotal > 0): ?>
                                <?php echo e(number_format($studentTotal, 2)); ?>

                            <?php else: ?>
                                —
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <?php else: ?>
            <div style="text-align: center; padding: 40px; color: #666;">
                <p>No data available for this unit.</p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Signatures -->
    <div class="signature-row">
        <div>
            <b>Trainer / Assessor</b>
            <div class="signature-meta">
                Name: _____________________
            </div>
            <div class="signature-line-text">
                Signature: _____________ &nbsp;&nbsp;&nbsp; Date: _______
            </div>
        </div>
        <div>
            <b>Head of Department / Verifier</b>
            <div class="signature-meta">
                Name: <?php echo e($hod->name ?? '_____________________'); ?>

            </div>
            <div class="signature-line-text">
                Signature: _____________ &nbsp;&nbsp;&nbsp; Date: _______
            </div>
        </div>
    </div>

    <!-- Footer -->
    <div class="footer">
        <div class="footer-warning">
            SYSTEM GENERATED REPORT – NO ALTERATIONS ALLOWED
        </div>
        <div>
            Generated on <?php echo e(now()->format('d M Y, h:i A')); ?> | <?php echo e($institutionSettings['institution.footer_text'] ?? config('app.name', 'e-PoE System')); ?>

        </div>
    </div>
</body>
</html>

<?php /**PATH D:\poe\resources\views/hod/marks/print-unit.blade.php ENDPATH**/ ?>