<?php $__env->startSection('title', 'Mark Submission'); ?>

<?php
use Illuminate\Support\Facades\Storage;
?>

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto">
    <!-- Header -->
    <div class="mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Mark Submission</h1>
                <p class="mt-1 text-sm text-gray-500"><?php echo e($assignment->title); ?></p>
            </div>
            <a href="<?php echo e(route('trainer.assignments.show', $assignment)); ?>" 
               class="inline-flex items-center px-4 py-2 bg-gray-200 text-gray-700 text-sm font-medium rounded-md hover:bg-gray-300">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                </svg>
                Back to Assignment
            </a>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Content -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Student Information -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Student Information</h3>
                <dl class="grid grid-cols-2 gap-4">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Name</dt>
                        <dd class="mt-1 text-sm text-gray-900"><?php echo e($submission->student->name ?? 'N/A'); ?></dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Admission Number</dt>
                        <dd class="mt-1 text-sm text-gray-900"><?php echo e($submission->student->admission_number ?? 'N/A'); ?></dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Email</dt>
                        <dd class="mt-1 text-sm text-gray-900"><?php echo e($submission->student->email ?? 'N/A'); ?></dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Submitted At</dt>
                        <dd class="mt-1 text-sm text-gray-900">
                            <?php echo e($submission->submitted_at ? $submission->submitted_at->format('M d, Y H:i') : 'Not submitted'); ?>

                        </dd>
                    </div>
                </dl>
            </div>

            <!-- Submission Content -->
            <?php if($submission->feedback): ?>
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Student Feedback/Notes</h3>
                    <div class="text-gray-900 whitespace-pre-wrap"><?php echo e($submission->feedback); ?></div>
                </div>
            <?php endif; ?>

            <!-- Attachments -->
            <?php if($submission->attachments && count($submission->attachments) > 0): ?>
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Submitted Files</h3>
                    <div class="space-y-2">
                        <?php $__currentLoopData = $submission->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(Storage::disk('public')->url($attachment)); ?>" 
                               target="_blank"
                               class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50">
                                <svg class="w-5 h-5 text-gray-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                </svg>
                                <span class="text-sm text-gray-900"><?php echo e(basename($attachment)); ?></span>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Marking Form -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Marking</h3>
                <form action="<?php echo e(route('trainer.assignments.submissions.mark', ['assignment' => $assignment->id, 'submission' => $submission->id])); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="space-y-4">
                        <div>
                            <label for="marks" class="block text-sm font-medium text-gray-700 mb-1">
                                Marks <span class="text-red-500">*</span>
                                <span class="text-gray-500 text-xs">(Out of <?php echo e($assignment->total_marks ?? 'N/A'); ?>)</span>
                            </label>
                            <input type="number" 
                                   name="marks" 
                                   id="marks" 
                                   value="<?php echo e(old('marks', $submission->marks)); ?>"
                                   min="0" 
                                   max="<?php echo e($assignment->total_marks ?? 100); ?>"
                                   step="0.01"
                                   required
                                   class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 <?php $__errorArgs = ['marks'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <?php $__errorArgs = ['marks'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div>
                            <label for="trainer_feedback" class="block text-sm font-medium text-gray-700 mb-1">
                                Feedback/Comments
                            </label>
                            <textarea name="trainer_feedback" 
                                      id="trainer_feedback" 
                                      rows="6"
                                      class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 <?php $__errorArgs = ['trainer_feedback'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-300 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"><?php echo e(old('trainer_feedback', $submission->trainer_feedback)); ?></textarea>
                            <?php $__errorArgs = ['trainer_feedback'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <p class="mt-1 text-xs text-gray-500">Provide feedback to help the student improve.</p>
                        </div>

                        <div class="flex items-center justify-end gap-3 pt-4 border-t">
                            <a href="<?php echo e(route('trainer.assignments.show', $assignment)); ?>" 
                               class="px-4 py-2 bg-gray-200 text-gray-700 rounded-md hover:bg-gray-300">
                                Cancel
                            </a>
                            <button type="submit" 
                                    class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700">
                                Save Marks
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Sidebar -->
        <div class="space-y-6">
            <!-- Assignment Info -->
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Assignment Details</h3>
                <dl class="space-y-3">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Type</dt>
                        <dd class="mt-1 text-sm text-gray-900"><?php echo e($assignment->getTypeLabel()); ?></dd>
                    </div>
                    <?php if($assignment->total_marks): ?>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Total Marks</dt>
                            <dd class="mt-1 text-sm text-gray-900"><?php echo e($assignment->total_marks); ?></dd>
                        </div>
                    <?php endif; ?>
                    <?php if($assignment->due_date): ?>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Due Date</dt>
                            <dd class="mt-1 text-sm text-gray-900"><?php echo e($assignment->due_date->format('M d, Y H:i')); ?></dd>
                        </div>
                    <?php endif; ?>
                </dl>
            </div>

            <!-- Current Marks -->
            <?php if($submission->marks !== null): ?>
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Current Marks</h3>
                    <div class="text-center">
                        <div class="text-3xl font-bold text-blue-600">
                            <?php echo e(number_format($submission->marks, 2)); ?>

                        </div>
                        <div class="text-sm text-gray-500 mt-1">
                            out of <?php echo e($assignment->total_marks ?? 'N/A'); ?>

                        </div>
                        <?php if($assignment->total_marks): ?>
                            <div class="text-sm text-gray-500 mt-2">
                                <?php echo e(number_format(($submission->marks / $assignment->total_marks) * 100, 1)); ?>%
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.trainer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/trainer/assignments/mark-submission.blade.php ENDPATH**/ ?>