<?php $__env->startSection('title', 'System Settings'); ?>
<?php $__env->startSection('page-title', 'System Settings'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <h1 class="text-2xl font-bold text-gray-900 mb-2">System Settings</h1>
        <p class="text-gray-600">Manage institution information, system configuration, notifications, and file upload settings</p>
    </div>

    <!-- Tabs -->
    <div class="bg-white rounded-xl shadow-md" x-data="{ activeTab: '<?php echo e(session('activeTab', 'institution')); ?>' }">
        <div class="border-b border-gray-200">
            <nav class="flex -mb-px">
                <button @click="activeTab = 'institution'" 
                        :class="activeTab === 'institution' ? 'border-indigo-500 text-indigo-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'"
                        class="py-4 px-6 text-sm font-medium border-b-2 transition-colors">
                    <svg class="w-5 h-5 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                    </svg>
                    Institution Information
                </button>
                <button @click="activeTab = 'system'" 
                        :class="activeTab === 'system' ? 'border-indigo-500 text-indigo-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'"
                        class="py-4 px-6 text-sm font-medium border-b-2 transition-colors">
                    <svg class="w-5 h-5 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    </svg>
                    System Configuration
                </button>
                <button @click="activeTab = 'notifications'" 
                        :class="activeTab === 'notifications' ? 'border-indigo-500 text-indigo-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'"
                        class="py-4 px-6 text-sm font-medium border-b-2 transition-colors">
                    <svg class="w-5 h-5 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                    </svg>
                    Notifications
                </button>
                <button @click="activeTab = 'files'" 
                        :class="activeTab === 'files' ? 'border-indigo-500 text-indigo-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'"
                        class="py-4 px-6 text-sm font-medium border-b-2 transition-colors">
                    <svg class="w-5 h-5 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    File Upload
                </button>
                <button @click="activeTab = 'security'" 
                        :class="activeTab === 'security' ? 'border-indigo-500 text-indigo-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'"
                        class="py-4 px-6 text-sm font-medium border-b-2 transition-colors">
                    <svg class="w-5 h-5 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                    </svg>
                    Backup & Security
                </button>
            </nav>
        </div>

        <!-- Tab Content -->
        <div class="p-6">
            <!-- Institution Information Tab -->
            <div x-show="activeTab === 'institution'" x-transition x-cloak>
                <div class="mb-4">
                    <h2 class="text-lg font-semibold text-gray-900">Institution Information</h2>
                    <p class="text-sm text-gray-600 mt-1">Configure institution details for report headers and footers</p>
                </div>
                <form action="<?php echo e(route('admin.settings.institution')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="institution_name" class="block text-sm font-medium text-gray-700 mb-1">Institution Name *</label>
                            <input type="text" name="institution_name" id="institution_name" 
                                   value="<?php echo e($institutionSettings['institution.name'] ?? ''); ?>"
                                   class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" required>
                        </div>
                        <div>
                            <label for="institution_phone" class="block text-sm font-medium text-gray-700 mb-1">Phone</label>
                            <input type="text" name="institution_phone" id="institution_phone" 
                                   value="<?php echo e($institutionSettings['institution.phone'] ?? ''); ?>"
                                   class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        </div>
                        <div class="md:col-span-2">
                            <label for="institution_address" class="block text-sm font-medium text-gray-700 mb-1">Address</label>
                            <textarea name="institution_address" id="institution_address" rows="2"
                                      class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"><?php echo e($institutionSettings['institution.address'] ?? ''); ?></textarea>
                        </div>
                        <div>
                            <label for="institution_email" class="block text-sm font-medium text-gray-700 mb-1">Email</label>
                            <input type="email" name="institution_email" id="institution_email" 
                                   value="<?php echo e($institutionSettings['institution.email'] ?? ''); ?>"
                                   class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        </div>
                        <div>
                            <label for="institution_website" class="block text-sm font-medium text-gray-700 mb-1">Website</label>
                            <input type="url" name="institution_website" id="institution_website" 
                                   value="<?php echo e($institutionSettings['institution.website'] ?? ''); ?>"
                                   placeholder="https://www.example.com"
                                   class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                        </div>
                        <div class="md:col-span-2">
                            <label for="institution_logo" class="block text-sm font-medium text-gray-700 mb-1">Logo</label>
                            <div class="flex items-center space-x-4">
                                <?php if(isset($institutionSettings['institution.logo']) && $institutionSettings['institution.logo']): ?>
                                    <div class="flex-shrink-0">
                                        <img src="<?php echo e(asset('storage/' . $institutionSettings['institution.logo'])); ?>" 
                                             alt="Logo" class="h-20 w-20 object-contain border border-gray-300 rounded">
                                    </div>
                                <?php endif; ?>
                                <div class="flex-1">
                                    <input type="file" name="institution_logo" id="institution_logo" 
                                           accept="image/*"
                                           class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    <p class="mt-1 text-xs text-gray-500">PNG, JPG, GIF up to 2MB</p>
                                    <?php if(isset($institutionSettings['institution.logo']) && $institutionSettings['institution.logo']): ?>
                                        <button type="submit"
                                                form="delete_institution_logo_form"
                                                class="mt-2 text-sm text-red-600 hover:text-red-800">
                                            Delete current logo
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div class="md:col-span-2">
                            <label for="institution_footer_text" class="block text-sm font-medium text-gray-700 mb-1">Footer Text</label>
                            <textarea name="institution_footer_text" id="institution_footer_text" rows="2"
                                      class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"><?php echo e($institutionSettings['institution.footer_text'] ?? ''); ?></textarea>
                            <p class="mt-1 text-xs text-gray-500">This text will appear in the footer of all reports</p>
                        </div>
                    </div>
                    
                    <div class="mt-6 flex justify-end">
                        <button type="submit" class="px-6 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">
                            Save Institution Settings
                        </button>
                    </div>
                </form>
            </div>

            <!-- System Configuration Tab -->
            <div x-show="activeTab === 'system'" x-transition x-cloak>
                <div class="mb-4">
                    <h2 class="text-lg font-semibold text-gray-900">System Configuration</h2>
                    <p class="text-sm text-gray-600 mt-1">Configure system-wide settings and preferences</p>
                </div>
                <form action="<?php echo e(route('admin.settings.system')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="system_name" class="block text-sm font-medium text-gray-700 mb-1">System Name *</label>
                            <input type="text" name="system_name" id="system_name" 
                                   value="<?php echo e($systemSettings['system.name'] ?? config('app.name', 'e-PoE System')); ?>"
                                   class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" 
                                   required>
                            <p class="mt-1 text-xs text-gray-500">Display name for the system (appears in page titles)</p>
                        </div>
                        <div>
                            <label for="system_favicon" class="block text-sm font-medium text-gray-700 mb-1">Favicon</label>
                            <div class="flex items-center space-x-4">
                                <?php if(isset($systemSettings['system.favicon']) && $systemSettings['system.favicon']): ?>
                                    <div class="flex-shrink-0">
                                        <img src="<?php echo e(asset('storage/' . $systemSettings['system.favicon'])); ?>" 
                                             alt="Favicon" class="h-16 w-16 object-contain border border-gray-300 rounded">
                                    </div>
                                <?php endif; ?>
                                <div class="flex-1">
                                    <input type="file" name="system_favicon" id="system_favicon" 
                                           accept="image/x-icon,image/png,image/jpeg,image/svg+xml"
                                           class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    <p class="mt-1 text-xs text-gray-500">ICO, PNG, JPG, or SVG up to 1MB. Recommended: 32x32px or 16x16px</p>
                                    <?php if(isset($systemSettings['system.favicon']) && $systemSettings['system.favicon']): ?>
                                        <button type="submit"
                                                form="delete_system_favicon_form"
                                                class="mt-2 text-sm text-red-600 hover:text-red-800">
                                            Delete current favicon
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <div>
                            <label for="system_timezone" class="block text-sm font-medium text-gray-700 mb-1">Timezone *</label>
                            <select name="system_timezone" id="system_timezone" 
                                    class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" 
                                    required>
                                <option value="Africa/Nairobi" <?php echo e(($systemSettings['system.timezone'] ?? 'Africa/Nairobi') === 'Africa/Nairobi' ? 'selected' : ''); ?>>Africa/Nairobi (EAT)</option>
                                <option value="Africa/Dar_es_Salaam" <?php echo e(($systemSettings['system.timezone'] ?? '') === 'Africa/Dar_es_Salaam' ? 'selected' : ''); ?>>Africa/Dar es Salaam (EAT)</option>
                                <option value="Africa/Kampala" <?php echo e(($systemSettings['system.timezone'] ?? '') === 'Africa/Kampala' ? 'selected' : ''); ?>>Africa/Kampala (EAT)</option>
                                <option value="UTC" <?php echo e(($systemSettings['system.timezone'] ?? '') === 'UTC' ? 'selected' : ''); ?>>UTC</option>
                            </select>
                        </div>
                        <div>
                            <label for="system_date_format" class="block text-sm font-medium text-gray-700 mb-1">Date Format *</label>
                            <select name="system_date_format" id="system_date_format" 
                                    class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" 
                                    required>
                                <option value="d/m/Y" <?php echo e(($systemSettings['system.date_format'] ?? 'd/m/Y') === 'd/m/Y' ? 'selected' : ''); ?>>DD/MM/YYYY (e.g., 25/12/2025)</option>
                                <option value="Y-m-d" <?php echo e(($systemSettings['system.date_format'] ?? '') === 'Y-m-d' ? 'selected' : ''); ?>>YYYY-MM-DD (e.g., 2025-12-25)</option>
                                <option value="m/d/Y" <?php echo e(($systemSettings['system.date_format'] ?? '') === 'm/d/Y' ? 'selected' : ''); ?>>MM/DD/YYYY (e.g., 12/25/2025)</option>
                                <option value="d M Y" <?php echo e(($systemSettings['system.date_format'] ?? '') === 'd M Y' ? 'selected' : ''); ?>>DD MMM YYYY (e.g., 25 Dec 2025)</option>
                            </select>
                        </div>
                        <div>
                            <label for="system_time_format" class="block text-sm font-medium text-gray-700 mb-1">Time Format *</label>
                            <select name="system_time_format" id="system_time_format" 
                                    class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" 
                                    required>
                                <option value="H:i" <?php echo e(($systemSettings['system.time_format'] ?? 'H:i') === 'H:i' ? 'selected' : ''); ?>>24 Hour (e.g., 14:30)</option>
                                <option value="h:i A" <?php echo e(($systemSettings['system.time_format'] ?? '') === 'h:i A' ? 'selected' : ''); ?>>12 Hour (e.g., 2:30 PM)</option>
                            </select>
                        </div>
                        <div class="md:col-span-2">
                            <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
                                <label class="flex items-start">
                                    <input type="checkbox" name="system_maintenance_mode" value="1"
                                           <?php echo e(($systemSettings['system.maintenance_mode'] ?? false) ? 'checked' : ''); ?>

                                           class="mt-1 rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                    <div class="ml-3">
                                        <span class="text-sm font-medium text-gray-900">Enable Maintenance Mode</span>
                                        <p class="text-xs text-gray-600 mt-1">When enabled, only administrators can access the system</p>
                                    </div>
                                </label>
                            </div>
                        </div>
                        <div class="md:col-span-2">
                            <label for="system_maintenance_message" class="block text-sm font-medium text-gray-700 mb-1">Maintenance Message</label>
                            <textarea name="system_maintenance_message" id="system_maintenance_message" rows="3"
                                      placeholder="The system is currently under maintenance. Please check back later."
                                      class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"><?php echo e($systemSettings['system.maintenance_message'] ?? ''); ?></textarea>
                            <p class="mt-1 text-xs text-gray-500">Message to display to users during maintenance</p>
                        </div>
                    </div>
                    
                    <div class="mt-6 flex justify-end">
                        <button type="submit" class="px-6 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 font-medium">
                            Save System Settings
                        </button>
                    </div>
                </form>
            </div>

            <!-- Notifications Tab -->
            <div x-show="activeTab === 'notifications'" x-transition x-cloak>
                <div class="mb-4">
                    <h2 class="text-lg font-semibold text-gray-900">Notification Settings</h2>
                    <p class="text-sm text-gray-600 mt-1">Configure email and SMS notification preferences</p>
                </div>
                <form action="<?php echo e(route('admin.settings.notifications')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    
                    <!-- Email Notifications Section -->
                    <div class="mb-6">
                        <h3 class="text-md font-semibold text-gray-900 mb-4">Email Notifications</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="md:col-span-2">
                                <label class="flex items-center">
                                    <input type="checkbox" name="notification_email_enabled" value="1"
                                           <?php echo e(($notificationSettings['notification.email_enabled'] ?? false) ? 'checked' : ''); ?>

                                           class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                    <span class="ml-2 text-sm font-medium text-gray-700">Enable Email Notifications</span>
                                    </label>
                                <p class="ml-6 text-xs text-gray-500 mt-1">Send email notifications for system events</p>
                                </div>
                                    <div>
                                <label for="notification_email_from_address" class="block text-sm font-medium text-gray-700 mb-1">Email From Address</label>
                                <input type="email" name="notification_email_from_address" id="notification_email_from_address" 
                                       value="<?php echo e($notificationSettings['notification.email_from_address'] ?? ''); ?>"
                                       placeholder="noreply@institution.ac.ke"
                                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <p class="mt-1 text-xs text-gray-500">Sender email address for notifications</p>
                                    </div>
                                    <div>
                                <label for="notification_email_from_name" class="block text-sm font-medium text-gray-700 mb-1">Email From Name</label>
                                <input type="text" name="notification_email_from_name" id="notification_email_from_name" 
                                       value="<?php echo e($notificationSettings['notification.email_from_name'] ?? ''); ?>"
                                       placeholder="e-PoE System"
                                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <p class="mt-1 text-xs text-gray-500">Display name for email sender</p>
                            </div>
                            </div>
                        </div>

                    <!-- SMS Notifications Section -->
                    <div class="mb-6">
                        <h3 class="text-md font-semibold text-gray-900 mb-4">SMS Notifications</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="md:col-span-2">
                                <label class="flex items-center">
                                    <input type="checkbox" name="notification_sms_enabled" value="1"
                                           <?php echo e(($notificationSettings['notification.sms_enabled'] ?? false) ? 'checked' : ''); ?>

                                           class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                    <span class="ml-2 text-sm font-medium text-gray-700">Enable SMS Notifications</span>
                                </label>
                                <p class="ml-6 text-xs text-gray-500 mt-1">Send SMS notifications for important events</p>
                            </div>
                        </div>
                        </div>

                    <!-- Notification Preferences Section -->
                    <div class="mb-6">
                        <h3 class="text-md font-semibold text-gray-900 mb-4">Notification Preferences</h3>
                            <div class="space-y-3">
                            <label class="flex items-center">
                                <input type="checkbox" name="notification_submission_notify_trainer" value="1"
                                       <?php echo e(($notificationSettings['notification.submission_notify_trainer'] ?? false) ? 'checked' : ''); ?>

                                       class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                <span class="ml-2 text-sm text-gray-700">Notify trainer when student submits PoE</span>
                                    </label>
                            <label class="flex items-center">
                                <input type="checkbox" name="notification_submission_notify_student" value="1"
                                       <?php echo e(($notificationSettings['notification.submission_notify_student'] ?? false) ? 'checked' : ''); ?>

                                       class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                <span class="ml-2 text-sm text-gray-700">Notify student when submission is received</span>
                                    </label>
                            <label class="flex items-center">
                                <input type="checkbox" name="notification_review_notify_student" value="1"
                                       <?php echo e(($notificationSettings['notification.review_notify_student'] ?? false) ? 'checked' : ''); ?>

                                       class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                <span class="ml-2 text-sm text-gray-700">Notify student when review is completed</span>
                                    </label>
                            <label class="flex items-center">
                                <input type="checkbox" name="notification_approval_notify_student" value="1"
                                       <?php echo e(($notificationSettings['notification.approval_notify_student'] ?? false) ? 'checked' : ''); ?>

                                       class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                <span class="ml-2 text-sm text-gray-700">Notify student when submission is approved</span>
                                    </label>
                        </div>
                    </div>
                    
                    <div class="mt-6 flex justify-end">
                        <button type="submit" class="px-6 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 font-medium">
                            Save Notification Settings
                        </button>
                    </div>
                </form>
            </div>

            <!-- File Upload Tab -->
            <div x-show="activeTab === 'files'" x-transition x-cloak>
                <div class="mb-4">
                    <h2 class="text-lg font-semibold text-gray-900">File Upload Settings</h2>
                    <p class="text-sm text-gray-600 mt-1">Configure file upload limits, allowed types, and storage options</p>
                </div>
                <form action="<?php echo e(route('admin.settings.files')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="file_max_size" class="block text-sm font-medium text-gray-700 mb-1">Max File Size (MB) *</label>
                            <input type="number" name="file_max_size" id="file_max_size" 
                                   value="<?php echo e($fileSettings['file.max_size'] ?? 10); ?>"
                                   min="1" max="10240"
                                   class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" 
                                   required>
                            <p class="mt-1 text-xs text-gray-500">Maximum size for a single file upload (1-10240 MB)</p>
                        </div>
                        <div>
                            <label for="file_max_files_per_submission" class="block text-sm font-medium text-gray-700 mb-1">Max Files Per Submission *</label>
                            <input type="number" name="file_max_files_per_submission" id="file_max_files_per_submission" 
                                   value="<?php echo e($fileSettings['file.max_files_per_submission'] ?? 10); ?>"
                                   min="1" max="100"
                                   class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" 
                                   required>
                            <p class="mt-1 text-xs text-gray-500">Maximum number of files allowed per submission</p>
                        </div>
                        <div class="md:col-span-2">
                            <label for="file_allowed_types" class="block text-sm font-medium text-gray-700 mb-1">Allowed File Types *</label>
                            <input type="text" name="file_allowed_types" id="file_allowed_types" 
                                   value="<?php echo e($fileSettings['file.allowed_types'] ?? 'pdf,doc,docx,jpg,jpeg,png,mp4,mp3'); ?>"
                                   placeholder="pdf,doc,docx,jpg,jpeg,png,mp4,mp3"
                                   class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" 
                                   required>
                            <p class="mt-1 text-xs text-gray-500">Comma-separated list of allowed file extensions (e.g., pdf,doc,docx,jpg,jpeg,png,mp4,mp3)</p>
                        </div>
                        <div>
                            <label for="file_storage_disk" class="block text-sm font-medium text-gray-700 mb-1">Storage Disk *</label>
                            <select name="file_storage_disk" id="file_storage_disk" 
                                    class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" 
                                    required>
                                <option value="public" <?php echo e(($fileSettings['file.storage_disk'] ?? 'public') === 'public' ? 'selected' : ''); ?>>Public (Accessible via URL)</option>
                                <option value="local" <?php echo e(($fileSettings['file.storage_disk'] ?? '') === 'local' ? 'selected' : ''); ?>>Local (Private storage)</option>
                            </select>
                            <p class="mt-1 text-xs text-gray-500">Where uploaded files will be stored</p>
                        </div>
                        <div class="md:col-span-2">
                            <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                                <label class="flex items-start">
                                    <input type="checkbox" name="file_auto_compress_images" value="1"
                                           <?php echo e(($fileSettings['file.auto_compress_images'] ?? false) ? 'checked' : ''); ?>

                                           class="mt-1 rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                    <div class="ml-3">
                                        <span class="text-sm font-medium text-gray-900">Auto Compress Images</span>
                                        <p class="text-xs text-gray-600 mt-1">Automatically compress uploaded images to reduce file size</p>
                                    </div>
                                </label>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mt-6 flex justify-end">
                        <button type="submit" class="px-6 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 font-medium">
                            Save File Settings
                        </button>
                    </div>
                </form>
            </div>

            <!-- Security Tab -->
            <div x-show="activeTab === 'security'" x-transition x-cloak>
                        <div class="mb-4">
                    <h2 class="text-lg font-semibold text-gray-900">Security & Backup</h2>
                    <p class="text-sm text-gray-600 mt-1">Configure security settings, password policies, and manage database backups</p>
                </div>
                
                <!-- Security Settings Form -->
                <form action="<?php echo e(route('admin.settings.security')); ?>" method="POST" class="mb-8">
                    <?php echo csrf_field(); ?>
                    
                    <!-- Session Settings -->
                    <div class="mb-6">
                        <h3 class="text-md font-semibold text-gray-900 mb-4">Session Settings</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="security_session_timeout" class="block text-sm font-medium text-gray-700 mb-1">Session Timeout (minutes) *</label>
                                <input type="number" name="security_session_timeout" id="security_session_timeout" 
                                       value="<?php echo e($securitySettings['security.session_timeout'] ?? 120); ?>"
                                       min="5" max="1440"
                                       class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" 
                                       required>
                                <p class="mt-1 text-xs text-gray-500">User session will expire after this duration (5-1440 minutes)</p>
                            </div>
                        </div>
                    </div>

                    <!-- Password Policy -->
                    <div class="mb-6">
                        <h3 class="text-md font-semibold text-gray-900 mb-4">Password Policy</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="security_password_min_length" class="block text-sm font-medium text-gray-700 mb-1">Minimum Password Length *</label>
                                <input type="number" name="security_password_min_length" id="security_password_min_length" 
                                       value="<?php echo e($securitySettings['security.password_min_length'] ?? 8); ?>"
                                       min="6" max="32"
                                       class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" 
                                       required>
                                <p class="mt-1 text-xs text-gray-500">Minimum number of characters required (6-32)</p>
                            </div>
                            <div class="md:col-span-2">
                                <p class="text-sm font-medium text-gray-700 mb-3">Password Requirements</p>
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                                    <label class="flex items-center">
                                        <input type="checkbox" name="security_password_require_uppercase" value="1"
                                               <?php echo e(($securitySettings['security.password_require_uppercase'] ?? false) ? 'checked' : ''); ?>

                                               class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                        <span class="ml-2 text-sm text-gray-700">Require Uppercase Letters (A-Z)</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="security_password_require_lowercase" value="1"
                                               <?php echo e(($securitySettings['security.password_require_lowercase'] ?? false) ? 'checked' : ''); ?>

                                               class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                        <span class="ml-2 text-sm text-gray-700">Require Lowercase Letters (a-z)</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="security_password_require_numbers" value="1"
                                               <?php echo e(($securitySettings['security.password_require_numbers'] ?? false) ? 'checked' : ''); ?>

                                               class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                        <span class="ml-2 text-sm text-gray-700">Require Numbers (0-9)</span>
                                    </label>
                                    <label class="flex items-center">
                                        <input type="checkbox" name="security_password_require_symbols" value="1"
                                               <?php echo e(($securitySettings['security.password_require_symbols'] ?? false) ? 'checked' : ''); ?>

                                               class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                        <span class="ml-2 text-sm text-gray-700">Require Special Characters (!@#$%^&*)</span>
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Login Security -->
                    <div class="mb-6">
                        <h3 class="text-md font-semibold text-gray-900 mb-4">Login Security</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div>
                                <label for="security_login_attempts_limit" class="block text-sm font-medium text-gray-700 mb-1">Login Attempts Limit *</label>
                                <input type="number" name="security_login_attempts_limit" id="security_login_attempts_limit" 
                                       value="<?php echo e($securitySettings['security.login_attempts_limit'] ?? 5); ?>"
                                       min="3" max="10"
                                       class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" 
                                       required>
                                <p class="mt-1 text-xs text-gray-500">Maximum failed login attempts before lockout (3-10)</p>
                            </div>
                            <div>
                                <label for="security_login_lockout_duration" class="block text-sm font-medium text-gray-700 mb-1">Lockout Duration (minutes) *</label>
                                <input type="number" name="security_login_lockout_duration" id="security_login_lockout_duration" 
                                       value="<?php echo e($securitySettings['security.login_lockout_duration'] ?? 15); ?>"
                                       min="1" max="60"
                                       class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" 
                                       required>
                                <p class="mt-1 text-xs text-gray-500">How long to lock account after failed attempts (1-60 minutes)</p>
                            </div>
                        </div>
                    </div>

                    <!-- Additional Security -->
                    <div class="mb-6">
                        <h3 class="text-md font-semibold text-gray-900 mb-4">Additional Security</h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="md:col-span-2">
                                <label class="flex items-center">
                                    <input type="checkbox" name="security_two_factor_enabled" value="1"
                                           <?php echo e(($securitySettings['security.two_factor_enabled'] ?? false) ? 'checked' : ''); ?>

                                           class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                    <span class="ml-2 text-sm font-medium text-gray-700">Enable Two-Factor Authentication (2FA)</span>
                                </label>
                                <p class="ml-6 text-xs text-gray-500 mt-1">Require additional verification for user logins</p>
                            </div>
                            <div class="md:col-span-2">
                                <label class="flex items-center">
                                    <input type="checkbox" name="security_audit_log_enabled" value="1"
                                           <?php echo e(($securitySettings['security.audit_log_enabled'] ?? true) ? 'checked' : ''); ?>

                                           class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                    <span class="ml-2 text-sm font-medium text-gray-700">Enable Audit Logging</span>
                                </label>
                                <p class="ml-6 text-xs text-gray-500 mt-1">Track all system activities and user actions</p>
                            </div>
                            <div class="md:col-span-2">
                                <label for="security_ip_whitelist" class="block text-sm font-medium text-gray-700 mb-1">IP Whitelist</label>
                                <textarea name="security_ip_whitelist" id="security_ip_whitelist" rows="3"
                                          placeholder="192.168.1.1, 10.0.0.1, 172.16.0.1"
                                          class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"><?php echo e($securitySettings['security.ip_whitelist'] ?? ''); ?></textarea>
                                <p class="mt-1 text-xs text-gray-500">Comma-separated list of allowed IP addresses (leave empty to allow all)</p>
                            </div>
                        </div>
                        </div>

                    <div class="mt-6 flex justify-end">
                        <button type="submit" class="px-6 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 font-medium">
                            Save Security Settings
                        </button>
                    </div>
                </form>

                <!-- Backups Section -->
                <div class="border-t border-gray-200 pt-6">
                    <div class="mb-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-2">Database Backups</h3>
                        <p class="text-sm text-gray-600">Create and manage database backups for disaster recovery</p>
                    </div>

                    <!-- Create Backup -->
                        <div class="mb-6">
                        <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                            <h4 class="text-md font-semibold text-gray-900 mb-2">Create New Backup</h4>
                            <p class="text-sm text-gray-600 mb-4">Create a full database backup that can be restored later</p>
                            <form action="<?php echo e(route('admin.settings.backup.create')); ?>" method="POST" class="inline">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700 font-medium inline-flex items-center">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path>
                                    </svg>
                                    Create Backup
                                </button>
                            </form>
                        </div>
                    </div>

                    <!-- Restore Backup -->
                    <div class="mb-6">
                        <div class="bg-yellow-50 border border-yellow-200 rounded-lg p-4">
                            <h4 class="text-md font-semibold text-gray-900 mb-2">Restore Database</h4>
                            <p class="text-sm text-gray-600 mb-4">
                                <strong class="text-red-600">Warning:</strong> Restoring a backup will replace all current database data. 
                                This action cannot be undone. Make sure to create a backup before restoring.
                            </p>
                            <form action="<?php echo e(route('admin.settings.backup.restore')); ?>" method="POST" enctype="multipart/form-data" onsubmit="return confirmRestore()">
                                <?php echo csrf_field(); ?>
                                <div class="flex items-end space-x-4">
                                    <div class="flex-1">
                                        <label for="backup_file" class="block text-sm font-medium text-gray-700 mb-1">Select Backup File (.sql)</label>
                                        <input type="file" name="backup_file" id="backup_file" 
                                               accept=".sql"
                                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" 
                                               required>
                                        <p class="mt-1 text-xs text-gray-500">Maximum file size: 100MB</p>
                                    </div>
                                    <button type="submit" class="px-4 py-2 bg-yellow-600 text-white rounded-md hover:bg-yellow-700 font-medium inline-flex items-center">
                                        <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-8l-4-4m0 0L8 8m4-4v12"></path>
                                        </svg>
                                        Restore Backup
                                    </button>
                                </div>
                            </form>
                        </div>
                        </div>

                        <?php if(count($backups) > 0): ?>
                        <div class="bg-white border border-gray-200 rounded-lg overflow-hidden">
                                    <table class="min-w-full divide-y divide-gray-200">
                                        <thead class="bg-gray-50">
                                            <tr>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Filename</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Size</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Created</th>
                                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody class="bg-white divide-y divide-gray-200">
                                            <?php $__currentLoopData = $backups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $backup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="hover:bg-gray-50">
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e($backup['filename']); ?></td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                                <?php if($backup['size'] > 1048576): ?>
                                                    <?php echo e(number_format($backup['size'] / 1048576, 2)); ?> MB
                                                <?php else: ?>
                                                    <?php echo e(number_format($backup['size'] / 1024, 2)); ?> KB
                                                <?php endif; ?>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($backup['created_at']); ?></td>
                                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                                        <a href="<?php echo e(route('admin.settings.backup.download', $backup['filename'])); ?>" 
                                                   class="text-indigo-600 hover:text-indigo-900 mr-4">Download</a>
                                                <form action="<?php echo e(route('admin.settings.backup.delete', $backup['filename'])); ?>" method="POST" class="inline">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="text-red-600 hover:text-red-900" 
                                                            onclick="return confirm('Are you sure you want to delete this backup?')">Delete</button>
                                                        </form>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                    <?php else: ?>
                        <div class="bg-gray-50 border border-gray-200 rounded-lg p-8 text-center">
                            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path>
                            </svg>
                            <p class="mt-2 text-sm text-gray-500">No backups available. Create your first backup to get started.</p>
                            </div>
                        <?php endif; ?>
                    </div>

                <!-- Clear Data Section -->
                <div class="border-t border-gray-200 pt-6 mt-6">
                    <div class="bg-red-50 border border-red-200 rounded-lg p-6">
                        <h3 class="text-lg font-semibold text-red-900 mb-2">Danger Zone</h3>
                        <p class="text-sm text-red-700 mb-4">This action will permanently delete all data from the system. This cannot be undone.</p>
                        <form action="<?php echo e(route('admin.settings.clear-data')); ?>" method="POST" onsubmit="return confirmClearData()">
                            <?php echo csrf_field(); ?>
                        <div class="mb-4">
                                <label for="confirmation" class="block text-sm font-medium text-red-900 mb-2">
                                    Type "DELETE ALL DATA" to confirm:
                                        </label>
                                        <input type="text" name="confirmation" id="confirmation" 
                                       class="w-full rounded-md border-red-300 shadow-sm focus:border-red-500 focus:ring-red-500"
                                               placeholder="DELETE ALL DATA"
                                               required>
                                    </div>
                            <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-md hover:bg-red-700 font-medium">
                                        Clear All Data
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    <!-- Hidden forms for destructive actions (avoid nested forms) -->
    <form id="delete_institution_logo_form" action="<?php echo e(route('admin.settings.logo.delete')); ?>" method="POST" class="hidden">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
    </form>

    <form id="delete_system_favicon_form" action="<?php echo e(route('admin.settings.favicon.delete')); ?>" method="POST" class="hidden">
        <?php echo csrf_field(); ?>
        <?php echo method_field('DELETE'); ?>
    </form>
        </div>

<script>
    function confirmClearData() {
        const confirmation = document.getElementById('confirmation').value;
        if (confirmation !== 'DELETE ALL DATA') {
            alert('Please type "DELETE ALL DATA" exactly to confirm.');
            return false;
        }
        return confirm('WARNING: This will permanently delete ALL data from the system. This action cannot be undone. Are you absolutely sure?');
    }

    function confirmRestore() {
        const fileInput = document.getElementById('backup_file');
        if (!fileInput.files || !fileInput.files[0]) {
            alert('Please select a backup file to restore.');
            return false;
        }
        
        const fileName = fileInput.files[0].name;
        return confirm(
            'WARNING: Restoring this backup will REPLACE ALL current database data.\n\n' +
            'File: ' + fileName + '\n\n' +
            'This action cannot be undone. Are you absolutely sure you want to proceed?\n\n' +
            'It is recommended to create a backup before restoring.'
        );
    }
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/admin/settings/index.blade.php ENDPATH**/ ?>