

<?php $__env->startSection('title', 'Send Notifications'); ?>
<?php $__env->startSection('page-title', 'Send Notifications'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <div>
            <h1 class="text-2xl font-bold text-gray-900 mb-2">Send Notifications</h1>
            <p class="text-gray-600">Send notifications to trainers and students in your department</p>
        </div>
    </div>

    <!-- Tabs -->
    <div class="bg-white rounded-xl shadow-md">
        <div class="border-b border-gray-200">
            <nav class="flex -mb-px" aria-label="Tabs">
                <button onclick="showTab('individual')" id="tab-individual" class="tab-button active px-6 py-3 text-sm font-medium text-purple-600 border-b-2 border-purple-600">
                    Individual
                </button>
                <button onclick="showTab('department')" id="tab-department" class="tab-button px-6 py-3 text-sm font-medium text-gray-500 hover:text-gray-700 border-b-2 border-transparent hover:border-gray-300">
                    Department
                </button>
                <button onclick="showTab('class')" id="tab-class" class="tab-button px-6 py-3 text-sm font-medium text-gray-500 hover:text-gray-700 border-b-2 border-transparent hover:border-gray-300">
                    Class
                </button>
            </nav>
        </div>

        <!-- Individual Notification -->
        <div id="panel-individual" class="tab-panel p-6">
            <form action="<?php echo e(route('hod.notifications.individual')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="space-y-4">
                    <div>
                        <label for="recipient_id" class="block text-sm font-medium text-gray-700 mb-1">Recipient <span class="text-red-500">*</span></label>
                        <select name="recipient_id" id="recipient_id" required
                                class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                            <option value="">Select Recipient</option>
                            <optgroup label="Trainers">
                                <?php $__currentLoopData = $trainers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trainer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($trainer->id); ?>"><?php echo e($trainer->name); ?> (<?php echo e($trainer->email); ?>)</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </optgroup>
                            <optgroup label="Students">
                                <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($student->id); ?>"><?php echo e($student->name); ?> (<?php echo e($student->email); ?>)</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </optgroup>
                        </select>
                    </div>
                    <div>
                        <label for="title_individual" class="block text-sm font-medium text-gray-700 mb-1">Title <span class="text-red-500">*</span></label>
                        <input type="text" name="title" id="title_individual" required
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500"
                               placeholder="Notification title">
                    </div>
                    <div>
                        <label for="message_individual" class="block text-sm font-medium text-gray-700 mb-1">Message <span class="text-red-500">*</span></label>
                        <textarea name="message" id="message_individual" rows="5" required
                                  class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500"
                                  placeholder="Enter your message..."></textarea>
                    </div>
                    <div class="flex justify-end">
                        <button type="submit" class="bg-purple-600 text-white px-6 py-2 rounded-lg hover:bg-purple-700 transition-colors font-medium">
                            Send Notification
                        </button>
                    </div>
                </div>
            </form>
        </div>

        <!-- Department Notification -->
        <div id="panel-department" class="tab-panel hidden p-6">
            <form action="<?php echo e(route('hod.notifications.department')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Recipients <span class="text-red-500">*</span></label>
                        <div class="space-y-2">
                            <label class="flex items-center">
                                <input type="checkbox" name="recipient_roles[]" value="trainer" class="rounded border-gray-300 text-purple-600 focus:ring-purple-500">
                                <span class="ml-2 text-sm text-gray-700">All Trainers</span>
                            </label>
                            <label class="flex items-center">
                                <input type="checkbox" name="recipient_roles[]" value="student" class="rounded border-gray-300 text-purple-600 focus:ring-purple-500">
                                <span class="ml-2 text-sm text-gray-700">All Students</span>
                            </label>
                        </div>
                    </div>
                    <div>
                        <label for="title_department" class="block text-sm font-medium text-gray-700 mb-1">Title <span class="text-red-500">*</span></label>
                        <input type="text" name="title" id="title_department" required
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500"
                               placeholder="Notification title">
                    </div>
                    <div>
                        <label for="message_department" class="block text-sm font-medium text-gray-700 mb-1">Message <span class="text-red-500">*</span></label>
                        <textarea name="message" id="message_department" rows="5" required
                                  class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500"
                                  placeholder="Enter your message..."></textarea>
                    </div>
                    <div class="flex justify-end">
                        <button type="submit" class="bg-purple-600 text-white px-6 py-2 rounded-lg hover:bg-purple-700 transition-colors font-medium">
                            Send to Department
                        </button>
                    </div>
                </div>
            </form>
        </div>

        <!-- Class Notification -->
        <div id="panel-class" class="tab-panel hidden p-6">
            <form action="<?php echo e(route('hod.notifications.class')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="space-y-4">
                    <div>
                        <label for="class_id" class="block text-sm font-medium text-gray-700 mb-1">Class <span class="text-red-500">*</span></label>
                        <select name="class_id" id="class_id" required
                                class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                            <option value="">Select Class</option>
                            <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($class->id); ?>"><?php echo e($class->name); ?> (<?php echo e($class->code); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Recipients <span class="text-red-500">*</span></label>
                        <div class="space-y-2">
                            <label class="flex items-center">
                                <input type="checkbox" name="recipient_roles[]" value="trainer" class="rounded border-gray-300 text-purple-600 focus:ring-purple-500">
                                <span class="ml-2 text-sm text-gray-700">Trainers in this class</span>
                            </label>
                            <label class="flex items-center">
                                <input type="checkbox" name="recipient_roles[]" value="student" class="rounded border-gray-300 text-purple-600 focus:ring-purple-500">
                                <span class="ml-2 text-sm text-gray-700">Students in this class</span>
                            </label>
                        </div>
                    </div>
                    <div>
                        <label for="title_class" class="block text-sm font-medium text-gray-700 mb-1">Title <span class="text-red-500">*</span></label>
                        <input type="text" name="title" id="title_class" required
                               class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500"
                               placeholder="Notification title">
                    </div>
                    <div>
                        <label for="message_class" class="block text-sm font-medium text-gray-700 mb-1">Message <span class="text-red-500">*</span></label>
                        <textarea name="message" id="message_class" rows="5" required
                                  class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500"
                                  placeholder="Enter your message..."></textarea>
                    </div>
                    <div class="flex justify-end">
                        <button type="submit" class="bg-purple-600 text-white px-6 py-2 rounded-lg hover:bg-purple-700 transition-colors font-medium">
                            Send to Class
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function showTab(tabName) {
    // Hide all panels
    document.querySelectorAll('.tab-panel').forEach(panel => {
        panel.classList.add('hidden');
    });
    
    // Remove active class from all tabs
    document.querySelectorAll('.tab-button').forEach(button => {
        button.classList.remove('active', 'text-purple-600', 'border-purple-600');
        button.classList.add('text-gray-500', 'border-transparent');
    });
    
    // Show selected panel
    document.getElementById('panel-' + tabName).classList.remove('hidden');
    
    // Add active class to selected tab
    const activeTab = document.getElementById('tab-' + tabName);
    activeTab.classList.add('active', 'text-purple-600', 'border-purple-600');
    activeTab.classList.remove('text-gray-500', 'border-transparent');
}
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.hod', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/hod/notifications/index.blade.php ENDPATH**/ ?>