<?php $__env->startSection('title', 'Notification Details'); ?>
<?php $__env->startSection('page-title', 'Notification Details'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-6">
        <a href="<?php echo e(route('student.messages.index')); ?>" class="text-indigo-600 hover:text-indigo-900 flex items-center">
            <svg class="h-5 w-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
            Back to Messages
        </a>
    </div>

    <div class="bg-white shadow-sm rounded-lg overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
            <div class="flex items-center justify-between">
                <h3 class="text-lg font-semibold text-gray-900">
                    <?php echo e($notification->data['title'] ?? 'Notification'); ?>

                </h3>
                <?php if($notification->read_at): ?>
                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                        Read
                    </span>
                <?php else: ?>
                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">
                        Unread
                    </span>
                <?php endif; ?>
            </div>
        </div>
        <div class="px-6 py-4">
            <?php if($sender): ?>
                <div class="mb-4">
                    <p class="text-sm text-gray-500 mb-1">From</p>
                    <div class="flex items-center gap-2">
                        <p class="text-sm font-medium text-gray-900"><?php echo e($sender->name); ?></p>
                        <?php if($sender->role): ?>
                            <span class="px-2 py-1 text-xs font-medium rounded bg-gray-100 text-gray-700">
                                <?php echo e(ucfirst(str_replace('_', ' ', $sender->role))); ?>

                            </span>
                        <?php endif; ?>
                        <?php if($sender->department): ?>
                            <span class="text-xs text-gray-500">(<?php echo e($sender->department->name); ?>)</span>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
            <div class="mb-4">
                <p class="text-sm text-gray-500 mb-1">Received</p>
                <p class="text-sm text-gray-900"><?php echo e($notification->created_at->format('F d, Y h:i A')); ?></p>
            </div>
            <div class="mb-4">
                <p class="text-sm text-gray-500 mb-1">Type</p>
                <p class="text-sm text-gray-900"><?php echo e($notification->type); ?></p>
            </div>
            <div class="pt-4 border-t border-gray-200">
                <p class="text-sm text-gray-500 mb-2">Message</p>
                <div class="bg-gray-50 p-4 rounded-lg">
                    <p class="text-sm text-gray-900 whitespace-pre-wrap">
                        <?php echo e($notification->data['message'] ?? $notification->data['body'] ?? 'No message content available.'); ?>

                    </p>
                </div>
            </div>
            <?php if(isset($notification->data['action_url'])): ?>
                <div class="mt-4">
                    <a href="<?php echo e($notification->data['action_url']); ?>" class="inline-flex items-center px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">
                        View Related Item
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.student', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/student/messages/show-notification.blade.php ENDPATH**/ ?>