<?php $__env->startSection('title', 'Practical Evidence - ' . $unit->name); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-6">
        <a href="<?php echo e(route('trainer.units.show', $unit)); ?>" class="text-indigo-600 hover:text-indigo-900 flex items-center">
            <svg class="h-5 w-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
            Back to Unit
        </a>
    </div>

    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-900">Practical Evidence</h1>
        <p class="mt-1 text-sm text-gray-600"><?php echo e($unit->name); ?> <?php if($unit->code): ?>(<?php echo e($unit->code); ?>)<?php endif; ?></p>
    </div>

    <!-- Statistics -->
    <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
        <div class="bg-white rounded-lg shadow p-4">
            <p class="text-sm text-gray-600">Total Evidence</p>
            <p class="text-2xl font-bold text-gray-900"><?php echo e($stats['total']); ?></p>
        </div>
        <div class="bg-white rounded-lg shadow p-4">
            <p class="text-sm text-gray-600">Submitted</p>
            <p class="text-2xl font-bold text-blue-600"><?php echo e($stats['submitted']); ?></p>
        </div>
        <div class="bg-white rounded-lg shadow p-4">
            <p class="text-sm text-gray-600">Reviewed</p>
            <p class="text-2xl font-bold text-yellow-600"><?php echo e($stats['reviewed']); ?></p>
        </div>
        <div class="bg-white rounded-lg shadow p-4">
            <p class="text-sm text-gray-600">Accepted</p>
            <p class="text-2xl font-bold text-green-600"><?php echo e($stats['accepted']); ?></p>
        </div>
    </div>

    <!-- Evidence by Student -->
    <div class="bg-white rounded-lg shadow-sm overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
            <h3 class="text-lg font-semibold text-gray-900">Evidence by Student</h3>
        </div>
        <div class="divide-y divide-gray-200">
            <?php $__empty_1 = true; $__currentLoopData = $evidences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $studentId => $studentEvidences): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php
                    $student = $studentEvidences->first()->student;
                    $evidenceCount = $studentEvidences->count();
                    $statusCounts = $studentEvidences->groupBy('status')->map->count();
                ?>
                <div class="p-6 hover:bg-gray-50">
                    <div class="flex items-center justify-between">
                        <div class="flex-1">
                            <h4 class="text-lg font-medium text-gray-900"><?php echo e($student->name); ?></h4>
                            <p class="text-sm text-gray-500"><?php echo e($student->email); ?></p>
                            <div class="mt-2 flex items-center gap-4 text-sm text-gray-600">
                                <span><?php echo e($evidenceCount); ?> file(s)</span>
                                <?php if($statusCounts->has('submitted')): ?>
                                    <span class="text-blue-600"><?php echo e($statusCounts['submitted']); ?> submitted</span>
                                <?php endif; ?>
                                <?php if($statusCounts->has('reviewed')): ?>
                                    <span class="text-yellow-600"><?php echo e($statusCounts['reviewed']); ?> reviewed</span>
                                <?php endif; ?>
                                <?php if($statusCounts->has('accepted')): ?>
                                    <span class="text-green-600"><?php echo e($statusCounts['accepted']); ?> accepted</span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <a href="<?php echo e(route('trainer.practical-evidence.show', $studentEvidences->first())); ?>" class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 text-sm font-medium">
                            View Evidence
                        </a>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="p-12 text-center">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    <h3 class="mt-2 text-sm font-medium text-gray-900">No evidence uploaded</h3>
                    <p class="mt-1 text-sm text-gray-500">Students haven't uploaded any practical evidence yet.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.trainer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/trainer/practical-evidence/index.blade.php ENDPATH**/ ?>