<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps(['active' => '', 'sidebar-open' => 'sidebarOpen']) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps(['active' => '', 'sidebar-open' => 'sidebarOpen']); ?>
<?php foreach (array_filter((['active' => '', 'sidebar-open' => 'sidebarOpen']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<!-- Mobile sidebar -->
<div x-show="<?php echo e($sidebarOpen); ?>" 
     x-cloak
     x-transition:enter="transition ease-out duration-300 transform"
     x-transition:enter-start="-translate-x-full"
     x-transition:enter-end="translate-x-0"
     x-transition:leave="transition ease-in duration-300 transform"
     x-transition:leave-start="translate-x-0"
     x-transition:leave-end="-translate-x-full"
     class="fixed inset-y-0 left-0 z-50 w-64 max-w-[85vw] md:hidden"
     style="display: none;">
    <div class="flex flex-col h-full bg-blue-800 border-r border-blue-900">
        <div class="flex items-center justify-between px-4 py-4 border-b border-blue-700">
            <a href="<?php echo e(route('trainer.dashboard')); ?>" class="text-xl font-bold text-white">EPOE System</a>
            <button @click="<?php echo e($sidebarOpen); ?> = false" class="text-blue-200 hover:text-white">
                <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        <div class="flex-1 overflow-y-auto pt-5 pb-4">
            <nav class="px-2 space-y-1">
                <!-- Dashboard -->
                <a href="<?php echo e(route('trainer.dashboard')); ?>" 
                   @click="<?php echo e($sidebarOpen); ?> = false"
                   class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('trainer.dashboard') ? 'bg-blue-900 text-white' : 'text-blue-100 hover:bg-blue-700 hover:text-white'); ?>">
                    <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                    </svg>
                    Dashboard
                </a>

                <!-- My Units -->
                <a href="<?php echo e(route('trainer.units.index')); ?>" 
                   @click="<?php echo e($sidebarOpen); ?> = false"
                   class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('trainer.units.*') ? 'bg-blue-900 text-white' : 'text-blue-100 hover:bg-blue-700 hover:text-white'); ?>">
                    <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    My Units
                </a>

                <!-- Portfolio Evidence -->
                <a href="<?php echo e(route('trainer.portfolio-evidence.index')); ?>" 
                   @click="<?php echo e($sidebarOpen); ?> = false"
                   class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('trainer.portfolio-evidence.*') ? 'bg-blue-900 text-white' : 'text-blue-100 hover:bg-blue-700 hover:text-white'); ?>">
                    <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    Portfolio Evidence
                </a>

                <!-- All Submissions -->
                <a href="<?php echo e(route('trainer.submissions.index')); ?>" 
                   @click="<?php echo e($sidebarOpen); ?> = false"
                   class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('trainer.submissions.*') ? 'bg-blue-900 text-white' : 'text-blue-100 hover:bg-blue-700 hover:text-white'); ?>">
                    <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path>
                    </svg>
                    Submissions
                </a>

                <!-- Marks Management -->
                <a href="<?php echo e(route('trainer.marks.index')); ?>" 
                   @click="<?php echo e($sidebarOpen); ?> = false"
                   class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('trainer.marks.*') ? 'bg-blue-900 text-white' : 'text-blue-100 hover:bg-blue-700 hover:text-white'); ?>">
                    <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                    </svg>
                    Marks Management
                </a>

                <!-- Messages -->
                <a href="<?php echo e(route('trainer.messages.index')); ?>" 
                   @click="<?php echo e($sidebarOpen); ?> = false"
                   class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('trainer.messages.*') ? 'bg-blue-900 text-white' : 'text-blue-100 hover:bg-blue-700 hover:text-white'); ?>">
                    <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                    </svg>
                    Messages
                    <?php
                        $unreadCount = auth()->user()->unreadNotifications()->count() + 
                                     \App\Models\Message::where('receiver_id', auth()->id())
                                         ->where('is_read', false)
                                         ->count();
                    ?>
                    <?php if($unreadCount > 0): ?>
                        <span class="ml-auto bg-red-600 text-white text-xs font-semibold px-2 py-1 rounded-full"><?php echo e($unreadCount); ?></span>
                    <?php endif; ?>
                </a>

                <!-- Send Notifications -->
                <a href="<?php echo e(route('trainer.notifications.index')); ?>" 
                   @click="<?php echo e($sidebarOpen); ?> = false"
                   class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('trainer.notifications.*') ? 'bg-blue-900 text-white' : 'text-blue-100 hover:bg-blue-700 hover:text-white'); ?>">
                    <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                    </svg>
                    Send Notifications
                </a>

                <!-- Profile -->
                <a href="<?php echo e(route('trainer.profile.show')); ?>" 
                   @click="<?php echo e($sidebarOpen); ?> = false"
                   class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('trainer.profile.*') ? 'bg-blue-900 text-white' : 'text-blue-100 hover:bg-blue-700 hover:text-white'); ?>">
                    <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                    </svg>
                    Profile
                </a>
            </nav>
        </div>
        <div class="flex-shrink-0 flex border-t border-blue-700 p-4">
            <div class="flex-shrink-0 w-full group block">
                <div class="flex items-center">
                    <div class="h-10 w-10 rounded-full bg-blue-700 flex items-center justify-center">
                        <span class="text-white font-semibold text-sm"><?php echo e(substr(auth()->user()->name, 0, 1)); ?></span>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium text-white"><?php echo e(auth()->user()->name); ?></p>
                        <p class="text-xs text-blue-200">Trainer</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Desktop sidebar -->
<div class="hidden md:flex md:flex-shrink-0">
    <div class="flex flex-col w-64">
        <div class="flex flex-col flex-grow pt-5 overflow-y-auto bg-blue-800 border-r border-blue-900">
            <div class="flex items-center flex-shrink-0 px-4 mb-8">
                <a href="<?php echo e(route('trainer.dashboard')); ?>" class="text-2xl font-bold text-white hover:text-blue-200">EPOE System</a>
            </div>
            <div class="mt-5 flex-1 flex flex-col">
                <nav class="flex-1 px-2 space-y-1">
                    <!-- Dashboard -->
                    <a href="<?php echo e(route('trainer.dashboard')); ?>" 
                       class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('trainer.dashboard') ? 'bg-blue-900 text-white' : 'text-blue-100 hover:bg-blue-700 hover:text-white'); ?>">
                        <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"></path>
                        </svg>
                        Dashboard
                    </a>

                    <!-- My Units -->
                    <a href="<?php echo e(route('trainer.units.index')); ?>" 
                       class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('trainer.units.*') ? 'bg-blue-900 text-white' : 'text-blue-100 hover:bg-blue-700 hover:text-white'); ?>">
                        <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        My Units
                    </a>


                    <!-- Portfolio Evidence -->
                    <a href="<?php echo e(route('trainer.portfolio-evidence.index')); ?>" 
                       class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('trainer.portfolio-evidence.*') ? 'bg-blue-900 text-white' : 'text-blue-100 hover:bg-blue-700 hover:text-white'); ?>">
                        <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        Portfolio Evidence
                    </a>

                    <!-- All Submissions -->
                    <a href="<?php echo e(route('trainer.submissions.index')); ?>" 
                       class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('trainer.submissions.*') ? 'bg-blue-900 text-white' : 'text-blue-100 hover:bg-blue-700 hover:text-white'); ?>">
                        <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path>
                        </svg>
                        Submissions
                    </a>

                    <!-- Marks Management -->
                    <a href="<?php echo e(route('trainer.marks.index')); ?>" 
                       class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('trainer.marks.*') ? 'bg-blue-900 text-white' : 'text-blue-100 hover:bg-blue-700 hover:text-white'); ?>">
                        <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                        </svg>
                        Marks Management
                    </a>

                    <!-- Messages -->
                    <a href="<?php echo e(route('trainer.messages.index')); ?>" 
                       class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('trainer.messages.*') ? 'bg-blue-900 text-white' : 'text-blue-100 hover:bg-blue-700 hover:text-white'); ?>">
                        <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                        </svg>
                        Messages
                        <?php
                            $unreadCount = auth()->user()->unreadNotifications()->count() + 
                                         \App\Models\Message::where('receiver_id', auth()->id())
                                             ->where('is_read', false)
                                             ->count();
                        ?>
                        <?php if($unreadCount > 0): ?>
                            <span class="ml-auto bg-red-600 text-white text-xs font-semibold px-2 py-1 rounded-full"><?php echo e($unreadCount); ?></span>
                        <?php endif; ?>
                    </a>

                    <!-- Send Notifications -->
                    <a href="<?php echo e(route('trainer.notifications.index')); ?>" 
                       class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('trainer.notifications.*') ? 'bg-blue-900 text-white' : 'text-blue-100 hover:bg-blue-700 hover:text-white'); ?>">
                        <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                        </svg>
                        Send Notifications
                    </a>

                    <!-- Profile -->
                    <a href="<?php echo e(route('trainer.profile.show')); ?>" 
                       class="group flex items-center px-3 py-2 text-sm font-medium rounded-md <?php echo e(request()->routeIs('trainer.profile.*') ? 'bg-blue-900 text-white' : 'text-blue-100 hover:bg-blue-700 hover:text-white'); ?>">
                        <svg class="mr-3 h-5 w-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                        Profile
                    </a>
                </nav>

                <!-- Bottom Section -->
                <div class="flex-shrink-0 flex border-t border-blue-700 p-4">
                    <div class="flex-shrink-0 w-full group block">
                        <div class="flex items-center">
                            <div class="h-10 w-10 rounded-full bg-blue-700 flex items-center justify-center">
                                <span class="text-white font-semibold text-sm"><?php echo e(substr(auth()->user()->name, 0, 1)); ?></span>
                            </div>
                            <div class="ml-3">
                                <p class="text-sm font-medium text-white"><?php echo e(auth()->user()->name); ?></p>
                                <p class="text-xs text-blue-200">Trainer</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php /**PATH D:\poe\resources\views/components/trainer-sidebar.blade.php ENDPATH**/ ?>