

<?php $__env->startSection('title', 'My Units'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl font-bold text-gray-900">My Units</h1>
        <p class="mt-1 text-sm text-gray-600">View your assigned units and create assignments</p>
    </div>

    <?php if($activeTerm): ?>
        <div class="mb-4 sm:mb-6 p-4 bg-blue-50 border border-blue-200 rounded-lg">
            <p class="text-sm text-blue-800"><strong>Active Term:</strong> <?php echo e($activeTerm->name); ?></p>
        </div>
    <?php endif; ?>

    <?php if($units->count() > 0): ?>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4 sm:gap-6">
            <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="bg-white rounded-lg shadow hover:shadow-lg transition-shadow">
                    <div class="p-4 sm:p-6">
                        <div class="flex items-start justify-between mb-4">
                            <div class="flex-1">
                                <a href="<?php echo e(route('trainer.units.show', ['unit' => $unit->id, 'class_id' => $unit->allocation_class_id ?? null])); ?>" class="block">
                                    <h3 class="text-lg font-semibold text-gray-900 hover:text-blue-600"><?php echo e($unit->name); ?></h3>
                                </a>
                                <?php if($unit->code): ?>
                                    <p class="text-sm text-gray-500 mt-1"><?php echo e($unit->code); ?></p>
                                <?php endif; ?>
                                <?php if($unit->department): ?>
                                    <p class="text-sm text-gray-500"><?php echo e($unit->department->name); ?></p>
                                <?php endif; ?>
                            </div>
                                <a href="<?php echo e(route('trainer.units.show', ['unit' => $unit->id, 'class_id' => $unit->allocation_class_id ?? null])); ?>" class="p-2 -m-2 text-blue-600 hover:text-blue-800 touch-manipulation rounded-lg">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                </svg>
                            </a>
                        </div>
                        
                        <div class="space-y-2 text-sm">
                            <div class="flex items-center text-gray-600">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                                </svg>
                                <?php echo e($unit->students_count); ?> Students
                            </div>
                            <div class="flex items-center text-gray-600">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                                <?php echo e($unit->submissions_count); ?> Submissions
                            </div>
                            <div class="flex items-center text-gray-600">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                                </svg>
                                <?php echo e($unit->assignments_count); ?> Assignments
                            </div>
                            <?php if($unit->pending_reviews_count > 0): ?>
                                <div class="flex items-center text-red-600 font-medium">
                                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    <?php echo e($unit->pending_reviews_count); ?> Pending Reviews
                                </div>
                            <?php endif; ?>
                        </div>

                        <?php if($unit->assigned_classes->count() > 0): ?>
                            <div class="mt-4 pt-4 border-t">
                                <p class="text-xs font-medium text-gray-700 mb-1">Class:</p>
                                <?php $class = $unit->assigned_classes->first(); ?>
                                <?php if($class): ?>
                                    <span class="px-2 py-1 text-xs bg-purple-100 text-purple-800 rounded">
                                        <?php echo e($class->name); ?><?php if($class->code): ?> (<?php echo e($class->code); ?>)<?php endif; ?>
                                    </span>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    <?php else: ?>
        <div class="bg-white rounded-lg shadow p-8 text-center">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900">No units assigned</h3>
            <p class="mt-1 text-sm text-gray-500">You haven't been assigned to any units yet.</p>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.trainer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/trainer/units/index.blade.php ENDPATH**/ ?>