<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Practical Marks Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header h1 {
            margin: 0;
            font-size: 18px;
        }
        .info-table {
            width: 100%;
            margin-bottom: 20px;
            border-collapse: collapse;
        }
        .info-table td {
            padding: 5px;
            border: 1px solid #ddd;
        }
        .info-table td:first-child {
            font-weight: bold;
            width: 30%;
        }
        .marks-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .marks-table th,
        .marks-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .marks-table th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .marks-table td {
            text-align: center;
        }
        .footer {
            margin-top: 30px;
            text-align: right;
            font-size: 10px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>PRACTICAL ASSESSMENT MARKS REPORT</h1>
    </div>

    <table class="info-table">
        <tr>
            <td>Assignment:</td>
            <td><?php echo e($assignment->title); ?></td>
        </tr>
        <tr>
            <td>Unit:</td>
            <td><?php echo e($unit->name); ?> (<?php echo e($unit->code); ?>)</td>
        </tr>
        <tr>
            <td>Trainer:</td>
            <td><?php echo e($trainer->name); ?></td>
        </tr>
        <tr>
            <td>Date of Assessment:</td>
            <td><?php echo e($assignment->due_date ? $assignment->due_date->format('d M Y') : now()->format('d M Y')); ?></td>
        </tr>
        <tr>
            <td>Total Marks:</td>
            <td><?php echo e(number_format($assignment->total_marks, 2)); ?></td>
        </tr>
        <tr>
            <td>Report Generated:</td>
            <td><?php echo e(now()->format('d M Y H:i')); ?></td>
        </tr>
    </table>

    <table class="marks-table">
        <thead>
            <tr>
                <th>#</th>
                <th>Student Name</th>
                <th>Admission Number</th>
                <th>Class</th>
                <th>Status</th>
                <th>Marks Obtained</th>
                <th>Total Marks</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $compiledMarks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($index + 1); ?></td>
                    <td><?php echo e($item['student']->name); ?></td>
                    <td><?php echo e($item['student']->admission_number ?? 'N/A'); ?></td>
                    <td><?php echo e($item['class']->name ?? 'N/A'); ?></td>
                    <td><?php echo e(ucfirst(str_replace('_', ' ', $item['marking_status']))); ?></td>
                    <td><?php echo e(number_format($item['marks'], 2)); ?></td>
                    <td><?php echo e(number_format($assignment->total_marks, 2)); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="footer">
        <p>Generated by: <?php echo e($trainer->name); ?></p>
        <p>Date: <?php echo e(now()->format('d M Y H:i')); ?></p>
    </div>
</body>
</html>

<?php /**PATH D:\poe\resources\views/trainer/practical-marks/export-pdf.blade.php ENDPATH**/ ?>