<?php $__env->startSection('title', $assignment->title); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-4 sm:mb-6">
        <div class="flex flex-col sm:flex-row sm:items-start sm:justify-between gap-3">
            <div class="flex-1 min-w-0">
                <div class="flex items-center gap-2 sm:gap-3 mb-2">
                    <a href="<?php echo e(route('student.units.show', $assignment->unit)); ?>" class="text-green-600 hover:text-green-700 flex-shrink-0">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                        </svg>
                    </a>
                    <h1 class="text-xl sm:text-2xl font-bold text-gray-900 truncate"><?php echo e($assignment->title); ?></h1>
                </div>
                <p class="text-sm text-gray-600 truncate"><?php echo e($assignment->unit->name); ?></p>
                <?php if($assignment->unit->code): ?>
                    <p class="text-xs text-gray-500 mt-1">Code: <?php echo e($assignment->unit->code); ?></p>
                <?php endif; ?>
            </div>
            <div class="flex items-center gap-2 flex-wrap">
                <span class="px-2.5 sm:px-3 py-1.5 text-xs sm:text-sm font-medium rounded-full <?php echo e($assignment->getStatusBadgeClasses()); ?>">
                    <?php echo e($assignment->getTypeLabel()); ?>

                </span>
                <?php if($assignment->isOverdue()): ?>
                    <span class="px-2.5 sm:px-3 py-1.5 text-xs sm:text-sm font-medium rounded-full bg-red-100 text-red-800 flex items-center gap-1">
                        <svg class="w-3 h-3 sm:w-4 sm:h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                        </svg>
                        Overdue
                    </span>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-4 sm:gap-6">
        <!-- Assignment Details -->
        <div class="lg:col-span-2 space-y-6">
            <!-- Description -->
            <?php if($assignment->description): ?>
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                    <div class="flex items-center gap-2 mb-4">
                        <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        <h2 class="text-lg font-semibold text-gray-900">Description</h2>
                    </div>
                    <div class="prose max-w-none">
                        <p class="text-gray-700 whitespace-pre-wrap leading-relaxed"><?php echo e($assignment->description); ?></p>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Instructions -->
            <?php if($assignment->instructions): ?>
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                    <div class="flex items-center gap-2 mb-4">
                        <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"></path>
                        </svg>
                        <h2 class="text-lg font-semibold text-gray-900">Instructions</h2>
                    </div>
                    <div class="prose max-w-none">
                        <p class="text-gray-700 whitespace-pre-wrap leading-relaxed"><?php echo e($assignment->instructions); ?></p>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Attachments (for non-practical assignments) -->
            <?php if($assignment->type !== 'practical' && $assignment->attachments && count($assignment->attachments) > 0): ?>
                <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                    <div class="flex items-center gap-2 mb-4">
                        <svg class="w-5 h-5 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path>
                        </svg>
                        <h2 class="text-lg font-semibold text-gray-900">Attachments</h2>
                        <span class="ml-auto px-2 py-1 text-xs font-medium bg-gray-100 text-gray-700 rounded-full"><?php echo e(count($assignment->attachments)); ?> <?php echo e(Str::plural('file', count($assignment->attachments))); ?></span>
                    </div>
                    <div class="space-y-2">
                            <?php $__currentLoopData = $assignment->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('student.assignments.attachment.download', ['assignment' => $assignment->id, 'index' => $index])); ?>"
                               class="flex items-center justify-between p-4 border-2 border-gray-200 rounded-lg hover:border-green-300 hover:bg-green-50 transition-all group">
                                <div class="flex items-center flex-1 min-w-0">
                                    <div class="flex-shrink-0 mr-3">
                                        <svg class="w-6 h-6 text-gray-400 group-hover:text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                        </svg>
                                    </div>
                                    <div class="flex-1 min-w-0">
                                        <p class="text-sm font-medium text-gray-900 truncate"><?php echo e(basename($attachment)); ?></p>
                                        <p class="text-xs text-gray-500 mt-0.5">Click to download</p>
                                    </div>
                                </div>
                                <svg class="w-5 h-5 text-gray-400 group-hover:text-green-600 ml-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path>
                                </svg>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Practical Tools -->
            <?php if($assignment->type === 'practical'): ?>
                <!-- Candidate Tool -->
                <?php if($assignment->candidate_tool && count($assignment->candidate_tool) > 0 && $assignment->canStudentViewCandidateTool()): ?>
                    <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6">
                        <div class="flex items-center gap-2 mb-4">
                            <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                            <h2 class="text-lg font-semibold text-gray-900">Candidate Tool</h2>
                            <span class="ml-auto px-2 py-1 text-xs font-medium bg-blue-100 text-blue-700 rounded-full">Questions & Procedures</span>
                        </div>
                        <p class="text-sm text-gray-600 mb-4">Download the questions and procedures for this practical assessment.</p>
                        <div class="space-y-2">
                            <?php $__currentLoopData = $assignment->candidate_tool; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $tool): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e(route('student.assignments.tool.download', ['assignment' => $assignment->id, 'toolType' => 'candidate', 'index' => $index])); ?>" 
                                   class="flex items-center justify-between p-4 border-2 border-blue-200 rounded-lg hover:border-blue-400 hover:bg-blue-50 transition-all group">
                                    <div class="flex items-center flex-1 min-w-0">
                                        <div class="flex-shrink-0 mr-3">
                                            <svg class="w-6 h-6 text-blue-400 group-hover:text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                            </svg>
                                        </div>
                                        <div class="flex-1 min-w-0">
                                            <p class="text-sm font-medium text-gray-900 truncate"><?php echo e(basename($tool)); ?></p>
                                            <p class="text-xs text-blue-600 mt-0.5">Candidate Tool</p>
                                        </div>
                                    </div>
                                    <svg class="w-5 h-5 text-blue-400 group-hover:text-blue-600 ml-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path>
                                    </svg>
                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php elseif($assignment->type === 'practical' && $assignment->candidate_tool && !$assignment->canStudentViewCandidateTool()): ?>
                    <div class="bg-blue-50 border border-blue-200 rounded-lg p-6">
                        <div class="flex items-center gap-2 mb-2">
                            <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <h2 class="text-lg font-semibold text-blue-900">Candidate Tool</h2>
                        </div>
                        <p class="text-sm text-blue-700">The Candidate Tool will be available on <?php echo e($assignment->start_date->format('M d, Y')); ?> at <?php echo e($assignment->start_date->format('H:i')); ?>.</p>
                    </div>
                <?php endif; ?>

                <!-- View Practical Marks (if results released) -->
                <?php if($assignment->type === 'practical' && $assignment->results_released): ?>
                    <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-6 mb-6">
                        <div class="flex items-center justify-between">
                            <div>
                                <h2 class="text-lg font-semibold text-gray-900">Your Practical Marks</h2>
                                <p class="text-sm text-gray-600 mt-1">View your practical assessment results</p>
                            </div>
                            <a href="<?php echo e(route('student.assignments.practical-marks', $assignment)); ?>" 
                               class="inline-flex items-center px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700 text-sm font-medium">
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                                </svg>
                                View Marks
                            </a>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Assessor Tool (only visible after grading) -->
                <?php if($submission && $submission->completed_assessor_tool_path && $assignment->canStudentViewAssessorTool(auth()->id())): ?>
                    <div class="bg-white rounded-lg shadow-sm border-2 border-green-200 p-6 mt-6">
                        <div class="flex items-center gap-2 mb-4">
                            <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                            </svg>
                            <h2 class="text-lg font-semibold text-gray-900">Assessor Tool</h2>
                            <span class="ml-auto px-2 py-1 text-xs font-medium bg-green-100 text-green-700 rounded-full">Marking Guide</span>
                        </div>
                        <p class="text-sm text-gray-600 mb-4">You can now view the marking guide used to assess your work.</p>
                        <div class="space-y-2">
                            <a href="<?php echo e(route('student.assignments.tool.download', ['assignment' => $assignment->id, 'toolType' => 'assessor', 'index' => 0])); ?>" 
                               class="flex items-center justify-between p-4 border-2 border-green-200 rounded-lg hover:border-green-400 hover:bg-green-50 transition-all group">
                                <div class="flex items-center flex-1 min-w-0">
                                    <div class="flex-shrink-0 mr-3">
                                        <svg class="w-6 h-6 text-green-400 group-hover:text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                        </svg>
                                    </div>
                                    <div class="flex-1 min-w-0">
                                        <p class="text-sm font-medium text-gray-900 truncate">
                                            <?php echo e(basename($submission->completed_assessor_tool_path)); ?>

                                        </p>
                                        <p class="text-xs text-green-600 mt-0.5">Completed Assessor Tool (with Marks)</p>
                                    </div>
                                </div>
                                <svg class="w-5 h-5 text-green-400 group-hover:text-green-600 ml-3 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path>
                                </svg>
                            </a>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>

        <!-- Submission Form / Status Card -->
        <div class="lg:col-span-1 order-first lg:order-last">
            <div class="bg-white rounded-lg shadow-sm border border-gray-200 p-4 sm:p-6 lg:sticky lg:top-6">
                <div class="flex items-center gap-2 mb-6">
                    <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    <h2 class="text-lg font-semibold text-gray-900">Your Submission</h2>
                </div>
                
                <?php if($submission->isGraded()): ?>
                    <div class="mb-6 p-4 bg-gradient-to-br from-green-50 to-green-100 border-2 border-green-200 rounded-lg">
                        <div class="flex items-center gap-2 mb-2">
                            <svg class="w-5 h-5 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <p class="text-sm font-semibold text-green-800">Graded</p>
                        </div>
                        <?php if($submission->marks !== null): ?>
                            <div class="mt-3">
                                <p class="text-3xl font-bold text-green-900">
                                    <?php echo e($submission->marks); ?>/<?php echo e($assignment->total_marks ?? 'N/A'); ?>

                                </p>
                                <?php if($assignment->total_marks): ?>
                                    <?php
                                        $percentage = round(($submission->marks / $assignment->total_marks) * 100);
                                    ?>
                                    <p class="text-sm text-green-700 mt-1"><?php echo e($percentage); ?>%</p>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        <?php if($submission->trainer_feedback): ?>
                            <div class="mt-4 pt-4 border-t border-green-200">
                                <p class="text-xs font-medium text-green-800 mb-2">Trainer Feedback:</p>
                                <p class="text-sm text-gray-700 leading-relaxed"><?php echo e($submission->trainer_feedback); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php elseif($assignment->start_date && !$assignment->isAvailableForStudents()): ?>
                    <div class="mb-6 p-4 bg-gradient-to-br from-blue-50 to-blue-100 border-2 border-blue-200 rounded-lg">
                        <div class="flex items-center gap-2 mb-2">
                            <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <p class="text-sm font-semibold text-blue-800">Assignment Not Yet Available</p>
                        </div>
                        <p class="text-sm text-blue-700 mt-2">This assignment will be available on:</p>
                        <p class="text-sm font-semibold text-blue-900 mt-1"><?php echo e($assignment->start_date->format('M d, Y')); ?> at <?php echo e($assignment->start_date->format('H:i')); ?></p>
                    </div>
                <?php endif; ?>

                
                <?php if($assignment->isOverdue() && !$submission->isGraded()): ?>
                    <div class="mb-4 p-4 bg-red-50 border-2 border-red-200 rounded-lg">
                        <div class="flex items-center gap-2 mb-2">
                            <svg class="w-5 h-5 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                            </svg>
                            <p class="text-sm font-semibold text-red-800">Submissions Closed</p>
                        </div>
                        <p class="text-sm text-red-700">
                            The due date for this assignment has passed. You can no longer submit or update your work for this assessment.
                        </p>
                    </div>
                <?php elseif($assignment->type === 'practical'): ?>
                    <!-- Practical Assignment - No Submission Required -->
                    <div class="mb-6 p-4 bg-gradient-to-br from-amber-50 to-amber-100 border-2 border-amber-200 rounded-lg">
                        <div class="flex items-center gap-2 mb-2">
                            <svg class="w-5 h-5 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <p class="text-sm font-semibold text-amber-800">No Submission Required</p>
                        </div>
                        <p class="text-sm text-amber-700 mt-2">
                            This is a practical assessment. No file submission is required from students. The trainer will assess your performance directly.
                        </p>

                        <?php if($submission && $submission->exists && $submission->marking_status === 'absent'): ?>
                            <div class="mt-4 p-3 rounded-md border border-red-200 bg-red-50">
                                <p class="text-xs font-semibold text-red-700 uppercase tracking-wide">
                                    Assessed but Absent (AB)
                                </p>
                                <p class="mt-1 text-sm text-red-700">
                                    You were assessed for this practical but recorded as <strong>absent</strong>. Please consult your trainer if you have any questions.
                                </p>
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Disabled Submission Form for Practicals -->
                    <form action="#" method="POST" enctype="multipart/form-data" class="opacity-60 pointer-events-none">
                        <?php echo csrf_field(); ?>
                        
                        <div class="space-y-5">
                            <div>
                                <label class="block text-sm font-medium text-gray-500 mb-2 flex items-center gap-2">
                                    <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                    </svg>
                                    Feedback / Response
                                </label>
                                <textarea name="feedback" rows="6" 
                                          disabled
                                          class="w-full rounded-lg border-gray-300 bg-gray-100 text-gray-500 cursor-not-allowed" 
                                          placeholder="Not available for practical assessments"></textarea>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-500 mb-2 flex items-center gap-2">
                                    <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path>
                                    </svg>
                                    Attachments
                                </label>
                                <div class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-200 border-dashed rounded-lg bg-gray-50">
                                    <div class="space-y-1 text-center">
                                        <svg class="mx-auto h-12 w-12 text-gray-300" stroke="currentColor" fill="none" viewBox="0 0 48 48">
                                            <path d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                        <p class="text-sm text-gray-400">File upload not available for practical assessments</p>
                                    </div>
                                </div>
                            </div>

                            <div class="flex flex-col gap-2">
                                <button type="button" disabled
                                        class="w-full px-4 py-3 bg-gray-200 text-gray-500 rounded-lg cursor-not-allowed text-sm font-medium flex items-center justify-center gap-2">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636"></path>
                                    </svg>
                                    Submission Disabled
                                </button>
                            </div>
                        </div>
                    </form>
                <?php else: ?>
                    <!-- Regular Assignment - Submission Form -->
                    <form action="<?php echo e(route('student.assignments.submit', $assignment)); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        
                        <div class="space-y-5">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2 flex items-center gap-2">
                                    <svg class="w-4 h-4 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                    </svg>
                                    Feedback / Response
                                </label>
                                <textarea name="feedback" rows="6" 
                                          class="w-full rounded-lg border-gray-300 shadow-sm focus:border-green-500 focus:ring-green-500 transition-colors" 
                                          placeholder="Enter your feedback or response here..."><?php echo e(old('feedback', $submission->feedback)); ?></textarea>
                                <?php $__errorArgs = ['feedback'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2 flex items-center gap-2">
                                    <svg class="w-4 h-4 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path>
                                    </svg>
                                    Attachments
                                </label>
                                <div class="mt-1 flex justify-center px-6 pt-5 pb-6 border-2 border-gray-300 border-dashed rounded-lg hover:border-green-400 transition-colors">
                                    <div class="space-y-1 text-center">
                                        <svg class="mx-auto h-12 w-12 text-gray-400" stroke="currentColor" fill="none" viewBox="0 0 48 48">
                                            <path d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                        <div class="flex text-sm text-gray-600">
                                            <label for="file-upload" class="relative cursor-pointer bg-white rounded-md font-medium text-green-600 hover:text-green-500 focus-within:outline-none focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-green-500">
                                                <span>Upload files</span>
                                                <input id="file-upload" name="attachments[]" type="file" multiple class="sr-only">
                                            </label>
                                            <p class="pl-1">or drag and drop</p>
                                        </div>
                                        <p class="text-xs text-gray-500">Multiple files up to 10MB each</p>
                                    </div>
                                </div>
                                <?php $__errorArgs = ['attachments.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <?php if($submission->attachments && count($submission->attachments) > 0): ?>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2 flex items-center gap-2">
                                        <svg class="w-4 h-4 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                        </svg>
                                        Current Attachments (<?php echo e(count($submission->attachments)); ?>)
                                    </label>
                                    <div class="space-y-2">
                                        <?php $__currentLoopData = $submission->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="flex items-center justify-between p-3 bg-gray-50 border border-gray-200 rounded-lg">
                                                <div class="flex items-center flex-1 min-w-0">
                                                    <svg class="w-4 h-4 text-gray-400 mr-2 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                                    </svg>
                                                    <span class="text-sm text-gray-700 truncate"><?php echo e(basename($attachment)); ?></span>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <div class="flex flex-col gap-2">
                                <?php if($assignment->start_date && !$assignment->isAvailableForStudents()): ?>
                                    <button type="button" disabled
                                            class="w-full px-4 py-3 bg-gray-200 text-gray-500 rounded-lg cursor-not-allowed text-sm font-medium flex items-center justify-center gap-2">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                        </svg>
                                        Not Available Yet
                                    </button>
                                <?php else: ?>
                                    <button type="submit" name="status" value="submitted" 
                                            class="w-full px-4 py-3 bg-green-600 text-white rounded-lg hover:bg-green-700 text-sm font-semibold transition-colors flex items-center justify-center gap-2 shadow-sm">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                                        </svg>
                                        <?php echo e($submission->isSubmitted() ? 'Update Submission' : 'Submit Assignment'); ?>

                                    </button>
                                    <button type="submit" name="status" value="draft" 
                                            class="w-full px-4 py-2 bg-gray-100 text-gray-700 rounded-lg hover:bg-gray-200 text-sm font-medium transition-colors">
                                        Save as Draft
                                    </button>
                                <?php endif; ?>
                            </div>

                            <?php if($submission->submitted_at): ?>
                                <p class="text-xs text-gray-500 text-center">
                                    Submitted: <?php echo e($submission->submitted_at->format('M d, Y H:i')); ?>

                                </p>
                            <?php endif; ?>
                        </div>
                    </form>
                <?php endif; ?>

                <!-- Assignment Info -->
                <div class="mt-6 pt-6 border-t border-gray-200">
                    <h3 class="text-sm font-semibold text-gray-900 mb-3">Assignment Details</h3>
                    <div class="space-y-3">
                        <?php if($assignment->total_marks): ?>
                            <div class="flex items-center justify-between p-2 bg-gray-50 rounded">
                                <span class="text-sm text-gray-600 flex items-center gap-2">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                                    </svg>
                                    Total Marks
                                </span>
                                <span class="font-semibold text-gray-900"><?php echo e($assignment->total_marks); ?></span>
                            </div>
                        <?php endif; ?>
                        <?php if($assignment->due_date): ?>
                            <div class="flex items-center justify-between p-2 <?php echo e($assignment->isOverdue() ? 'bg-red-50' : 'bg-gray-50'); ?> rounded">
                                <span class="text-sm <?php echo e($assignment->isOverdue() ? 'text-red-600' : 'text-gray-600'); ?> flex items-center gap-2">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    Due Date
                                </span>
                                <span class="font-semibold <?php echo e($assignment->isOverdue() ? 'text-red-900' : 'text-gray-900'); ?>">
                                    <?php echo e($assignment->due_date->format('M d, Y')); ?><br>
                                    <span class="text-xs font-normal"><?php echo e($assignment->due_date->format('H:i')); ?></span>
                                </span>
                            </div>
                        <?php endif; ?>
                        <?php if($assignment->trainer): ?>
                            <div class="flex items-center justify-between p-2 bg-gray-50 rounded">
                                <span class="text-sm text-gray-600 flex items-center gap-2">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                    </svg>
                                    Trainer
                                </span>
                                <span class="font-medium text-gray-900"><?php echo e($assignment->trainer->name); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.student', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/student/assignments/show.blade.php ENDPATH**/ ?>