<?php $__env->startSection('title', 'Practical Marks Compilation'); ?>
<?php $__env->startSection('page-title', 'Practical Marks Compilation'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900 mb-2">Practical Marks Compilation</h1>
                <p class="text-gray-600">Assignment: <?php echo e($assignment->title); ?></p>
                <p class="text-sm text-gray-500">Unit: <?php echo e($unit->name); ?> (<?php echo e($unit->code); ?>)</p>
            </div>
            <div class="flex gap-3">
                <a href="<?php echo e(route('trainer.assignments.show', $assignment)); ?>" 
                   class="text-blue-600 hover:text-blue-800 font-medium">
                    ← Back to Assignment
                </a>
            </div>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-1 md:grid-cols-5 gap-4">
        <div class="bg-white rounded-xl shadow-md p-4">
            <p class="text-sm text-gray-600">Total Students</p>
            <p class="text-2xl font-bold text-gray-900"><?php echo e($stats['total_students']); ?></p>
        </div>
        <div class="bg-blue-50 rounded-xl shadow-md p-4 border-l-4 border-blue-500">
            <p class="text-sm text-blue-700">Students Assessed</p>
            <p class="text-2xl font-bold text-blue-900"><?php echo e($stats['assessed'] ?? ($stats['marked'] + $stats['absent'])); ?>/<?php echo e($stats['total_students']); ?></p>
        </div>
        <div class="bg-green-50 rounded-xl shadow-md p-4 border-l-4 border-green-500">
            <p class="text-sm text-green-700">Marked</p>
            <p class="text-2xl font-bold text-green-900"><?php echo e($stats['marked']); ?></p>
        </div>
        <div class="bg-yellow-50 rounded-xl shadow-md p-4 border-l-4 border-yellow-500">
            <p class="text-sm text-yellow-700">Not Marked</p>
            <p class="text-2xl font-bold text-yellow-900"><?php echo e($stats['not_marked']); ?></p>
        </div>
        <div class="bg-red-50 rounded-xl shadow-md p-4 border-l-4 border-red-500">
            <p class="text-sm text-red-700">Assessed but Absent (AB)</p>
            <p class="text-2xl font-bold text-red-900"><?php echo e($stats['absent']); ?></p>
        </div>
    </div>

    <!-- Filters and Actions -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
            <div class="flex flex-wrap gap-3">
                <form method="GET" action="<?php echo e(route('trainer.practical-marks.index', $assignment)); ?>" class="flex gap-2">
                    <select name="status" onchange="this.form.submit()" class="rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="all" <?php echo e($statusFilter === 'all' ? 'selected' : ''); ?>>All Status</option>
                        <option value="marked" <?php echo e($statusFilter === 'marked' ? 'selected' : ''); ?>>Marked</option>
                        <option value="not_marked" <?php echo e($statusFilter === 'not_marked' ? 'selected' : ''); ?>>Not Marked</option>
                        <option value="absent" <?php echo e($statusFilter === 'absent' ? 'selected' : ''); ?>>Absent</option>
                    </select>
                    <select name="sort" onchange="this.form.submit()" class="rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        <option value="name" <?php echo e($sortBy === 'name' ? 'selected' : ''); ?>>Sort by Name</option>
                        <option value="marks" <?php echo e($sortBy === 'marks' ? 'selected' : ''); ?>>Sort by Marks</option>
                    </select>
                </form>
            </div>
            <div class="flex gap-2">
                <button onclick="exportPDF()" class="px-4 py-2 bg-red-600 text-white rounded-md hover:bg-red-700 text-sm font-medium">
                    Export PDF
                </button>
                <button onclick="exportExcel()" class="px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700 text-sm font-medium">
                    Export Excel
                </button>
            </div>
        </div>
    </div>

    <!-- Marks Table -->
    <div class="bg-white rounded-xl shadow-md overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">#</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Student Name</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Admission Number</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Class</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Marks</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $compiledMarks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e($index + 1); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo e($item['student']->name); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600"><?php echo e($item['student']->admission_number ?? 'N/A'); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-600"><?php echo e($item['class']->name ?? 'N/A'); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-center">
                                <?php if($item['marking_status'] === 'marked'): ?>
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">Marked</span>
                                <?php elseif($item['marking_status'] === 'absent'): ?>
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">Assessed but Absent (AB)</span>
                                <?php else: ?>
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">Not Marked</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-center text-sm font-medium text-gray-900">
                                <?php if($item['marking_status'] === 'absent'): ?>
                                    <span class="font-bold text-red-600">AB</span>
                                <?php else: ?>
                                    <?php echo e($item['marks'] > 0 ? number_format($item['marks'], 2) : '0.00'); ?> / <?php echo e(number_format($assignment->total_marks, 2)); ?>

                                <?php endif; ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-center text-sm">
                                <?php if($item['marking_status'] === 'not_marked'): ?>
                                    <a href="<?php echo e(route('trainer.assessor-tool.marking.submission', ['assignment' => $assignment, 'submissionId' => $item['submission']->id ?? 'new'])); ?>" 
                                       class="text-blue-600 hover:text-blue-900 font-medium">Mark</a>
                                    <span class="mx-2">|</span>
                                    <form action="<?php echo e(route('trainer.practical-marks.mark-absent', $assignment)); ?>" method="POST" class="inline" onsubmit="return confirm('Mark this student as absent?');">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="student_id" value="<?php echo e($item['student']->id); ?>">
                                        <button type="submit" class="text-red-600 hover:text-red-900 font-medium">Mark Absent</button>
                                    </form>
                                <?php elseif($item['marking_status'] === 'absent'): ?>
                                    <form action="<?php echo e(route('trainer.practical-marks.remove-absent', $assignment)); ?>" method="POST" class="inline" onsubmit="return confirm('Remove absent status?');">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="student_id" value="<?php echo e($item['student']->id); ?>">
                                        <button type="submit" class="text-blue-600 hover:text-blue-900 font-medium">Remove Absent</button>
                                    </form>
                                    <span class="mx-2">|</span>
                                    <a href="<?php echo e(route('trainer.assessor-tool.marking.submission', ['assignment' => $assignment, 'submissionId' => $item['submission']->id ?? 'new'])); ?>" 
                                       class="text-blue-600 hover:text-blue-900 font-medium">Mark</a>
                                <?php else: ?>
                                    <a href="<?php echo e(route('trainer.assessor-tool.marking.submission', ['assignment' => $assignment, 'submissionId' => $item['submission']->id])); ?>" 
                                       class="text-blue-600 hover:text-blue-900 font-medium">View/Edit</a>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="px-6 py-8 text-center text-gray-500">No students found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
function exportPDF() {
    window.location.href = '<?php echo e(route("trainer.practical-marks.export", ["assignment" => $assignment, "format" => "pdf"])); ?>';
}

function exportExcel() {
    window.location.href = '<?php echo e(route("trainer.practical-marks.export", ["assignment" => $assignment, "format" => "excel"])); ?>';
}
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.trainer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/trainer/practical-marks/index.blade.php ENDPATH**/ ?>