<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps(['sidebar-open' => 'sidebarOpen']) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps(['sidebar-open' => 'sidebarOpen']); ?>
<?php foreach (array_filter((['sidebar-open' => 'sidebarOpen']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<header class="bg-white shadow-sm border-b border-gray-200">
    <div class="flex items-center justify-between px-3 sm:px-4 lg:px-6 py-3 sm:py-4 gap-2 min-h-[44px] sm:min-h-0">
        <div class="flex items-center min-w-0 flex-1">
            <button type="button" @click="<?php echo e($sidebarOpen); ?> = !<?php echo e($sidebarOpen); ?>" aria-label="Open menu" class="md:hidden p-2 -ml-2 text-gray-500 hover:text-gray-700 focus:outline-none focus:ring-2 focus:ring-blue-500 rounded-lg touch-manipulation">
                <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                </svg>
            </button>
            <h2 class="text-base sm:text-lg lg:text-xl font-semibold text-gray-800 truncate ml-1 sm:ml-0">
                <?php echo $__env->yieldContent('page-title', 'Dashboard'); ?>
            </h2>
        </div>

        <div class="flex items-center space-x-2 sm:space-x-4">
            <!-- Notifications -->
            <button class="relative p-2 text-gray-400 hover:text-gray-500 focus:outline-none">
                <svg class="h-5 w-5 sm:h-6 sm:w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                </svg>
                <span class="absolute top-1 right-1 block h-2 w-2 rounded-full bg-red-400 ring-2 ring-white"></span>
            </button>

            <!-- User Dropdown -->
            <div class="relative" x-data="{ open: false }">
                <button type="button" @click="open = !open" class="flex items-center space-x-2 sm:space-x-3 text-sm focus:outline-none focus:ring-2 focus:ring-blue-500 rounded-full p-1 touch-manipulation">
                    <div class="h-8 w-8 sm:h-9 sm:w-9 rounded-full bg-blue-600 flex items-center justify-center flex-shrink-0">
                        <span class="text-white font-semibold text-xs sm:text-sm"><?php echo e(substr(auth()->user()->name, 0, 1)); ?></span>
                    </div>
                    <div class="hidden sm:block text-left">
                        <p class="text-sm font-medium text-gray-700 truncate max-w-[120px]"><?php echo e(auth()->user()->name); ?></p>
                        <p class="text-xs text-gray-500">Trainer</p>
                    </div>
                    <svg class="h-4 w-4 text-gray-400 hidden sm:block" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                    </svg>
                </button>

                <div x-show="open" @click.away="open = false" x-transition class="absolute right-0 mt-2 w-48 max-w-[calc(100vw-2rem)] bg-white rounded-md shadow-lg py-1 z-50 border border-gray-200">
                    <a href="<?php echo e(route('profile.edit')); ?>" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Profile</a>
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="block w-full text-left px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Logout</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</header>

<?php /**PATH D:\poe\resources\views/components/trainer-header.blade.php ENDPATH**/ ?>