<?php $__env->startSection('title', 'All Submissions'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-900">All Submissions</h1>
        <p class="mt-1 text-sm text-gray-600">View all student submissions (PoE portfolios and assignments)</p>
    </div>

    <?php if($activeTerm): ?>
        <div class="mb-6 p-4 bg-blue-50 border border-blue-200 rounded-lg">
            <p class="text-sm text-blue-800"><strong>Active Term:</strong> <?php echo e($activeTerm->name); ?></p>
        </div>
    <?php endif; ?>

    <!-- Filters -->
    <div class="bg-white rounded-lg shadow mb-6 p-4">
        <form method="GET" class="grid grid-cols-1 md:grid-cols-5 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Student name or email"
                       class="w-full rounded-md border-gray-300 shadow-sm">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                <select name="status" class="w-full rounded-md border-gray-300 shadow-sm">
                    <option value="">All Statuses</option>
                    <option value="draft" <?php echo e(request('status') == 'draft' ? 'selected' : ''); ?>>Draft</option>
                    <option value="submitted" <?php echo e(request('status') == 'submitted' ? 'selected' : ''); ?>>Submitted</option>
                    <option value="trainer_approved" <?php echo e(request('status') == 'trainer_approved' ? 'selected' : ''); ?>>Approved</option>
                    <option value="rejected" <?php echo e(request('status') == 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Unit</label>
                <select name="unit" class="w-full rounded-md border-gray-300 shadow-sm">
                    <option value="">All Units</option>
                    <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($unit->id); ?>" <?php echo e(request('unit') == $unit->id ? 'selected' : ''); ?>><?php echo e($unit->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Class</label>
                <select name="class" class="w-full rounded-md border-gray-300 shadow-sm">
                    <option value="">All Classes</option>
                    <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($class->id); ?>" <?php echo e(request('class') == $class->id ? 'selected' : ''); ?>><?php echo e($class->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="flex items-end">
                <button type="submit" class="w-full bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700">Filter</button>
            </div>
        </form>
    </div>

    <!-- Submissions Table -->
    <div class="bg-white shadow rounded-lg overflow-hidden">
        <?php if($submissions->count() > 0): ?>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Student</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Unit</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Class</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Marks</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Submitted</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__currentLoopData = $submissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900"><?php echo e($submission->student->name); ?></div>
                                    <div class="text-sm text-gray-500"><?php echo e($submission->student->email); ?></div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-900"><?php echo e($submission->unit->name); ?></div>
                                    <?php if($submission->unit->code): ?>
                                        <div class="text-sm text-gray-500"><?php echo e($submission->unit->code); ?></div>
                                    <?php endif; ?>
                                    <?php if(isset($submission->submission_type) && $submission->submission_type === 'assignment'): ?>
                                        <div class="text-xs text-blue-600 mt-1">Assignment</div>
                                    <?php else: ?>
                                        <div class="text-xs text-purple-600 mt-1">PoE</div>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    <?php echo e($submission->schoolClass ? $submission->schoolClass->name : '-'); ?>

                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <?php
                                        $status = $submission->status ?? 'draft';
                                        if (isset($submission->submission_type) && $submission->submission_type === 'assignment') {
                                            // Map assignment status to display
                                            $statusMap = [
                                                'draft' => 'draft',
                                                'submitted' => 'submitted',
                                                'graded' => 'graded',
                                            ];
                                            $status = $statusMap[$status] ?? $status;
                                        }
                                    ?>
                                    <span class="px-2 py-1 text-xs rounded-full 
                                        <?php if($status === 'trainer_approved' || $status === 'graded'): ?> bg-green-100 text-green-800
                                        <?php elseif($status === 'rejected'): ?> bg-red-100 text-red-800
                                        <?php elseif($status === 'needs_revision'): ?> bg-yellow-100 text-yellow-800
                                        <?php elseif($status === 'submitted'): ?> bg-blue-100 text-blue-800
                                        <?php else: ?> bg-gray-100 text-gray-800
                                        <?php endif; ?>">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $status))); ?>

                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    <?php if(isset($submission->submission_type) && $submission->submission_type === 'assignment'): ?>
                                        <?php if($submission->marks): ?>
                                            <?php echo e(number_format($submission->marks, 2)); ?><?php echo e($submission->assignment->total_marks ? '/' . $submission->assignment->total_marks : ''); ?>

                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    <?php echo e($submission->display_submitted_at ? $submission->display_submitted_at->format('M d, Y') : ($submission->submitted_at ? $submission->submitted_at->format('M d, Y') : '-')); ?>

                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                    <?php if(isset($submission->submission_type) && $submission->submission_type === 'assignment' && isset($submission->assignment)): ?>
                                        <a href="<?php echo e(route('trainer.assignments.show', $submission->assignment->id)); ?>" class="text-blue-600 hover:text-blue-900">View Assignment</a>
                                    <?php elseif(!isset($submission->submission_type) || $submission->submission_type === 'poe'): ?>
                                        <a href="<?php echo e(route('trainer.submissions.show', $submission)); ?>" class="text-blue-600 hover:text-blue-900">View</a>
                                    <?php else: ?>
                                        <span class="text-gray-400">-</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
            <div class="px-6 py-4 border-t">
                <?php echo e($submissions->links()); ?>

            </div>
        <?php else: ?>
            <div class="p-8 text-center">
                <p class="text-sm text-gray-500">No submissions found.</p>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.trainer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/trainer/submissions/index.blade.php ENDPATH**/ ?>