

<?php $__env->startSection('title', 'Audit Log Details'); ?>
<?php $__env->startSection('page-title', 'Audit Log Details'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-6">
        <a href="<?php echo e(route('admin.audit-logs.index')); ?>" class="text-indigo-600 hover:text-indigo-900 flex items-center">
            <svg class="h-5 w-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
            Back to Audit Logs
        </a>
    </div>

    <div class="bg-white shadow-sm rounded-lg overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
            <h3 class="text-lg font-semibold text-gray-900">Audit Log Details</h3>
        </div>
        <div class="px-6 py-4">
            <dl class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <dt class="text-sm font-medium text-gray-500">ID</dt>
                    <dd class="mt-1 text-sm text-gray-900">#<?php echo e($auditLog->id); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Timestamp</dt>
                    <dd class="mt-1 text-sm text-gray-900">
                        <?php echo e($auditLog->created_at->format('F d, Y h:i:s A')); ?>

                    </dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">User</dt>
                    <dd class="mt-1">
                        <?php if($auditLog->user): ?>
                            <div class="flex items-center">
                                <div class="h-8 w-8 rounded-full bg-indigo-600 flex items-center justify-center mr-2">
                                    <span class="text-white font-semibold text-xs"><?php echo e(substr($auditLog->user->name, 0, 1)); ?></span>
                                </div>
                                <div>
                                    <div class="text-sm font-medium text-gray-900"><?php echo e($auditLog->user->name); ?></div>
                                    <div class="text-xs text-gray-500"><?php echo e($auditLog->user->email); ?></div>
                                </div>
                            </div>
                        <?php else: ?>
                            <span class="text-sm text-gray-400">System</span>
                        <?php endif; ?>
                    </dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Action</dt>
                    <dd class="mt-1">
                        <span class="px-3 py-1 text-sm font-semibold rounded-full
                            <?php if(in_array($auditLog->action, ['created', 'approved', 'validated'])): ?> bg-green-100 text-green-800
                            <?php elseif(in_array($auditLog->action, ['deleted', 'rejected'])): ?> bg-red-100 text-red-800
                            <?php elseif(in_array($auditLog->action, ['updated', 'modified'])): ?> bg-blue-100 text-blue-800
                            <?php else: ?> bg-gray-100 text-gray-800
                            <?php endif; ?>">
                            <?php echo e(ucfirst($auditLog->action)); ?>

                        </span>
                    </dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Model Type</dt>
                    <dd class="mt-1 text-sm text-gray-900">
                        <?php echo e($auditLog->model_type ? class_basename($auditLog->model_type) : '-'); ?>

                    </dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Model ID</dt>
                    <dd class="mt-1 text-sm text-gray-900">
                        <?php echo e($auditLog->model_id ?? '-'); ?>

                        <?php if($relatedModel): ?>
                            <a href="#" class="ml-2 text-indigo-600 hover:text-indigo-900 text-xs">View Model</a>
                        <?php endif; ?>
                    </dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">IP Address</dt>
                    <dd class="mt-1 text-sm text-gray-900"><?php echo e($auditLog->ip_address ?? '-'); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">User Agent</dt>
                    <dd class="mt-1 text-sm text-gray-500 text-xs break-all"><?php echo e(request()->userAgent() ?? '-'); ?></dd>
                </div>
                <?php if($auditLog->description): ?>
                    <div class="md:col-span-2">
                        <dt class="text-sm font-medium text-gray-500 mb-1">Description</dt>
                        <dd class="text-sm text-gray-900 bg-gray-50 p-3 rounded"><?php echo e($auditLog->description); ?></dd>
                    </div>
                <?php endif; ?>
            </dl>

            <!-- Changes -->
            <?php if($auditLog->changes && count($auditLog->changes) > 0): ?>
                <div class="mt-6 pt-6 border-t border-gray-200">
                    <h4 class="text-sm font-semibold text-gray-900 mb-4">Changes</h4>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="space-y-3">
                            <?php $__currentLoopData = $auditLog->changes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field => $change): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="border-l-4 border-indigo-500 pl-4">
                                    <div class="flex items-center justify-between">
                                        <span class="text-sm font-medium text-gray-900"><?php echo e(ucfirst(str_replace('_', ' ', $field))); ?></span>
                                    </div>
                                    <?php if(is_array($change)): ?>
                                        <?php if(isset($change['old']) && isset($change['new'])): ?>
                                            <div class="mt-1 grid grid-cols-2 gap-2 text-xs">
                                                <div>
                                                    <span class="text-red-600 font-medium">Old:</span>
                                                    <span class="text-gray-600 ml-1"><?php echo e(is_array($change['old']) ? json_encode($change['old']) : $change['old']); ?></span>
                                                </div>
                                                <div>
                                                    <span class="text-green-600 font-medium">New:</span>
                                                    <span class="text-gray-600 ml-1"><?php echo e(is_array($change['new']) ? json_encode($change['new']) : $change['new']); ?></span>
                                                </div>
                                            </div>
                                        <?php else: ?>
                                            <pre class="mt-1 text-xs text-gray-600"><?php echo e(json_encode($change, JSON_PRETTY_PRINT)); ?></pre>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <div class="mt-1 text-xs text-gray-600"><?php echo e($change); ?></div>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Related Model Info -->
            <?php if($relatedModel): ?>
                <div class="mt-6 pt-6 border-t border-gray-200">
                    <h4 class="text-sm font-semibold text-gray-900 mb-4">Related Model</h4>
                    <div class="bg-blue-50 rounded-lg p-4">
                        <p class="text-sm text-gray-700">
                            <strong>Type:</strong> <?php echo e(class_basename($auditLog->model_type)); ?><br>
                            <strong>ID:</strong> <?php echo e($auditLog->model_id); ?><br>
                            <strong>Status:</strong> <span class="text-green-600">Exists</span>
                        </p>
                    </div>
                </div>
            <?php elseif($auditLog->model_type && $auditLog->model_id): ?>
                <div class="mt-6 pt-6 border-t border-gray-200">
                    <div class="bg-yellow-50 rounded-lg p-4">
                        <p class="text-sm text-yellow-800">
                            <strong>Note:</strong> The related model (<?php echo e(class_basename($auditLog->model_type)); ?> #<?php echo e($auditLog->model_id); ?>) no longer exists. It may have been deleted.
                        </p>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/admin/audit-logs/show.blade.php ENDPATH**/ ?>