<?php $__env->startSection('title', 'Edit Assignment'); ?>
<?php $__env->startSection('page-title', 'Edit Assignment'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto">
    <div class="mb-6">
        <a href="<?php echo e(request('context') === 'departmental' ? route('hod.units.show', [$assignment->unit, 'context' => 'departmental']) : route('hod.units.show', $assignment->unit)); ?>" class="text-purple-600 hover:text-purple-900 flex items-center mb-4">
            <svg class="h-5 w-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
            Back to Unit
        </a>
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Edit Assignment</h1>
                <p class="mt-1 text-sm text-gray-500">Unit: <?php echo e($assignment->unit->name); ?> (<?php echo e($assignment->unit->code); ?>)</p>
            </div>
            <a href="<?php echo e(route('hod.assignments.show', $assignment)); ?>" 
               class="inline-flex items-center px-4 py-2 bg-gray-200 text-gray-700 text-sm font-medium rounded-md hover:bg-gray-300">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                </svg>
                Cancel
            </a>
        </div>
    </div>

    <form action="<?php echo e(route('hod.assignments.update', $assignment)); ?>" method="POST" enctype="multipart/form-data" class="bg-white rounded-lg shadow p-6">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        
        <div class="space-y-6">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Title *</label>
                <input type="text" name="title" value="<?php echo e(old('title', $assignment->title)); ?>" required 
                       class="block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Type *</label>
                <select name="type" id="assignment_type" required 
                        class="block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500" 
                        onchange="togglePracticalFields()">
                    <option value="assignment" <?php echo e($assignment->type === 'assignment' ? 'selected' : ''); ?>>Assignment</option>
                    <option value="exam" <?php echo e($assignment->type === 'exam' ? 'selected' : ''); ?>>Exam</option>
                    <option value="practical" <?php echo e($assignment->type === 'practical' ? 'selected' : ''); ?>>Practical</option>
                    <option value="project" <?php echo e($assignment->type === 'project' ? 'selected' : ''); ?>>Project</option>
                </select>
                <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                <textarea name="description" rows="3" 
                          class="block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500"><?php echo e(old('description', $assignment->description)); ?></textarea>
                <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Total Marks</label>
                    <input type="number" name="total_marks" value="<?php echo e(old('total_marks', $assignment->total_marks)); ?>" min="0" 
                           class="block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                    <?php $__errorArgs = ['total_marks'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Due Date</label>
                    <input type="datetime-local" name="due_date" 
                           value="<?php echo e(old('due_date', $assignment->due_date ? $assignment->due_date->format('Y-m-d\TH:i') : '')); ?>" 
                           class="block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                    <?php $__errorArgs = ['due_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Start Date</label>
                <input type="datetime-local" name="start_date" 
                       value="<?php echo e(old('start_date', $assignment->start_date ? $assignment->start_date->format('Y-m-d\TH:i') : '')); ?>" 
                       class="block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                <?php $__errorArgs = ['start_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Instructions</label>
                <textarea name="instructions" rows="4" 
                          class="block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500"><?php echo e(old('instructions', $assignment->instructions)); ?></textarea>
                <?php $__errorArgs = ['instructions'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            
            <div id="regular_attachments" class="<?php echo e($assignment->type === 'practical' ? 'hidden' : ''); ?>">
                <label class="block text-sm font-medium text-gray-700 mb-2">Attachments</label>
                <?php if($assignment->attachments && count($assignment->attachments) > 0): ?>
                    <div class="mb-2 space-y-2">
                        <?php $__currentLoopData = $assignment->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="flex items-center justify-between p-2 bg-gray-50 rounded">
                                <span class="text-sm text-gray-700"><?php echo e(basename($attachment)); ?></span>
                                <span class="text-xs text-gray-500">Existing file</span>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>
                <input type="file" name="attachments[]" multiple 
                       class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-purple-50 file:text-purple-700 hover:file:bg-purple-100">
                <p class="mt-1 text-xs text-gray-500">You can select multiple files (max 10MB each). New files will replace existing ones.</p>
            </div>

            <div id="practical_tools" class="space-y-4 <?php echo e($assignment->type !== 'practical' ? 'hidden' : ''); ?>">
                <div class="p-4 bg-purple-50 border border-purple-200 rounded-lg">
                    <p class="text-sm font-medium text-purple-900 mb-3">Practical Assessment Tools</p>
                    
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Candidate Tool</label>
                            <?php if($assignment->candidate_tool && count($assignment->candidate_tool) > 0): ?>
                                <div class="mb-2 space-y-2">
                                    <?php $__currentLoopData = $assignment->candidate_tool; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $tool): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="flex items-center justify-between p-2 bg-white rounded">
                                            <span class="text-sm text-gray-700"><?php echo e(basename($tool)); ?></span>
                                            <span class="text-xs text-gray-500">Existing file</span>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>
                            <input type="file" name="candidate_tool[]" multiple 
                                   class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-purple-50 file:text-purple-700 hover:file:bg-purple-100">
                            <p class="mt-2 text-xs text-gray-600">New files will replace existing ones.</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Assessor Tool</label>
                            <?php if($assignment->assessor_tool && count($assignment->assessor_tool) > 0): ?>
                                <div class="mb-2 space-y-2">
                                    <?php $__currentLoopData = $assignment->assessor_tool; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $tool): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="flex items-center justify-between p-2 bg-white rounded">
                                            <span class="text-sm text-gray-700"><?php echo e(basename($tool)); ?></span>
                                            <span class="text-xs text-gray-500">Existing file</span>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>
                            <input type="file" name="assessor_tool[]" multiple 
                                   class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-purple-50 file:text-purple-700 hover:file:bg-purple-100">
                            <p class="mt-2 text-xs text-gray-600">New files will replace existing ones.</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="flex items-center">
                <input type="checkbox" name="is_published" value="1" id="is_published" 
                       <?php echo e(old('is_published', $assignment->is_published) ? 'checked' : ''); ?>

                       class="h-4 w-4 text-purple-600 focus:ring-purple-500 border-gray-300 rounded">
                <label for="is_published" class="ml-2 block text-sm text-gray-900">Publish (visible to students)</label>
            </div>
        </div>
        
        <div class="mt-6 flex justify-end gap-3">
            <a href="<?php echo e(route('hod.assignments.show', $assignment)); ?>" 
               class="px-4 py-2 bg-gray-200 text-gray-800 rounded-md hover:bg-gray-300">
                Cancel
            </a>
            <button type="submit" class="px-4 py-2 bg-purple-600 text-white rounded-md hover:bg-purple-700">
                Update Assignment
            </button>
        </div>
    </form>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
function togglePracticalFields() {
    const assignmentType = document.getElementById('assignment_type').value;
    const regularAttachments = document.getElementById('regular_attachments');
    const practicalTools = document.getElementById('practical_tools');
    
    if (assignmentType === 'practical') {
        regularAttachments.classList.add('hidden');
        practicalTools.classList.remove('hidden');
    } else {
        regularAttachments.classList.remove('hidden');
        practicalTools.classList.add('hidden');
    }
}

document.addEventListener('DOMContentLoaded', function() {
    togglePracticalFields();
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.hod', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/hod/assignments/edit.blade.php ENDPATH**/ ?>