

<?php $__env->startSection('title', 'Unit Details'); ?>
<?php $__env->startSection('page-title', 'Unit Details'); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-7xl mx-auto">
        <div class="bg-white shadow rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-gray-200">
                <div class="flex items-center justify-between">
                    <div>
                        <h2 class="text-2xl font-bold text-gray-900"><?php echo e($unit->name); ?></h2>
                        <p class="mt-1 text-sm text-gray-600">Code: <?php echo e($unit->code); ?> | Department: <?php echo e($unit->department->name ?? 'Not assigned'); ?></p>
                    </div>
                    <div class="flex items-center space-x-3">
                        <a href="<?php echo e(route('admin.units.edit', $unit)); ?>" class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50">
                            Edit Unit
                        </a>
                        <a href="<?php echo e(route('admin.units.index')); ?>" class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50">
                            Back to List
                        </a>
                    </div>
                </div>
            </div>

            <?php if($unit->description): ?>
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-sm font-medium text-gray-700 mb-2">Description</h3>
                    <p class="text-sm text-gray-600"><?php echo e($unit->description); ?></p>
                </div>
            <?php endif; ?>
        </div>

        <!-- Assign Unit to Class -->
        <div class="bg-white shadow rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-semibold text-gray-900">Assign Unit to Class</h3>
                <p class="text-sm text-gray-600 mt-1">One unit can belong to multiple classes</p>
            </div>
            <form action="<?php echo e(route('admin.units.assign-class', $unit)); ?>" method="POST" class="p-6">
                <?php echo csrf_field(); ?>
                <div class="flex items-end space-x-4">
                    <div class="flex-1">
                        <label for="class_id" class="block text-sm font-medium text-gray-700 mb-1">Select Class</label>
                        <select name="class_id" id="class_id" required
                                class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="">Select a Class</option>
                            <?php $__currentLoopData = $allClasses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(!$unit->classes->contains($class->id)): ?>
                                    <option value="<?php echo e($class->id); ?>">
                                        <?php echo e($class->name); ?> - <?php echo e($class->department->name ?? ''); ?> (<?php echo e($class->term->name ?? ''); ?>)
                                    </option>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <button type="submit" class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">
                        Assign to Class
                    </button>
                </div>
            </form>
        </div>

        <!-- Assign Trainer to Unit -->
        <div class="bg-white shadow rounded-lg mb-6">
            <div class="px-6 py-4 border-b border-gray-200">
                <h3 class="text-lg font-semibold text-gray-900">Assign Trainer to Unit</h3>
                <p class="text-sm text-gray-600 mt-1">Assign trainers from the same department to this unit</p>
            </div>
            <form action="<?php echo e(route('admin.units.assign-trainer', $unit)); ?>" method="POST" class="p-6">
                <?php echo csrf_field(); ?>
                <div class="flex items-end space-x-4">
                    <div class="flex-1">
                        <label for="trainer_id" class="block text-sm font-medium text-gray-700 mb-1">Select Trainer</label>
                        <select name="trainer_id" id="trainer_id" required
                                class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="">Select a Trainer</option>
                            <?php $__currentLoopData = $availableTrainers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trainer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(!$unit->trainers->contains($trainer->id)): ?>
                                    <option value="<?php echo e($trainer->id); ?>">
                                        <?php echo e($trainer->name); ?> (<?php echo e($trainer->email); ?>)
                                    </option>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php if($availableTrainers->count() === 0): ?>
                            <p class="mt-1 text-xs text-gray-500">No active trainers available in this department.</p>
                        <?php endif; ?>
                    </div>
                    <button type="submit" class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700" 
                            <?php echo e($availableTrainers->count() === 0 ? 'disabled' : ''); ?>>
                        Assign Trainer
                    </button>
                </div>
            </form>
        </div>

        <!-- Assigned Trainers -->
        <?php if($unit->trainers->count() > 0): ?>
            <div class="bg-white shadow rounded-lg mb-6">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">Assigned Trainers (<?php echo e($unit->trainers->count()); ?>)</h3>
                </div>
                <div class="px-6 py-4">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Trainer Name</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Email</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Department</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                <?php $__currentLoopData = $unit->trainers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trainer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="px-4 py-3 text-sm text-gray-900"><?php echo e($trainer->name); ?></td>
                                        <td class="px-4 py-3 text-sm text-gray-600"><?php echo e($trainer->email); ?></td>
                                        <td class="px-4 py-3 text-sm text-gray-600"><?php echo e($trainer->department->name ?? '-'); ?></td>
                                        <td class="px-4 py-3 text-sm">
                                            <span class="px-2 py-1 text-xs font-semibold rounded-full <?php echo e($trainer->status === 'active' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800'); ?>">
                                                <?php echo e(ucfirst($trainer->status)); ?>

                                            </span>
                                        </td>
                                        <td class="px-4 py-3 text-right text-sm font-medium">
                                            <form action="<?php echo e(route('admin.units.remove-trainer', $unit)); ?>" method="POST" class="inline" onsubmit="return confirm('Remove this trainer from unit?');">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="trainer_id" value="<?php echo e($trainer->id); ?>">
                                                <button type="submit" class="text-red-600 hover:text-red-900">Remove</button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="bg-white shadow rounded-lg mb-6">
                <div class="px-6 py-4 text-center text-sm text-gray-500">
                    This unit has no assigned trainers yet. Use the form above to assign trainers.
                </div>
            </div>
        <?php endif; ?>

        <!-- Assigned Classes -->
        <?php if($unit->classes->count() > 0): ?>
            <div class="bg-white shadow rounded-lg">
                <div class="px-6 py-4 border-b border-gray-200">
                    <h3 class="text-lg font-semibold text-gray-900">Assigned Classes (<?php echo e($unit->classes->count()); ?>)</h3>
                </div>
                <div class="px-6 py-4">
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Class Name</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Term</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Department</th>
                                    <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Level</th>
                                    <th class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                <?php $__currentLoopData = $unit->classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="px-4 py-3 text-sm text-gray-900"><?php echo e($class->name); ?></td>
                                        <td class="px-4 py-3 text-sm text-gray-600"><?php echo e($class->term->name ?? '-'); ?></td>
                                        <td class="px-4 py-3 text-sm text-gray-600"><?php echo e($class->department->name ?? '-'); ?></td>
                                        <td class="px-4 py-3 text-sm text-gray-600"><?php echo e($class->level->name ?? '-'); ?></td>
                                        <td class="px-4 py-3 text-right text-sm font-medium">
                                            <form action="<?php echo e(route('admin.units.remove-class', $unit)); ?>" method="POST" class="inline" onsubmit="return confirm('Remove this unit from class?');">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" name="class_id" value="<?php echo e($class->id); ?>">
                                                <button type="submit" class="text-red-600 hover:text-red-900">Remove</button>
                                            </form>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="bg-white shadow rounded-lg">
                <div class="px-6 py-4 text-center text-sm text-gray-500">
                    This unit is not assigned to any classes yet. Use the form above to assign it to a class.
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/admin/units/show.blade.php ENDPATH**/ ?>