

<?php $__env->startSection('title', 'Pending Approvals'); ?>
<?php $__env->startSection('page-title', 'Pending Approvals'); ?>

<?php $__env->startSection('content'); ?>
<div class="mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Pending Approvals</h1>
    <p class="mt-1 text-sm text-gray-600">Review and approve portfolio submissions from your department</p>
</div>

<?php if($activeTerm): ?>
    <div class="mb-6 p-4 bg-purple-50 border border-purple-200 rounded-lg">
        <p class="text-sm text-purple-800"><strong>Active Term:</strong> <?php echo e($activeTerm->name); ?></p>
    </div>
<?php endif; ?>

<!-- Statistics Cards -->
<?php if(isset($stats)): ?>
<div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
    <a href="<?php echo e(route('hod.approvals.index', ['status' => 'pending'])); ?>" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
        <div class="text-center">
            <p class="text-sm font-medium text-gray-600">Pending</p>
            <p class="text-2xl font-bold text-purple-600"><?php echo e($stats['pending'] ?? 0); ?></p>
        </div>
    </a>
    <a href="<?php echo e(route('hod.approvals.index', ['status' => 'hod_approved'])); ?>" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
        <div class="text-center">
            <p class="text-sm font-medium text-gray-600">Approved</p>
            <p class="text-2xl font-bold text-green-600"><?php echo e($stats['approved'] ?? 0); ?></p>
        </div>
    </a>
    <a href="<?php echo e(route('hod.approvals.index', ['status' => 'rejected'])); ?>" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
        <div class="text-center">
            <p class="text-sm font-medium text-gray-600">Rejected</p>
            <p class="text-2xl font-bold text-red-600"><?php echo e($stats['rejected'] ?? 0); ?></p>
        </div>
    </a>
    <a href="<?php echo e(route('hod.approvals.index', ['status' => ''])); ?>" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
        <div class="text-center">
            <p class="text-sm font-medium text-gray-600">Total</p>
            <p class="text-2xl font-bold text-gray-900"><?php echo e($stats['total'] ?? 0); ?></p>
        </div>
    </a>
</div>
<?php endif; ?>

<!-- Filters -->
<div class="bg-white rounded-lg shadow mb-6 p-4">
    <form method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-4">
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
            <select name="status" class="w-full rounded-md border-gray-300 shadow-sm">
                <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>Pending Approval</option>
                <option value="hod_approved" <?php echo e(request('status') == 'hod_approved' ? 'selected' : ''); ?>>Approved</option>
                <option value="rejected" <?php echo e(request('status') == 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                <option value="" <?php echo e(!request('status') ? 'selected' : ''); ?>>All</option>
            </select>
        </div>
        <?php if(isset($filterOptions['classes']) && $filterOptions['classes']->count() > 0): ?>
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Class</label>
            <select name="class" class="w-full rounded-md border-gray-300 shadow-sm">
                <option value="">All Classes</option>
                <?php $__currentLoopData = $filterOptions['classes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($class->id); ?>" <?php echo e(request('class') == $class->id ? 'selected' : ''); ?>><?php echo e($class->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <?php endif; ?>
        <?php if(isset($filterOptions['units']) && $filterOptions['units']->count() > 0): ?>
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Unit</label>
            <select name="unit" class="w-full rounded-md border-gray-300 shadow-sm">
                <option value="">All Units</option>
                <?php $__currentLoopData = $filterOptions['units']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($unit->id); ?>" <?php echo e(request('unit') == $unit->id ? 'selected' : ''); ?>><?php echo e($unit->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <?php endif; ?>
        <div class="flex items-end gap-2">
            <button type="submit" class="flex-1 bg-purple-600 text-white px-4 py-2 rounded-md hover:bg-purple-700">Filter</button>
            <a href="<?php echo e(route('hod.approvals.index')); ?>" class="px-4 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50">Clear</a>
        </div>
    </form>
</div>

<!-- Submissions Table -->
<div class="bg-white shadow rounded-lg overflow-hidden">
    <?php if($submissions->count() > 0): ?>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Student</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Unit</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Class</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Submitted</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__currentLoopData = $submissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-medium text-gray-900"><?php echo e($submission->student->name); ?></div>
                                <div class="text-sm text-gray-500"><?php echo e($submission->student->email); ?></div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm text-gray-900"><?php echo e($submission->unit->name); ?></div>
                                <?php if($submission->unit->code): ?>
                                    <div class="text-sm text-gray-500"><?php echo e($submission->unit->code); ?></div>
                                <?php endif; ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e($submission->schoolClass->name); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-2 py-1 text-xs font-semibold rounded-full <?php echo e($submission->getStatusBadgeClasses()); ?>">
                                    <?php echo e(ucfirst(str_replace('_', ' ', $submission->status))); ?>

                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                <?php echo e($submission->submitted_at ? $submission->submitted_at->format('M d, Y') : '-'); ?>

                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <a href="<?php echo e(route('hod.approvals.show', $submission)); ?>" class="text-purple-600 hover:text-purple-900">Review</a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="px-6 py-4 border-t border-gray-200">
            <?php echo e($submissions->links()); ?>

        </div>
    <?php else: ?>
        <div class="text-center py-12">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900">No submissions found</h3>
            <p class="mt-1 text-sm text-gray-500">There are no submissions matching your filters.</p>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.hod', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/hod/approvals/index.blade.php ENDPATH**/ ?>