

<?php $__env->startSection('title', 'Create Unit Allocation'); ?>
<?php $__env->startSection('page-title', 'Create Unit Allocation'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <div class="flex items-center justify-between">
            <h1 class="text-2xl font-bold text-gray-900">Create Unit Allocation</h1>
            <a href="<?php echo e(route('hod.unit-allocations.index')); ?>" class="text-purple-600 hover:text-purple-800 font-medium">
                ← Back to Allocations
            </a>
        </div>
    </div>

    <?php if($activeTerm): ?>
        <div class="bg-blue-50 border-l-4 border-blue-400 p-4 rounded-lg">
            <p class="text-blue-800"><strong>Active Term:</strong> <?php echo e($activeTerm->name); ?></p>
        </div>
    <?php endif; ?>

    <!-- Form -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <?php if($errors->any()): ?>
            <div class="mb-6 bg-red-50 border-l-4 border-red-400 p-4 rounded">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-red-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                        </svg>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-sm font-medium text-red-800">Validation Errors</h3>
                        <ul class="mt-2 text-sm text-red-700 list-disc list-inside">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('hod.unit-allocations.store')); ?>" method="POST" x-data="{
            selectedTrainer: '<?php echo e(old('trainer_id')); ?>',
            selectedClass: '<?php echo e(old('class_id')); ?>',
            selectedUnits: <?php echo \Illuminate\Support\Js::from(array_map('intval', old('unit_id', [])))->toHtml() ?>,
            trainers: <?php echo \Illuminate\Support\Js::from($trainers->map(function($t) { return ['id' => $t->id, 'name' => $t->name, 'email' => $t->email]; })->toArray())->toHtml() ?>,
            classes: <?php echo \Illuminate\Support\Js::from($classes->map(function($c) { return ['id' => $c->id, 'name' => $c->name, 'code' => $c->code]; })->toArray())->toHtml() ?>,
            units: <?php echo \Illuminate\Support\Js::from($units->map(function($u) { return ['id' => $u->id, 'name' => $u->name, 'code' => $u->code]; })->toArray())->toHtml() ?>
        }">
            <?php echo csrf_field(); ?>

            <!-- Trainer Selection -->
            <div class="mb-6">
                <label for="trainer_id" class="block text-sm font-medium text-gray-700 mb-2">Select Trainer *</label>
                <select name="trainer_id" id="trainer_id" required x-model="selectedTrainer"
                        class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                    <option value="">Choose a trainer...</option>
                    <template x-for="trainer in trainers" :key="trainer.id">
                        <option :value="trainer.id" x-text="trainer.name + ' (' + trainer.email + ')'"></option>
                    </template>
                </select>
                <?php $__errorArgs = ['trainer_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Class Selection -->
            <div class="mb-6">
                <label for="class_id" class="block text-sm font-medium text-gray-700 mb-2">Select Class *</label>
                <select name="class_id" id="class_id" required x-model="selectedClass"
                        class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                    <option value="">Choose a class...</option>
                    <template x-for="classItem in classes" :key="classItem.id">
                        <option :value="classItem.id" x-text="classItem.name + (classItem.code ? ' (' + classItem.code + ')' : '')"></option>
                    </template>
                </select>
                <?php $__errorArgs = ['class_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Units Selection -->
            <div class="mb-6">
                <label class="block text-sm font-medium text-gray-700 mb-2">Select Units *</label>
                <p class="text-sm text-gray-500 mb-3">Select one or more units to assign to the trainer for the selected class.</p>
                <div class="border border-gray-300 rounded-lg p-4 max-h-64 overflow-y-auto">
                    <template x-if="units.length === 0">
                        <p class="text-sm text-gray-500">No units available for this department.</p>
                    </template>
                    <template x-for="unit in units" :key="unit.id">
                        <label class="flex items-center p-2 hover:bg-gray-50 rounded cursor-pointer">
                            <input type="checkbox" 
                                   :value="unit.id" 
                                   name="unit_id[]"
                                   x-model="selectedUnits"
                                   class="rounded border-gray-300 text-purple-600 focus:ring-purple-500 w-4 h-4 cursor-pointer">
                            <span class="ml-3 text-sm text-gray-900 cursor-pointer" x-text="unit.name + (unit.code ? ' (' + unit.code + ')' : '')"></span>
                        </label>
                    </template>
                </div>
                <?php $__errorArgs = ['unit_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                <p class="mt-2 text-sm text-gray-500">Selected: <span x-text="selectedUnits.length" class="font-semibold"></span> unit(s)</p>
            </div>

            <!-- Submit Button -->
            <div class="flex items-center justify-end gap-4">
                <a href="<?php echo e(route('hod.unit-allocations.index')); ?>" class="text-gray-700 hover:text-gray-900 font-medium">
                    Cancel
                </a>
                <button type="submit" class="bg-purple-600 text-white px-6 py-2 rounded-lg hover:bg-purple-700 transition-colors font-medium">
                    Create Allocation
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.hod', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/hod/unit-allocations/create.blade.php ENDPATH**/ ?>