<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

try {
    $pdo = DB::connection()->getPdo();
    $database = DB::connection()->getDatabaseName();
    $host = config('database.connections.pgsql.host');
    $port = config('database.connections.pgsql.port');
    
    echo "✅ Connection Successful!\n";
    echo "   Host: {$host}\n";
    echo "   Port: {$port}\n";
    echo "   Database: {$database}\n";
    echo "   Driver: PostgreSQL\n";
    
    // Test a simple query
    $result = DB::select('SELECT version() as version');
    echo "\n   PostgreSQL Version: " . $result[0]->version . "\n";
    
} catch (\Exception $e) {
    echo "❌ Connection Failed!\n";
    echo "   Error: " . $e->getMessage() . "\n";
    echo "\n   Please check:\n";
    echo "   1. PostgreSQL service is running\n";
    echo "   2. Database credentials in .env file\n";
    echo "   3. Database exists\n";
}

