<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssessorToolMark extends Model
{
    use HasFactory;

    protected $fillable = [
        'assignment_id',
        'assignment_submission_id',
        'structure_id',
        'row_identifier',
        'section',
        'item_description',
        'marks_available',
        'marks_obtained',
        'comments',
        'display_order',
        'is_subtotal',
        'is_total',
    ];

    protected $casts = [
        'marks_available' => 'decimal:2',
        'marks_obtained' => 'decimal:2',
        'is_subtotal' => 'boolean',
        'is_total' => 'boolean',
        'display_order' => 'integer',
    ];

    // Relationships
    public function assignment()
    {
        return $this->belongsTo(Assignment::class);
    }

    public function submission()
    {
        return $this->belongsTo(AssignmentSubmission::class, 'assignment_submission_id');
    }

    public function structure()
    {
        return $this->belongsTo(AssessorToolStructure::class, 'structure_id');
    }
}
